/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xap.GameMode;
import xap.features.GameModeFeature;
import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.Component;
import xap.gui.Panel;
import xap.gui.Window;

public class HiScoreDialog
extends Window {
    private Panel hiScoresPanel;
    private Panel selectorPanel;
    private CommandButton okButton;
    private Component currentDisplay;
    private final GameMode preferredMode;
    private final ArrayList rows = new ArrayList();
    private final EventHandler eventHandler = new EventHandler();

    public HiScoreDialog(GameMode preferredMode) throws Exception {
        super("Hiscores");
        this.preferredMode = preferredMode;
        this.createGUI();
        this.initEvents();
    }

    private void createGUI() throws Exception {
        this.setSize(600, 430).setBorder(5, 5, 5, 5).centre();
        this.hiScoresPanel = new Panel();
        this.selectorPanel = new Panel();
        this.okButton = new CommandButton("Close");
        this.addChild(this.hiScoresPanel);
        this.addChild(this.selectorPanel);
        this.addChild(this.okButton);
        this.hiScoresPanel.setSize(550, 300).setLocation(25, 40);
        List gameModes = GameModeFeature.getAllGameModes();
        int nextPos = 0;
        Iterator i = gameModes.iterator();
        while (i.hasNext()) {
            final GameMode gameMode = (GameMode)i.next();
            final Component c = gameMode.getHiScoreComponent();
            if (c == null) continue;
            CommandButton button = new CommandButton(gameMode.getDisplay());
            button.addCommandButtonListener(new CommandButtonListener(){

                public boolean selected(CommandButton cb) {
                    HiScoreDialog.this.currentDisplay.setVisible(false);
                    c.setVisible(true);
                    HiScoreDialog.this.setTitle(String.valueOf(gameMode.getDisplay()) + " Hiscores");
                    HiScoreDialog.this.currentDisplay = c;
                    return false;
                }
            });
            this.selectorPanel.addChild(button);
            button.layout();
            button.setX(nextPos);
            nextPos += button.getWidth() + 15;
            if (this.preferredMode == null && gameMode.isDefault() || gameMode == this.preferredMode) {
                this.currentDisplay = c;
                this.setTitle(String.valueOf(gameMode.getDisplay()) + " Hiscores");
                c.requestFocus();
                c.setVisible(true);
            } else {
                c.setVisible(false);
            }
            this.hiScoresPanel.addChild(c);
        }
        this.selectorPanel.pack().centre().setY(370).setClipped(false);
        this.okButton.pack().setWidth(100).setX(250);
    }

    private void initEvents() {
        this.okButton.addCommandButtonListener(this.eventHandler);
    }

    private class EventHandler
    implements CommandButtonListener {
        EventHandler() {
        }

        public boolean selected(CommandButton cb) {
            HiScoreDialog.this.close();
            return false;
        }
    }
}

