/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.StaticSpriteEngine;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.util.Color;
import xap.Game;
import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.Component;
import xap.gui.DragListener;
import xap.gui.Label;
import xap.gui.MouseAdapter;
import xap.gui.TextArea;
import xap.gui.Window;
import xap.resources.HelpResource;
import xap.resources.InstructionResource;

public class HelpWindow
extends Window
implements HelpResource.HelpViewer,
InstructionResource.InstructionViewer {
    private final TextArea taInstructions = new TextArea();
    private CommandButton closeButton = new CommandButton("Close");
    private CommandButton nextButton = new CommandButton("Next");
    private CommandButton prevButton = new CommandButton("Prev");
    private Label coordsLabel;
    private StaticSpriteEngine spriteEngine;
    private ArrayList sprites = new ArrayList(32);
    private static final boolean DEBUG = false;
    private final EventHandler eventHandler = new EventHandler();
    private ArrayList textAreas = new ArrayList(5);

    public HelpWindow() throws Exception {
        super("Instructions");
        Resources.get((String)(Game.isRegistered() ? "help-full" : "help-demo"));
        HelpResource.reset();
        this.createGUI();
        this.initEvents();
        this.open();
    }

    private void createGUI() throws Exception {
        this.setSize(650, 450).setBorder(5, 5, 5, 5);
        this.centre();
        this.addChild(this.closeButton);
        this.addChild(this.prevButton);
        this.addChild(this.nextButton);
        this.closeButton.pack().setWidth(100).setLocation(this.getWidth() - 120, 0);
        this.nextButton.pack().setWidth(100).setLocation(this.closeButton.getX() - 110, 0);
        this.prevButton.pack().setWidth(100).setLocation(this.nextButton.getX() - 110, 0);
        this.spriteEngine = new StaticSpriteEngine(true, 32, Game.getOptions().getTicksPerFrame());
        this.spriteEngine.create();
        this.clear();
        this.next();
    }

    private void initEvents() {
        this.closeButton.addCommandButtonListener(this.eventHandler);
        this.nextButton.addCommandButtonListener(this.eventHandler);
        this.prevButton.addCommandButtonListener(this.eventHandler);
    }

    private void enableControls() {
        this.nextButton.setEnabled(HelpResource.hasMoreInstructions());
        this.prevButton.setEnabled(HelpResource.hasLessInstructions());
    }

    protected boolean doTick() {
        super.doTick();
        this.spriteEngine.tick();
        return true;
    }

    private void next() {
        HelpResource.next(this);
        this.enableControls();
    }

    private void prev() {
        HelpResource.prev(this);
        this.enableControls();
    }

    public void clear() {
        Iterator i = this.textAreas.iterator();
        while (i.hasNext()) {
            this.removeChild((Component)i.next());
        }
        this.textAreas.clear();
        this.spriteEngine.clear();
        this.sprites.clear();
    }

    public InstructionResource.InstructionViewer getInstructionViewer() {
        return this;
    }

    public void addText(String text, int x, int y, int width) {
        TextArea ta = new TextArea(text);
        this.addChild(ta);
        ta.setWidth(width);
        ta.layout();
        ta.setClipped(true);
        ta.setLocation(x, y);
        this.textAreas.add(ta);
    }

    protected void renderForeground() {
        this.spriteEngine.render();
    }

    public void addSprite(SpriteImage spriteImage, Animation animation, int x, int y) {
        Sprite sprite = this.spriteEngine.allocate((Object)this);
        sprite.setLocation(x, y, 0);
        if (spriteImage != null) {
            sprite.setImage(spriteImage);
        } else {
            sprite.setAnimation(animation);
        }
        this.sprites.add(sprite);
    }

    private class EventHandler
    extends MouseAdapter
    implements CommandButtonListener,
    DragListener {
        private int dragOriginX;
        private int dragOriginY;
        private int originalWidth;
        private boolean doingDrag;
        private boolean resizing;
        private Sprite dragSprite;

        EventHandler() {
        }

        public boolean leftButtonClicked(Component src, int x, int y, int clickCount) {
            if (src == HelpWindow.this) {
                int n = HelpWindow.this.sprites.size();
                int i = 0;
                while (i < n) {
                    Sprite s = (Sprite)HelpWindow.this.sprites.get(i);
                    int xx = s.getX();
                    int yy = s.getY();
                    if (x >= xx - 8 && x <= xx + 8 && y >= yy - 8 && y <= yy + 8) {
                        HelpWindow.this.coordsLabel.setText("Sprite[X:" + s.getX() + ", Y:" + s.getY() + "]");
                        HelpWindow.this.coordsLabel.pack();
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            src.setBackgroundColor(new Color(0, 0, 255, 192));
            HelpWindow.this.coordsLabel.setText("Text[X:" + src.getX() + ", Y:" + src.getY() + ", W:" + src.getWidth() + "]");
            HelpWindow.this.coordsLabel.pack();
            return false;
        }

        public boolean selected(CommandButton cb) {
            if (cb == HelpWindow.this.closeButton) {
                HelpWindow.this.close();
            } else if (cb == HelpWindow.this.nextButton) {
                HelpWindow.this.next();
            } else if (cb == HelpWindow.this.prevButton) {
                HelpWindow.this.prev();
            }
            return false;
        }

        public boolean dragBegin(Component src, int x, int y, int buttonFlags) {
            this.dragOriginX = x;
            this.dragOriginY = y;
            if (src == HelpWindow.this) {
                int n = HelpWindow.this.sprites.size();
                int i = 0;
                while (i < n) {
                    Sprite s = (Sprite)HelpWindow.this.sprites.get(i);
                    int xx = s.getX();
                    int yy = s.getY();
                    if (x >= xx - 8 && x <= xx + 8 && y >= yy - 8 && y <= yy + 8) {
                        this.dragSprite = s;
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            boolean bl = this.resizing = x >= src.getWidth() - 16 && y <= 16;
            if (this.resizing) {
                this.originalWidth = src.getWidth();
            }
            src.setBackgroundColor(new Color(0, 0, 255, 192));
            return false;
        }

        public boolean dragDrop(Component target, int x, int y, Component source, int buttonFlags) {
            return false;
        }

        public boolean dragEnd(Component src, int buttonFlags) {
            if (src != HelpWindow.this) {
                src.setBackgroundColor(new Color(0, 0, 255, 128));
            }
            return false;
        }

        public boolean dragEnter(Component target, int x, int y, Component source, int buttonFlags) {
            return false;
        }

        public boolean dragLeave(Component target, int x, int y, Component source, int buttonFlags) {
            return false;
        }

        public boolean dragWithin(Component target, int x, int y, Component source, int buttonFlags) {
            if (this.doingDrag) {
                return false;
            }
            this.doingDrag = true;
            if (source == HelpWindow.this) {
                this.dragSprite.setLocation(x, y, 0);
                HelpWindow.this.coordsLabel.setText("Sprite X:" + x + " Y:" + y);
            } else {
                if (this.resizing) {
                    source.setWidth(this.originalWidth + x - this.dragOriginX);
                } else {
                    source.setLocation(source.getX() + x - this.dragOriginX, source.getY() + y - this.dragOriginY);
                }
                HelpWindow.this.coordsLabel.setText("Text[X:" + source.getX() + ", Y:" + source.getY() + ", W:" + source.getWidth() + "]");
            }
            HelpWindow.this.coordsLabel.pack();
            this.doingDrag = false;
            return false;
        }
    }
}

