/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import com.shavenpuppy.jglib.opengl.GLFont;
import java.util.Arrays;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Rectangle;
import xap.gui.Component;
import xap.gui.Panel;

public class FormLayout {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int FIRST_LINE = 3;
    public static final int FILL = 4;
    private int margin;
    private final Panel panel;
    private final Dimension size = new Dimension();
    private int[] width = new int[0];
    private int[] height = new int[0];
    private int[] ascent = new int[0];
    private Constraint[] component = new Constraint[0];
    private int rows;
    private int columns;
    private int totalWidth;
    private int totalHeight;
    private boolean relayout;

    public FormLayout(Panel panel, int margin) {
        this.panel = panel;
        this.margin = margin;
    }

    public void addComponent(Component c, int x, int y, int halign, int valign) {
        this.panel.addChild(c);
        c.layout();
        c.pack();
        boolean resize = false;
        if (x >= this.columns) {
            resize = true;
            int[] newWidth = new int[x + 1];
            System.arraycopy(this.width, 0, newWidth, 0, this.width.length);
            this.width = newWidth;
        }
        if (y >= this.rows) {
            resize = true;
            int[] newHeight = new int[y + 1];
            int[] newAscent = new int[y + 1];
            System.arraycopy(this.height, 0, newHeight, 0, this.height.length);
            System.arraycopy(this.ascent, 0, newAscent, 0, this.ascent.length);
            this.height = newHeight;
            this.ascent = newAscent;
        }
        if (resize) {
            Constraint[] newComponent = new Constraint[this.width.length * this.height.length];
            int xx = 0;
            while (xx < this.columns) {
                int yy = 0;
                while (yy < this.rows) {
                    newComponent[xx + yy * this.width.length] = this.component[xx + yy * this.columns];
                    ++yy;
                }
                ++xx;
            }
            this.component = newComponent;
            this.rows = this.height.length;
            this.columns = this.width.length;
        }
        this.component[x + y * this.columns] = new Constraint(c, valign, halign);
        this.relayout = true;
    }

    public void layout() {
        if (!this.relayout) {
            return;
        }
        this.relayout = false;
        Arrays.fill(this.width, 0);
        Arrays.fill(this.height, 0);
        Arrays.fill(this.ascent, 0);
        int xx = 0;
        while (xx < this.columns) {
            int yy = 0;
            while (yy < this.rows) {
                int idx = xx + yy * this.columns;
                Constraint c = this.component[idx];
                if (c != null) {
                    this.width[xx] = Math.max(c.component.getWidth(), this.width[xx]);
                    this.height[yy] = Math.max(c.component.getHeight(), this.height[yy]);
                    GLFont font = c.component.getFont();
                    if (font != null) {
                        this.ascent[yy] = Math.max(font.getAscent(), this.ascent[yy]);
                    }
                }
                ++yy;
            }
            ++xx;
        }
        this.totalWidth = 0;
        this.totalHeight = 0;
        xx = 0;
        while (xx < this.columns) {
            this.totalWidth += this.width[xx];
            if (xx != this.columns - 1) {
                this.totalWidth += this.margin;
            }
            ++xx;
        }
        int yy = 0;
        while (yy < this.rows) {
            this.totalHeight += this.height[yy];
            if (yy != this.rows - 1) {
                this.totalHeight += this.margin;
            }
            ++yy;
        }
        int xpos = 0;
        Rectangle[] bounds = new Rectangle[this.component.length];
        int xx2 = 0;
        while (xx2 < this.columns) {
            int ypos = 0;
            int yy2 = 0;
            while (yy2 < this.rows) {
                int idx = xx2 + yy2 * this.columns;
                Constraint c = this.component[idx];
                if (c != null) {
                    c.x = xpos;
                    c.y = ypos;
                    c.width = this.width[xx2];
                    c.height = this.height[yy2];
                }
                ypos += this.height[yy2] + this.margin;
                ++yy2;
            }
            xpos += this.width[xx2] + this.margin;
            ++xx2;
        }
        xx2 = 0;
        while (xx2 < this.columns) {
            int yy3 = 0;
            while (yy3 < this.rows) {
                int idx = xx2 + yy3 * this.columns;
                Constraint c = this.component[idx];
                if (c != null) {
                    switch (c.halign) {
                        case 4: {
                            c.component.setWidth(c.width);
                        }
                        case 0: {
                            c.component.setX(c.x);
                            break;
                        }
                        case 2: {
                            c.component.setX(c.x + (c.width - c.component.getWidth()) / 2);
                            break;
                        }
                        case 1: {
                            c.component.setX(c.x + c.width - c.component.getWidth());
                        }
                    }
                    switch (c.valign) {
                        case 4: {
                            c.component.setHeight(c.height);
                            break;
                        }
                        case 1: {
                            c.component.setY(c.y);
                            break;
                        }
                        case 2: {
                            c.component.setY(c.y + (c.height - c.component.getHeight()) / 2);
                            break;
                        }
                        case 0: {
                            c.component.setY(c.y + c.height - c.component.getHeight());
                            break;
                        }
                        case 3: {
                            c.component.setY(c.y + c.height - this.ascent[yy3]);
                        }
                    }
                }
                ++yy3;
            }
            ++xx2;
        }
        this.panel.setSize(this.totalWidth, this.totalHeight);
    }

    public int getWidth() {
        this.layout();
        return this.totalWidth;
    }

    public int getHeight() {
        this.layout();
        return this.totalHeight;
    }

    private static class Constraint {
        Component component;
        int x;
        int y;
        int width;
        int height;
        int valign;
        int halign;

        Constraint(Component component, int valign, int halign) {
            this.component = component;
            this.valign = valign;
            this.halign = halign;
        }
    }
}

