/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import xap.Score;
import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.Component;
import xap.gui.KeyboardListener;
import xap.gui.Label;
import xap.gui.TextField;
import xap.gui.Window;

public class EnterNameWindow
extends Window {
    private final Score score;
    private static String lastName = "";
    private Label instructionLabel;
    private TextField nameTextField;
    private CommandButton okButton;
    private final EventHandler eventHandler = new EventHandler();

    public EnterNameWindow(Score score) throws Exception {
        super("Enter Your Name");
        this.score = score;
        this.createGUI();
        this.initEvents();
    }

    private void createGUI() throws Exception {
        this.instructionLabel = new Label("Enter your name:");
        this.nameTextField = new TextField(32);
        this.nameTextField.setText(lastName);
        this.okButton = new CommandButton("OK");
        this.addChild(this.instructionLabel);
        this.addChild(this.nameTextField);
        this.addChild(this.okButton);
        this.setSize(350, 150);
        this.setBorder(5, 5, 5, 5);
        this.centre();
        this.okButton.pack().setWidth(100).setX(125);
        this.nameTextField.pack().setWidth(300).setLocation(25, this.okButton.getHeight() + 20);
        this.instructionLabel.pack().setWidth(350).setLocation(0, this.nameTextField.getY() + this.nameTextField.getHeight() + 10);
        this.instructionLabel.setAlignment(1);
    }

    private void initEvents() {
        this.okButton.addCommandButtonListener(this.eventHandler);
        this.nameTextField.addKeyboardListener(this.eventHandler);
    }

    private class EventHandler
    implements CommandButtonListener,
    KeyboardListener {
        EventHandler() {
        }

        public boolean selected(CommandButton cb) {
            this.done();
            return false;
        }

        public boolean keyDown(Component src, int key) {
            return false;
        }

        public boolean keyTyped(Component src, int key) {
            if (key == 28) {
                this.done();
            }
            return false;
        }

        public boolean keyUp(Component src, int key) {
            return false;
        }

        void done() {
            lastName = EnterNameWindow.this.nameTextField.getText().trim();
            EnterNameWindow.this.score.setName(lastName);
            EnterNameWindow.this.close();
        }
    }
}

