/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import com.shavenpuppy.jglib.util.FPMath;
import java.util.HashMap;
import org.lwjgl.util.Color;
import xap.Bindings;
import xap.Game;
import xap.gui.CheckBox;
import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.Interface;
import xap.gui.Label;
import xap.gui.OKCancelListener;
import xap.gui.OKCancelPanel;
import xap.gui.Panel;
import xap.gui.ScrollPane;
import xap.gui.Slider;
import xap.gui.SwirlyBackground;
import xap.gui.Window;

public class ControlsSetupDialog
extends Window
implements Bindings.Editor {
    private OKCancelPanel okCancelPanel;
    private HashMap bindingsControls = new HashMap();
    private ScrollPane scrollPane;
    private Panel bindingsPanel;
    private Label accelerationLabel;
    private Label decelerationLabel;
    private Slider accelerationSlider;
    private Slider decelerationSlider;
    private CheckBox autoShieldCheckBox;
    private CheckBox autoSmartBombCheckBox;
    private CheckBox fixedEyeCheckBox;
    private final EventHandler eventHandler = new EventHandler();

    public ControlsSetupDialog() throws Exception {
        super("Setup Controls");
        this.createGUI();
        this.initEvents();
        this.open();
    }

    private void createGUI() throws Exception {
        this.accelerationLabel = new Label("Acceleration");
        this.decelerationLabel = new Label("Deceleration");
        this.autoShieldCheckBox = new CheckBox("Enable Automatic Shield Trigger");
        this.autoSmartBombCheckBox = new CheckBox("Enable Automatic Smartbomb Trigger");
        this.fixedEyeCheckBox = new CheckBox("Use fixed eye viewpoint (try it and see)");
        this.accelerationSlider = new Slider(0, false);
        this.decelerationSlider = new Slider(0, false);
        this.accelerationSlider.setMinValue(FPMath.fpValue((float)0.1f));
        this.accelerationSlider.setMaxValue(FPMath.ONE);
        this.decelerationSlider.setMinValue(FPMath.fpValue((float)0.1f));
        this.decelerationSlider.setMaxValue(FPMath.ONE);
        this.decelerationSlider.setLocation(0, 50).layout().setSize(337, 16);
        this.decelerationLabel.setLocation(0, this.decelerationSlider.getY() + this.decelerationSlider.getHeight() + 2).layout().pack().setWidth(337);
        this.accelerationSlider.setLocation(0, this.decelerationLabel.getY() + this.decelerationLabel.getHeight() + 2).layout().setSize(337, 16);
        this.accelerationLabel.setLocation(0, this.accelerationSlider.getY() + this.accelerationSlider.getHeight() + 2).layout().pack().setWidth(337);
        this.autoSmartBombCheckBox.setLocation(0, this.accelerationLabel.getY() + this.accelerationLabel.getHeight() + 2).layout().pack().setWidth(337);
        this.autoShieldCheckBox.setLocation(0, this.autoSmartBombCheckBox.getY() + this.autoSmartBombCheckBox.getHeight() + 2).layout().pack().setWidth(337);
        this.fixedEyeCheckBox.setLocation(0, this.autoShieldCheckBox.getY() + this.autoShieldCheckBox.getHeight() + 2).layout().pack().setWidth(337);
        this.addChild(this.accelerationLabel);
        this.addChild(this.accelerationSlider);
        this.addChild(this.decelerationLabel);
        this.addChild(this.decelerationSlider);
        this.addChild(this.autoShieldCheckBox);
        this.addChild(this.autoSmartBombCheckBox);
        this.addChild(this.fixedEyeCheckBox);
        this.okCancelPanel = new OKCancelPanel();
        this.bindingsPanel = new Panel();
        this.bindingsPanel.setBackgroundColor(new Color(0, 128, 255, 64));
        this.scrollPane = new ScrollPane(2, 0);
        this.scrollPane.setSize(380, 264);
        this.scrollPane.setView(this.bindingsPanel);
        this.scrollPane.setLocation(0, 215);
        this.addChild(this.scrollPane);
        this.addChild(this.okCancelPanel);
        Bindings.toEditor(this);
        this.bindingsPanel.pack();
        this.scrollPane.setWidth(this.bindingsPanel.getWidth());
        this.scrollPane.setViewLocation(0, this.bindingsPanel.getHeight() - this.scrollPane.getHeight());
        this.pack();
        this.setBorder(5, 5, 5, 5);
        this.centre();
    }

    private void initEvents() {
        this.okCancelPanel.addOkCancelListener(this.eventHandler);
    }

    public void setBinding(Bindings.Binding binding) throws Exception {
        BindingEditor editor = (BindingEditor)this.bindingsControls.get(binding.getName());
        if (editor == null) {
            editor = new BindingEditor();
            this.bindingsPanel.addChild(editor);
            editor.setY(this.bindingsControls.size() * editor.getHeight() + 5);
            this.bindingsControls.put(binding.getName(), editor);
        }
        editor.setBinding(binding);
    }

    public int getAcceleration() {
        return this.accelerationSlider.getCurrentValue();
    }

    public int getDeceleration() {
        return this.decelerationSlider.getCurrentValue();
    }

    public void setAcceleration(int inertia) {
        this.accelerationSlider.setCurrentValue(inertia);
    }

    public void setDeceleration(int momentum) {
        this.decelerationSlider.setCurrentValue(momentum);
    }

    public boolean getAutoShield() {
        return this.autoShieldCheckBox.isChecked();
    }

    public boolean getAutoSmartBomb() {
        return this.autoSmartBombCheckBox.isChecked();
    }

    public void setAutoShield(boolean autoShield) {
        this.autoShieldCheckBox.setChecked(autoShield);
    }

    public void setAutoSmartBomb(boolean autoSmartBomb) {
        this.autoSmartBombCheckBox.setChecked(autoSmartBomb);
    }

    public boolean getFixedEye() {
        return this.fixedEyeCheckBox.isChecked();
    }

    public void setFixedEye(boolean fixedEye) {
        this.fixedEyeCheckBox.setChecked(fixedEye);
    }

    class BindingEditor
    extends Panel
    implements CommandButtonListener {
        Bindings.Binding binding;
        Label nameLabel;
        CommandButton bindingButton;
        boolean captureMode;
        boolean waitMode;
        SwirlyBackground swirlyBackground = new SwirlyBackground(this, 64.0f, 64.0f, null);

        BindingEditor() throws Exception {
            this.setBackgroundColor(Interface.getControlBackgroundColor());
            this.nameLabel = new Label();
            this.nameLabel.setAlignment(2);
            this.bindingButton = new CommandButton();
            this.bindingButton.setUseEffect(false);
            this.nameLabel.setWidth(120).setY(7);
            this.bindingButton.setLocation(125, 5);
            this.bindingButton.setForegroundColor(Interface.getDefaultForeground());
            this.bindingButton.setWidth(200);
            this.addChild(this.nameLabel);
            this.addChild(this.bindingButton);
            this.pack().setWidth(this.getWidth() + 17);
            this.bindingButton.addCommandButtonListener(this);
        }

        void setBinding(Bindings.Binding binding) {
            this.binding = binding;
            this.nameLabel.setText(binding.getName()).pack().setWidth(120);
            this.bindingButton.setText(binding.toString());
        }

        protected boolean doTick() {
            boolean ret = super.doTick();
            if (this.captureMode) {
                ret = true;
                this.swirlyBackground.doTick();
                if (this.binding.determine()) {
                    this.bindingButton.setText(this.binding.toString());
                    try {
                        Bindings.toEditor(ControlsSetupDialog.this);
                    }
                    catch (Exception e) {
                        Game.handleException(e);
                    }
                    this.captureMode = false;
                    this.waitMode = true;
                }
            } else if (this.waitMode) {
                ret = true;
                if (!this.binding.isDown()) {
                    Bindings.setEnabled(false);
                    Interface.setIgnoreInput(false);
                    this.waitMode = false;
                }
            }
            return ret;
        }

        protected void renderBackground() {
            if (this.captureMode) {
                this.swirlyBackground.render();
            }
        }

        public boolean selected(CommandButton cb) {
            this.captureMode = true;
            Interface.setIgnoreInput(true);
            Bindings.setEnabled(false);
            return false;
        }
    }

    private class EventHandler
    implements OKCancelListener {
        EventHandler() {
        }

        public void cancelClicked() {
            Game.loadBindings();
            ControlsSetupDialog.this.close();
        }

        public void okClicked() {
            try {
                Bindings.fromEditor(ControlsSetupDialog.this);
                Game.saveBindings();
            }
            catch (Exception e) {
                Game.handleException(e);
            }
            ControlsSetupDialog.this.close();
        }
    }
}

