/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.opengl.GLFont;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritableRectangle;
import xap.gui.Component;
import xap.gui.Dialog;
import xap.gui.DragListener;
import xap.gui.Interface;
import xap.gui.Label;
import xap.gui.Window;

public class Window
extends Dialog {
    private final Label titleText = new Label();
    private String title;
    private int dragOriginX;
    private int dragOriginY;

    public Window(String title) {
        this.titleText.setDraggable(true).setDragCaptured(true);
        this.titleText.setBackgroundColor(Interface.getWindowActiveTitleBarColor());
        this.titleText.setForegroundColor(Interface.getControlEnabledTextColor());
        this.titleText.setAlignment(1);
        this.titleText.setFont(Interface.getWindowTitleFont());
        this.addChild(this.titleText);
        class EventHandler
        implements DragListener {
            final Point parentLocation;
            final /* synthetic */ Window this$0;

            EventHandler(Window window) {
                this.this$0 = window;
                this.parentLocation = new Point();
            }

            public boolean dragBegin(Component src, int x, int y, int buttonFlags) {
                Window.access$0(this.this$0, x);
                Window.access$1(this.this$0, y);
                return false;
            }

            public boolean dragDrop(Component src, int x, int y, Component source, int buttonFlags) {
                return false;
            }

            public boolean dragEnd(Component src, int buttonFlags) {
                return false;
            }

            public boolean dragEnter(Component src, int x, int y, Component source, int buttonFlags) {
                return false;
            }

            public boolean dragLeave(Component src, int x, int y, Component source, int buttonFlags) {
                return false;
            }

            public boolean dragWithin(Component src, int x, int y, Component source, int buttonFlags) {
                this.parentLocation.setLocation((ReadablePoint)this.this$0.location);
                this.parentLocation.translate(x - Window.access$2(this.this$0), y - Window.access$3(this.this$0));
                this.this$0.setLocation(this.parentLocation.getX(), this.parentLocation.getY());
                return false;
            }
        }
        EventHandler eventHandler = new EventHandler(this);
        this.titleText.addDragListener(eventHandler);
        this.setTitle(title);
    }

    protected boolean doTick() {
        boolean ret = super.doTick();
        if (this.isChanged()) {
            this.titleText.setLocation(0, this.size.getHeight() - this.titleText.getFont().getHeight());
            this.titleText.setSize(this.size.getWidth(), this.titleText.getFont().getHeight());
        }
        this.titleText.setBackgroundColor(this.isActive() ? Interface.getWindowActiveTitleBarColor() : Interface.getWindowInactiveTitleBarColor());
        return ret;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleText.setText(title);
    }

    public String toString() {
        return "Window " + this.getTitle();
    }

    public void setTitleFont(GLFont font) {
        this.setHeight(this.getHeight() - this.titleText.getHeight());
        this.titleText.setFont(font);
        this.setHeight(this.getHeight() + font.getHeight());
    }

    public Component pack() {
        int n = this.children.size();
        if (n == 0) {
            return this;
        }
        Rectangle r = new Rectangle();
        Rectangle r2 = new Rectangle();
        int i = 1;
        while (i < n) {
            Component c = (Component)this.children.get(i);
            r.union((ReadableRectangle)c.getBounds(r2), (WritableRectangle)r);
            ++i;
        }
        this.titleText.layout();
        r.setHeight(r.getHeight() + this.titleText.getFont().getHeight() + 5);
        this.setBounds(r);
        return this;
    }

    static /* synthetic */ void access$0(Window window, int n) {
        window.dragOriginX = n;
    }

    static /* synthetic */ void access$1(Window window, int n) {
        window.dragOriginY = n;
    }

    static /* synthetic */ int access$2(Window window) {
        return window.dragOriginX;
    }

    static /* synthetic */ int access$3(Window window) {
        return window.dragOriginY;
    }
}

