/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLTexture;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import xap.gui.Component;
import xap.gui.DragListener;
import xap.gui.KeyboardListener;
import xap.gui.MouseAdapter;
import xap.gui.Slider;
import xap.gui.SliderListener;

public class Slider
extends Component {
    private int minValue;
    private int maxValue;
    private int currentValue;
    private int currentRange;
    private int nextPage;
    private int prevPage;
    private final boolean proportional;
    private final int orientation;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private final ArrayList sliderListeners = new ArrayList();
    private GLTexture scrollbarTexture = (GLTexture)Resources.get((String)"scrollbars.texture");
    private Knob knob;

    public Slider(int orientation, boolean proportional) throws Exception {
        this.orientation = orientation;
        this.proportional = proportional;
        this.knob = new Knob();
        this.addChild(this.knob);
        this.knob.setSize(16, 16);
        class EventHandler
        extends MouseAdapter
        implements KeyboardListener {
            final /* synthetic */ Slider this$0;

            EventHandler(Slider slider) {
                this.this$0 = slider;
            }

            public boolean keyUp(Component src, int key) {
                return false;
            }

            public boolean keyDown(Component src, int key) {
                return false;
            }

            public boolean keyTyped(Component src, int key) {
                int newCurrentValue;
                int oldCurrentValue;
                block24: {
                    block23: {
                        oldCurrentValue = Slider.access$3(this.this$0);
                        newCurrentValue = Slider.access$3(this.this$0);
                        if (Slider.access$0(this.this$0) != 0) break block23;
                        switch (key) {
                            case 199: {
                                newCurrentValue = Slider.access$2(this.this$0);
                                break;
                            }
                            case 207: {
                                newCurrentValue = Slider.access$1(this.this$0);
                                break;
                            }
                            case 203: {
                                if (Keyboard.isKeyDown((int)42)) {
                                    newCurrentValue = Slider.access$2(this.this$0);
                                    break;
                                }
                                if (Slider.access$3(this.this$0) != Slider.access$2(this.this$0)) {
                                    newCurrentValue += Slider.access$3(this.this$0) - Slider.access$2(this.this$0) > 0 ? -1 : 1;
                                    break;
                                }
                                break block24;
                            }
                            case 205: {
                                if (Keyboard.isKeyDown((int)42)) {
                                    newCurrentValue = Slider.access$1(this.this$0);
                                    break;
                                }
                                if (Slider.access$3(this.this$0) != Slider.access$1(this.this$0)) {
                                    newCurrentValue += Slider.access$3(this.this$0) - Slider.access$1(this.this$0) > 0 ? -1 : 1;
                                    break;
                                }
                                break block24;
                            }
                            case 201: {
                                this.this$0.pageUp();
                                break;
                            }
                            case 209: {
                                this.this$0.pageDown();
                            }
                        }
                        break block24;
                    }
                    switch (key) {
                        case 199: {
                            newCurrentValue = Slider.access$2(this.this$0);
                            break;
                        }
                        case 207: {
                            newCurrentValue = Slider.access$1(this.this$0);
                            break;
                        }
                        case 200: {
                            if (Keyboard.isKeyDown((int)42)) {
                                newCurrentValue = Slider.access$2(this.this$0);
                                break;
                            }
                            if (Slider.access$3(this.this$0) == Slider.access$2(this.this$0)) break;
                            newCurrentValue += Slider.access$3(this.this$0) - Slider.access$2(this.this$0) > 0 ? -1 : 1;
                            break;
                        }
                        case 208: {
                            if (Keyboard.isKeyDown((int)42)) {
                                newCurrentValue = Slider.access$1(this.this$0);
                                break;
                            }
                            if (Slider.access$3(this.this$0) == Slider.access$1(this.this$0)) break;
                            newCurrentValue += Slider.access$3(this.this$0) - Slider.access$1(this.this$0) > 0 ? -1 : 1;
                            break;
                        }
                        case 201: {
                            this.this$0.pageUp();
                            break;
                        }
                        case 209: {
                            this.this$0.pageDown();
                        }
                    }
                }
                if (newCurrentValue != oldCurrentValue) {
                    this.this$0.setCurrentValue(newCurrentValue);
                }
                return false;
            }

            public boolean leftButtonDown(Component src, int x, int y) {
                if (Slider.access$0(this.this$0) == 0) {
                    if (x < Slider.access$5(this.this$0).getX()) {
                        this.this$0.pageUp();
                    } else {
                        this.this$0.pageDown();
                    }
                } else if (y < Slider.access$5(this.this$0).getY()) {
                    this.this$0.pageDown();
                } else {
                    this.this$0.pageUp();
                }
                return false;
            }
        }
        EventHandler eventHandler = new EventHandler(this);
        this.addKeyboardListener(eventHandler);
        this.addMouseListener(eventHandler);
    }

    public void addSliderListener(SliderListener listener) {
        this.sliderListeners.add(listener);
    }

    public int getCurrentRange() {
        return this.currentRange;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void removeSliderListener(SliderListener listener) {
        this.sliderListeners.remove(listener);
    }

    protected void renderBackground() {
        super.renderBackground();
        Color c = this.getForegroundColor();
        if (c == null) {
            if (this.isEnabled()) {
                this.setGLColor((byte)-1, (byte)-1, (byte)-1, (byte)-1);
            } else {
                this.setGLColor((byte)-128, (byte)-128, (byte)-128, (byte)-128);
            }
        } else if (this.isEnabled()) {
            this.setGLColor(c);
        } else {
            this.setGLColor(c.getRed() >> 1, c.getGreen() >> 1, c.getBlue() >> 1, c.getAlpha() >> 1);
        }
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)1.0f);
        GL11.glBegin((int)1);
        if (this.orientation == 0) {
            GL11.glVertex2i((int)(this.border.getX() + 8), (int)(this.getHeight() / 2));
            GL11.glVertex2i((int)(this.border.getX() + this.size.getWidth() - 8), (int)(this.getHeight() / 2));
        } else {
            GL11.glVertex2i((int)(this.getWidth() / 2), (int)(this.border.getY() + 8));
            GL11.glVertex2i((int)(this.getWidth() / 2), (int)(this.border.getY() + this.size.getHeight() - 8));
        }
        GL11.glEnd();
    }

    public void setCurrentRange(int newCurrentRange) {
        this.currentRange = newCurrentRange;
        this.setChanged(true);
    }

    public void pageUp() {
        int cr;
        int cv = this.getCurrentValue();
        int n = cr = this.prevPage > 0 ? this.prevPage : 1;
        if (this.minValue > this.maxValue) {
            this.setCurrentValue(Math.min(Math.max(cv += cr, this.maxValue), this.minValue));
        } else {
            this.setCurrentValue(Math.min(Math.max(cv -= cr, this.minValue), this.maxValue));
        }
    }

    public void pageDown() {
        int cr;
        int cv = this.getCurrentValue();
        int n = cr = this.nextPage > 0 ? this.nextPage : 1;
        if (this.minValue > this.maxValue) {
            this.setCurrentValue(Math.max(Math.min(cv -= cr, this.minValue), this.maxValue));
        } else {
            this.setCurrentValue(Math.max(Math.min(cv += cr, this.maxValue), this.minValue));
        }
    }

    public void setCurrentValue(int newCurrentValue) {
        newCurrentValue = this.minValue < this.maxValue ? Math.max(Math.min(this.maxValue, newCurrentValue), this.minValue) : Math.min(Math.max(this.maxValue, newCurrentValue), this.minValue);
        if (this.currentValue != newCurrentValue) {
            int oldCurrentValue = this.currentValue;
            this.currentValue = newCurrentValue;
            this.setChanged(true);
            this.valueChanged(oldCurrentValue, newCurrentValue);
        }
    }

    public void setMaxValue(int newMaxValue) {
        if (this.maxValue != newMaxValue) {
            this.maxValue = newMaxValue;
            this.setCurrentValue(this.currentValue);
            this.setChanged(true);
        }
    }

    public void setMinValue(int newMinValue) {
        if (this.minValue != newMinValue) {
            this.minValue = newMinValue;
            this.setCurrentValue(this.currentValue);
            this.setChanged(true);
        }
    }

    private void valueChanged(int oldValue, int newValue) {
        Iterator i = this.sliderListeners.iterator();
        while (i.hasNext()) {
            ((SliderListener)i.next()).valueChanged(this, oldValue, newValue);
        }
    }

    public String toString() {
        return "Slider [min:" + this.minValue + " max: " + this.maxValue + " range: " + this.currentRange + " current: " + this.currentValue + "]";
    }

    protected boolean doTick() {
        boolean ret = super.doTick();
        if (this.isChanged()) {
            this.knob.updatePosition();
        }
        return ret;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public int getPrevPage() {
        return this.prevPage;
    }

    public void setPrevPage(int prevPage) {
        this.prevPage = prevPage;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Component setEnabled(boolean newEnabled) {
        this.knob.setEnabled(newEnabled);
        return super.setEnabled(newEnabled);
    }

    static /* synthetic */ Knob access$5(Slider slider) {
        return slider.knob;
    }

    private class Knob
    extends Component {
        Knob() {
            this.setDraggable(true);
            this.setDragCaptured(true);
            this.setCanFocus(false);
            class EventHandler
            implements DragListener {
                int dragOriginX;
                int dragOriginY;
                final /* synthetic */ Knob this$1;

                EventHandler(Knob knob) {
                    this.this$1 = knob;
                }

                public boolean dragBegin(Component src, int x, int y, int buttonFlags) {
                    this.dragOriginX = x;
                    this.dragOriginY = y;
                    return false;
                }

                public boolean dragDrop(Component src, int x, int y, Component source, int buttonFlags) {
                    return false;
                }

                public boolean dragEnd(Component src, int buttonFlags) {
                    return false;
                }

                public boolean dragEnter(Component src, int x, int y, Component source, int buttonFlags) {
                    return false;
                }

                public boolean dragLeave(Component src, int x, int y, Component source, int buttonFlags) {
                    return false;
                }

                public boolean dragWithin(Component src, int x, int y, Component source, int buttonFlags) {
                    int pos;
                    if (Slider.access$0(Knob.access$0(this.this$1)) == 0) {
                        pos = this.this$1.location.getX() + (x - this.dragOriginX);
                        pos = Math.min(Math.max(0, pos), this.this$1.parent.size.getWidth() - 16);
                    } else {
                        pos = this.this$1.location.getY() + (y - this.dragOriginY);
                        pos = Math.min(Math.max(0, pos), this.this$1.parent.size.getHeight() - 16);
                    }
                    Knob.access$0(this.this$1).setCurrentValue(this.this$1.calculateValue(pos));
                    this.this$1.setChanged(true);
                    return false;
                }
            }
            EventHandler eventHandler = new EventHandler(this);
            this.addDragListener(eventHandler);
        }

        void updatePosition() {
            if (Slider.this.maxValue - Slider.this.minValue == 0) {
                return;
            }
            if (Slider.this.orientation == 0) {
                this.setLocation((this.parent.size.getWidth() - 16) * (Slider.this.currentValue - Slider.this.minValue) / (Slider.this.maxValue - Slider.this.minValue), (this.parent.getHeight() - this.getHeight()) / 2);
            } else {
                this.setLocation((this.parent.getWidth() - this.getWidth()) / 2, (this.parent.size.getHeight() - 16) * (Slider.this.currentValue - Slider.this.minValue) / (Slider.this.maxValue - Slider.this.minValue));
            }
        }

        int calculateValue(int pos) {
            int value = Slider.this.orientation == 0 ? (int)((float)pos / (float)(this.parent.size.getWidth() - 16) * (float)(Slider.this.maxValue - Slider.this.minValue) + (float)Slider.this.minValue) : (int)((float)pos / (float)(this.parent.size.getHeight() - 16) * (float)(Slider.this.maxValue - Slider.this.minValue) + (float)Slider.this.minValue);
            return value;
        }

        protected void renderSelf() {
            GL11.glEnable((int)3553);
            Slider.this.scrollbarTexture.render();
            Color c = this.getForegroundColor();
            if (this.isEnabled()) {
                if (c != null) {
                    this.setGLColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
                    GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                }
            } else if (c != null) {
                this.setGLColor(c.getRed() >> 1, c.getGreen() >> 1, c.getBlue() >> 1, c.getAlpha() >> 1);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            } else {
                this.setGLColor(128, 128, 128, 128);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            }
            GL11.glBegin((int)7);
            float tx = this.isSelectDown() ? 0.5f : 0.0f;
            float ty = Slider.this.orientation == 0 ? 0.0f : 0.5f;
            GL11.glTexCoord2f((float)tx, (float)(ty + 0.5f));
            GL11.glVertex2i((int)0, (int)0);
            GL11.glTexCoord2f((float)(tx + 0.5f), (float)(ty + 0.5f));
            GL11.glVertex2i((int)this.size.getWidth(), (int)0);
            GL11.glTexCoord2f((float)(tx + 0.5f), (float)ty);
            GL11.glVertex2i((int)this.size.getWidth(), (int)this.size.getHeight());
            GL11.glTexCoord2f((float)tx, (float)ty);
            GL11.glVertex2i((int)0, (int)this.size.getHeight());
            GL11.glEnd();
            GL11.glDisable((int)3553);
        }

        public String toString() {
            return this.parent.toString();
        }

        static /* synthetic */ Slider access$0(Knob knob) {
            return knob.Slider.this;
        }
    }
}

