/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import java.util.ArrayList;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.Color;
import org.lwjgl.util.Rectangle;
import xap.gui.Component;
import xap.gui.Interface;
import xap.gui.KeyboardListener;
import xap.gui.Label;
import xap.gui.ListBoxListener;
import xap.gui.MouseAdapter;
import xap.gui.Panel;
import xap.gui.SelectionListener;

public class ListBox
extends Component {
    private static final Color dcrSelectedBackgroundColor = new Color(255, 0, 0, 128);
    private Color dcrFocusForeground = Interface.getControlSelectedTextColor();
    private Color dcrNoFocusForeground = Interface.getDefaultForeground();
    private Color dcrSelectedBackground = new Color(255, 0, 0, 128);
    private Color dcrNotSelectedBackground = null;
    private boolean containsInvalidRows;
    private int firstInvalidRow;
    private int lastInvalidRow;
    private ArrayList listListeners;
    private final ArrayList rows = new ArrayList();
    private CellRenderer cellRenderer;
    private int selectionModel;
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;
    public static final int MANDATORY_SINGLE_SELECTION = 2;
    private int currentRow;

    public ListBox() {
        this(new Object[0]);
    }

    public ListBox(Object[] data) {
        this.insertRows(0, data);
        this.layout();
        EventHandler handler = new EventHandler();
        this.addMouseListener(handler);
        this.addKeyboardListener(handler);
        this.addSelectionListener(handler);
    }

    public void addRow(Object data) {
        this.insertRow(this.rows.size(), data);
    }

    public void insertRow(int index, Object data) {
        this.insertRows(index, new Object[]{data});
        if (this.selectionModel == 2 && this.getSelectedRow() == -1) {
            this.selectRow(0, true);
        }
    }

    public void insertRows(int index, Object[] data) {
        int j = index;
        this.rows.ensureCapacity(data.length + index);
        int i = 0;
        while (i < data.length) {
            this.rows.add(index++, new Row(data[i]));
            ++i;
        }
        this.fireRowsInserted(j, index - 1);
        this.invalidateRowHeightCache(j, index - 1);
    }

    public void deleteRows(int startIndex, int endIndex) {
        int i = startIndex;
        while (i <= endIndex) {
            this.rows.remove(startIndex);
            ++i;
        }
        this.rows.trimToSize();
        if (this.selectionModel == 2 && this.rows.size() > 0 && this.getSelectedRow() == -1) {
            this.selectRow(0, true);
        }
        this.invalidateRowPositionCache(startIndex);
        this.fireRowsDeleted(startIndex, endIndex);
    }

    public void deleteRow(Object data) {
        int i = this.indexOf(data);
        if (i == -1) {
            return;
        }
        this.deleteRows(i, i);
    }

    public int indexOf(Object data) {
        int n = this.rows.size();
        int i = 0;
        while (i < n) {
            if (((Row)this.rows.get(i)).equals(data)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void clear() {
        if (this.rows.size() > 0) {
            this.deleteRows(0, this.rows.size() - 1);
        }
    }

    public void selectRow(int row, boolean select) {
        boolean oldSelected = ((Row)this.rows.get((int)row)).selected;
        if (oldSelected != select) {
            ((Row)this.rows.get((int)row)).selected = select;
            this.invalidateRowHeightCache(row, row);
            this.fireRowSelectedEvent(row, select);
        }
    }

    protected final void fireRowSelectedEvent(int row, boolean selected) {
        if (this.listListeners == null) {
            return;
        }
        int n = this.listListeners.size();
        int i = 0;
        while (i < n) {
            ((ListBoxListener)this.listListeners.get(i)).rowSelected(this, row, selected);
            ++i;
        }
    }

    protected final void fireRowsInserted(int start, int end) {
        if (this.listListeners == null) {
            return;
        }
        int n = this.listListeners.size();
        int i = 0;
        while (i < n) {
            ((ListBoxListener)this.listListeners.get(i)).rowsInserted(this, start, end);
            ++i;
        }
    }

    protected final void fireRowsDeleted(int start, int end) {
        if (this.listListeners == null) {
            return;
        }
        int n = this.listListeners.size();
        int i = 0;
        while (i < n) {
            ((ListBoxListener)this.listListeners.get(i)).rowsDeleted(this, start, end);
            ++i;
        }
    }

    protected final void fireRowsUpdated(int start, int end) {
        if (this.listListeners == null) {
            return;
        }
        int n = this.listListeners.size();
        int i = 0;
        while (i < n) {
            ((ListBoxListener)this.listListeners.get(i)).rowsUpdated(this, start, end);
            ++i;
        }
    }

    public Object setRow(int index, Object data) {
        Row r = (Row)this.rows.get(index);
        Object oldData = r.data;
        r.data = data;
        this.invalidateRowHeightCache(index, index);
        this.fireRowsUpdated(index, index);
        return oldData;
    }

    public int getSelectedRow() {
        int n = this.rows.size();
        int i = 0;
        while (i < n) {
            if (((Row)this.rows.get((int)i)).selected) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getSelectedRows() {
        int n = this.rows.size();
        int[] selectedRows = new int[n];
        int count = 0;
        int i = 0;
        while (i < n) {
            if (((Row)this.rows.get((int)i)).selected) {
                selectedRows[count++] = i;
            }
            ++i;
        }
        int[] ret = new int[count];
        System.arraycopy(selectedRows, 0, ret, 0, count);
        return ret;
    }

    public Object getRow(int index) {
        return ((Row)this.rows.get((int)index)).data;
    }

    public int rowCount() {
        return this.rows.size();
    }

    private void invalidateRowPositionCache(int index) {
        int i = index;
        while (i < this.rows.size()) {
            ((Row)this.rows.get((int)i)).ypos = -1;
            ++i;
        }
        if (!this.containsInvalidRows) {
            this.containsInvalidRows = true;
            this.firstInvalidRow = index;
        } else {
            this.firstInvalidRow = Math.min(this.firstInvalidRow, index);
        }
        this.lastInvalidRow = this.rows.size() - 1;
        this.invalidate();
    }

    private void invalidateRowHeightCache(int start, int end) {
        end = Math.min(this.rows.size() - 1, end);
        int i = start;
        while (i <= end) {
            Row r = (Row)this.rows.get(i);
            r.height = -1;
            r.renderer = null;
            ++i;
        }
        this.invalidateRowPositionCache(start);
    }

    protected void renderSelf() {
        int i = 0;
        while (i < this.rows.size()) {
            Row r = (Row)this.rows.get(i);
            r.renderer.setLocation(0, r.ypos + this.getHeight());
            r.renderer.render();
            ++i;
        }
    }

    public void doLayout() {
        super.doLayout();
        if (this.containsInvalidRows) {
            this.containsInvalidRows = false;
            int ypos = 0;
            int w = this.getWidth();
            if (this.firstInvalidRow > 0) {
                Row r = (Row)this.rows.get(this.firstInvalidRow - 1);
                ypos = r.ypos;
            }
            int i = this.firstInvalidRow;
            while (i <= this.lastInvalidRow) {
                Row r = (Row)this.rows.get(i);
                if (r.height == -1) {
                    r.renderer = this.getCellRenderer().getComponent(this, r.data, r.selected, i == this.currentRow, r.renderer);
                    r.height = r.renderer.getHeight();
                    w = Math.max(w, r.renderer.getWidth());
                }
                ypos -= r.height;
                if (r.ypos == -1) {
                    r.ypos = ypos;
                }
                ++i;
            }
            this.setSize(w, -ypos);
        }
    }

    public CellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.setCellRenderer(new DefaultCellRenderer());
        }
        return this.cellRenderer;
    }

    public void setCellRenderer(CellRenderer cellRenderer) {
        if (cellRenderer != this.cellRenderer) {
            this.cellRenderer = cellRenderer;
            this.invalidateRowHeightCache(0, this.rows.size() - 1);
        }
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(int currentRow) {
        if (currentRow != this.currentRow) {
            if (this.selectionModel == 2) {
                this.selectRow(this.getSelectedRow(), false);
            }
            this.invalidateRowHeightCache(this.currentRow, this.currentRow);
            this.currentRow = currentRow;
            this.invalidateRowHeightCache(this.currentRow, this.currentRow);
            if (this.selectionModel == 2) {
                this.selectRow(currentRow, true);
            }
            this.layout();
            Row r = (Row)this.rows.get(currentRow);
            this.ensureVisible(new Rectangle(0, r.ypos + this.getHeight(), r.renderer.getWidth(), r.height));
        }
    }

    protected boolean doTick() {
        boolean ret = super.doTick();
        this.layout();
        return ret;
    }

    public String toString() {
        return "BGList[" + this.rows.size() + " rows";
    }

    public void addListListener(ListBoxListener listener) {
        if (this.listListeners == null) {
            this.listListeners = new ArrayList(1);
        }
        this.listListeners.add(listener);
    }

    public void removeListListener(ListBoxListener listener) {
        if (this.listListeners != null) {
            this.listListeners.remove(listener);
        }
    }

    public int getHorizontalScrollNextPage(int vwidth, int xpos) {
        return super.getHorizontalScrollNextPage(vwidth, xpos);
    }

    public int getHorizontalScrollPrevPage(int vwidth, int xpos) {
        return super.getHorizontalScrollPrevPage(vwidth, xpos);
    }

    public int getVerticalScrollNextPage(int vheight, int ypos) {
        return super.getVerticalScrollNextPage(vheight, ypos);
    }

    public int getVerticalScrollPrevPage(int vheight, int ypos) {
        return super.getVerticalScrollPrevPage(vheight, ypos);
    }

    private static class Row {
        Object data;
        boolean selected;
        int height;
        int ypos;
        Component renderer;

        Row(Object data) {
            this.data = data;
            this.height = -1;
            this.ypos = -1;
        }
    }

    private class DefaultCellRenderer
    extends Panel
    implements CellRenderer {
        private Label label = new Label();

        DefaultCellRenderer() {
            this.addChild(this.label);
        }

        public Component getComponent(ListBox list, Object value, boolean selected, boolean hasFocus, Component currentRenderer) {
            if (currentRenderer == null || !(currentRenderer instanceof DefaultCellRenderer)) {
                ListBox.this.removeDependent(currentRenderer);
                currentRenderer = new DefaultCellRenderer();
                ListBox.this.addDependent(currentRenderer);
            }
            DefaultCellRenderer dcr = (DefaultCellRenderer)currentRenderer;
            dcr.label.setText(value.toString());
            dcr.label.pack();
            if (hasFocus) {
                dcr.label.setForegroundColor(ListBox.this.dcrFocusForeground);
            } else {
                dcr.label.setForegroundColor(ListBox.this.dcrNoFocusForeground);
            }
            if (selected) {
                dcr.setBackgroundColor(dcrSelectedBackgroundColor);
            } else {
                dcr.setBackgroundColor(ListBox.this.dcrNotSelectedBackground);
            }
            dcr.layout();
            dcr.pack();
            return dcr;
        }
    }

    private class EventHandler
    extends MouseAdapter
    implements SelectionListener,
    KeyboardListener {
        EventHandler() {
        }

        public boolean leftButtonClicked(Component src, int x, int y, int clickCount) {
            ListBox.this.layout();
            y -= ListBox.this.getHeight();
            int i = 0;
            while (i < ListBox.this.rows.size()) {
                Row r = (Row)ListBox.this.rows.get(i);
                if (y >= r.ypos && y < r.ypos + r.height) {
                    switch (ListBox.this.selectionModel) {
                        case 0: {
                            ListBox.this.setCurrentRow(i);
                            break;
                        }
                        case 1: {
                            ListBox.this.setCurrentRow(i);
                            break;
                        }
                    }
                    return false;
                }
                ++i;
            }
            return false;
        }

        public boolean leftButtonDown(Component src, int x, int y) {
            ListBox.this.layout();
            y -= ListBox.this.getHeight();
            int i = 0;
            while (i < ListBox.this.rows.size()) {
                Row r = (Row)ListBox.this.rows.get(i);
                if (y >= r.ypos && y < r.ypos + r.height) {
                    ListBox.this.setCurrentRow(i);
                    switch (ListBox.this.selectionModel) {
                        case 0: {
                            int currentSelection = ListBox.this.getSelectedRow();
                            if (currentSelection == i && r.selected) break;
                            if (currentSelection != -1) {
                                ListBox.this.selectRow(currentSelection, false);
                            }
                            ListBox.this.selectRow(i, true);
                            break;
                        }
                        case 1: {
                            if (Keyboard.isKeyDown((int)29)) {
                                ListBox.this.selectRow(i, !r.selected);
                                break;
                            }
                            int currentSelection = ListBox.this.getSelectedRow();
                            if (currentSelection == i && r.selected) break;
                            if (currentSelection != -1) {
                                ListBox.this.selectRow(currentSelection, false);
                            }
                            ListBox.this.selectRow(i, true);
                            break;
                        }
                        case 2: {
                            ListBox.this.setCurrentRow(i);
                        }
                    }
                    return false;
                }
                ++i;
            }
            return false;
        }

        public boolean keyDown(Component src, int key) {
            int row = ListBox.this.getCurrentRow();
            switch (key) {
                case 200: {
                    if (row <= 0) break;
                    ListBox.this.setCurrentRow(--row);
                    break;
                }
                case 208: {
                    if (row >= ListBox.this.rowCount() - 1) break;
                    ListBox.this.setCurrentRow(++row);
                }
            }
            return false;
        }

        public boolean keyTyped(Component src, int key) {
            return false;
        }

        public boolean keyUp(Component src, int key) {
            return false;
        }

        public boolean selectDown(Component src) {
            Row r = (Row)ListBox.this.rows.get(ListBox.this.getCurrentRow());
            switch (ListBox.this.selectionModel) {
                case 0: {
                    int currentSelection = ListBox.this.getSelectedRow();
                    if (currentSelection == ListBox.this.getCurrentRow()) break;
                    if (currentSelection != -1) {
                        ListBox.this.selectRow(currentSelection, false);
                    }
                    ListBox.this.selectRow(ListBox.this.getCurrentRow(), true);
                    break;
                }
                case 1: {
                    if (Keyboard.isKeyDown((int)29)) {
                        ListBox.this.selectRow(ListBox.this.getCurrentRow(), !r.selected);
                        break;
                    }
                    int currentSelection = ListBox.this.getSelectedRow();
                    if (currentSelection == ListBox.this.getCurrentRow()) break;
                    if (currentSelection != -1) {
                        ListBox.this.selectRow(currentSelection, false);
                    }
                    ListBox.this.selectRow(ListBox.this.getCurrentRow(), true);
                    break;
                }
            }
            return false;
        }

        public boolean selected(Component src) {
            return false;
        }

        public boolean selectUp(Component src) {
            return false;
        }
    }

    public static interface CellRenderer {
        public Component getComponent(ListBox var1, Object var2, boolean var3, boolean var4, Component var5);
    }
}

