/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.opengl.GLString;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Rectangle;
import xap.gui.Component;
import xap.gui.Interface;

public class Label
extends Component {
    private static final Rectangle tempRect = new Rectangle();
    private String text;
    private GLString string;
    private int alignment;
    public static final int LEFT = 0;
    public static final int CENTRE = 1;
    public static final int RIGHT = 2;
    private int shadowXoffset;
    private int shadowYoffset;
    private Color shadowColor;

    public Label() {
        this("");
    }

    public Label(String text) {
        this.setCanFocus(false);
        this.string = new GLString(text.length());
        this.setText(text);
    }

    public void doLayout() {
        this.string.setFont(this.getFont());
        this.string.layout();
        switch (this.alignment) {
            case 0: {
                this.string.setLocation(0, this.getFont().getDescent());
                break;
            }
            case 1: {
                this.string.getBounds(tempRect);
                int textWidth = tempRect.getWidth();
                this.string.setLocation(this.getWidth() / 2 - textWidth / 2, this.getFont().getDescent());
                break;
            }
            case 2: {
                this.string.getBounds(tempRect);
                int textWidth = tempRect.getWidth();
                this.string.setLocation(this.getWidth() - textWidth, this.getFont().getDescent());
                break;
            }
            default: {
                throw new RuntimeException("Illegal static text alignment: " + this.getText());
            }
        }
    }

    protected boolean doTick() {
        if (this.isChanged()) {
            this.doLayout();
        }
        return this.isChanged();
    }

    public int getAlignment() {
        return this.alignment;
    }

    protected GLString getGLString() {
        return this.string;
    }

    public String getText() {
        return this.text;
    }

    protected void renderSelf() {
        Color c;
        GL11.glEnable((int)3553);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.shadowColor != null) {
            this.setGLColor(this.shadowColor);
            GL11.glPushMatrix();
            try {
                GL11.glTranslatef((float)this.shadowXoffset, (float)this.shadowYoffset, (float)0.0f);
                this.string.render();
            }
            finally {
                GL11.glPopMatrix();
            }
        }
        if ((c = this.getForegroundColor()) == null) {
            c = Interface.getDefaultForeground();
        }
        this.setGLColor(c);
        this.string.render();
        GL11.glDisable((int)3553);
    }

    public Label setAlignment(int newAlignment) {
        this.setChanged(this.alignment != newAlignment);
        this.alignment = newAlignment;
        return this;
    }

    public Label setText(String text) {
        if (text.equals(this.text)) {
            return this;
        }
        this.text = text;
        this.setChanged(true);
        if (this.string.capacity() < text.length()) {
            this.string = new GLString(text.length() << 1);
        }
        this.string.setText(text);
        this.string.setFont(this.getFont());
        this.string.layout();
        return this;
    }

    public String toString() {
        return "StaticText " + this.text;
    }

    public Component pack() {
        this.string.getBounds(tempRect);
        this.setSize(tempRect.getWidth(), this.getFont().getAscent() + this.getFont().getDescent());
        return this;
    }

    public void setShadow(int xoffset, int yoffset, Color color) {
        this.shadowXoffset = xoffset;
        this.shadowYoffset = yoffset;
        this.shadowColor = color;
    }
}

