/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritableRectangle;
import xap.Game;
import xap.gui.CapturedMouseListener;
import xap.gui.Dialog;
import xap.gui.DragListener;
import xap.gui.ExtraMouseListener;
import xap.gui.FocusListener;
import xap.gui.Interface;
import xap.gui.KeyboardListener;
import xap.gui.MouseListener;
import xap.gui.MousePointer;
import xap.gui.SelectionListener;

public abstract class Component
implements GLRenderable {
    static Rectangle screenBounds;
    private static final Rectangle tempBounds0;
    public Component parent;
    private Dialog dialog;
    protected final Point location = new Point();
    protected final Dimension size = new Dimension();
    protected final Point screenLocation = new Point();
    private final Rectangle clip = new Rectangle();
    private String name;
    private boolean clipped = true;
    private boolean enabled = true;
    private boolean visible = true;
    private boolean draggable = false;
    boolean canFocus = true;
    private boolean dragging;
    private boolean dragCaptured;
    protected ArrayList children;
    protected ArrayList dependents;
    private ArrayList keyboardListeners;
    private ArrayList mouseListeners;
    private ArrayList extraMouseListeners;
    private ArrayList capturedMouseListeners;
    private ArrayList dragListeners;
    private ArrayList selectionListeners;
    private ArrayList focusListeners;
    private boolean changed = true;
    private boolean valid;
    private float lastClickTime;
    private int clickCount;
    private Component delegate;
    Component keyboardDelegate;
    private MousePointer mousePointer;
    private int buttonDownFlags;
    boolean selectDown;
    private int dragCount;
    private int lastKeyDown = -1;
    private boolean mouseInside;
    private int mouseDownX;
    private int mouseDownY;
    boolean hasFocus;
    private Color foregroundColor;
    private Color backgroundColor;
    private GLFont font;
    protected final Rectangle border = new Rectangle();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.gui.Component");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        tempBounds0 = new Rectangle();
    }

    public final void addChild(Component component) {
        if (this.children == null) {
            this.children = new ArrayList(1);
        }
        if (!this.children.contains(component)) {
            if (component.parent != null) {
                component.parent.removeChild(component);
            }
            if (component.parent != null) {
                component.parent.removeDependent(component);
            }
            this.children.add(component);
            component.parent = this;
            component.dialog = this.findDialog();
            this.invalidate();
        }
    }

    public final void addDependent(Component component) {
        if (this.dependents == null) {
            this.dependents = new ArrayList(1);
        }
        if (!this.dependents.contains(component)) {
            if (component.parent != null) {
                component.parent.removeChild(component);
            }
            if (component.parent != null) {
                component.parent.removeDependent(component);
            }
            this.dependents.add(component);
            component.parent = this;
            component.dialog = this.findDialog();
            this.invalidate();
        }
    }

    protected final void removeChild(Component component) {
        if (this.children == null) {
            return;
        }
        if (this.children.contains(component)) {
            this.children.remove(component);
            component.parent = null;
            this.invalidate();
        }
    }

    protected final void removeDependent(Component component) {
        if (this.dependents == null) {
            return;
        }
        if (this.dependents.contains(component)) {
            this.dependents.remove(component);
            component.parent = null;
            this.invalidate();
        }
    }

    protected final void addScreenLocation(Point l) {
        l.translate(this.location.getX(), this.location.getY());
        if (this.parent != null) {
            this.parent.addScreenLocation(l);
        }
    }

    public Dialog getDialog() {
        if (this.parent != null) {
            return this.parent.getDialog();
        }
        return this.dialog;
    }

    private final void capturedMouseEntered(int x, int y) {
        if (Interface.DEBUG) {
            System.out.println(this + " capturedMouseEntered " + x + "," + y);
        }
        if (this.capturedMouseListeners != null) {
            Iterator i = this.capturedMouseListeners.iterator();
            while (i.hasNext()) {
                if (!((CapturedMouseListener)i.next()).capturedMouseEntered(this, x, y, this.buttonDownFlags)) continue;
                return;
            }
        }
        if (this.isCaptured() && !this.selectDown && (this.buttonDownFlags & 1) != 0) {
            this.selectDown();
        }
    }

    private final void capturedMouseExited(int x, int y) {
        if (Interface.DEBUG) {
            System.out.println(this + " capturedMouseExited " + x + "," + y);
        }
        if (this.capturedMouseListeners != null) {
            Iterator i = this.capturedMouseListeners.iterator();
            while (i.hasNext()) {
                if (!((CapturedMouseListener)i.next()).capturedMouseExited(this, x, y, this.buttonDownFlags)) continue;
                return;
            }
        }
        if (this.isCaptured() && this.selectDown && (this.buttonDownFlags & 1) != 0) {
            this.selectUp();
        }
    }

    private final void capturedMouseMoved(int x, int y) {
        if (Interface.DEBUG) {
            System.out.println(this + " capturedMouseMoved " + x + "," + y);
        }
        if (this.capturedMouseListeners != null) {
            Iterator i = this.capturedMouseListeners.iterator();
            while (i.hasNext()) {
                if (!((CapturedMouseListener)i.next()).capturedMouseMoved(this, x, y, this.buttonDownFlags)) continue;
                return;
            }
        }
        if (this.isCaptured() && this.draggable) {
            ++this.dragCount;
            if (this.dragCount >= 3) {
                this.dragBegin(x, y);
            }
        }
    }

    public Component centre() {
        if (this.parent == null) {
            return this;
        }
        this.setLocation((this.parent.getWidth() - this.getWidth()) / 2 - this.border.getX(), (this.parent.getHeight() - this.getHeight()) / 2 - this.border.getY());
        return this;
    }

    public final boolean contains(Point p) {
        this.getScreenLocation(this.screenLocation);
        return p.getX() >= this.screenLocation.getX() - this.border.getX() && p.getX() < this.screenLocation.getX() + this.getWidth() && p.getY() >= this.screenLocation.getY() - this.border.getY() && p.getY() < this.screenLocation.getY() + this.getHeight();
    }

    public void doLayout() {
    }

    protected boolean doTick() {
        return false;
    }

    private final void dragBegin(int x, int y) {
        if (Interface.DEBUG) {
            System.out.println(this + " dragBegin " + x + "," + y);
        }
        if (this.dragListeners != null) {
            Iterator i = this.dragListeners.iterator();
            while (i.hasNext()) {
                if (!((DragListener)i.next()).dragBegin(this, x, y, this.buttonDownFlags)) continue;
                return;
            }
        }
        this.dragging = true;
    }

    private final void dragDrop(int x, int y, Component source) {
        if (Interface.DEBUG) {
            System.out.println(this + " dragDrop " + x + "," + y + " from " + source);
        }
        if (this.dragListeners != null) {
            Iterator i = this.dragListeners.iterator();
            while (i.hasNext()) {
                if (!((DragListener)i.next()).dragDrop(this, x, y, source, this.buttonDownFlags)) continue;
                return;
            }
        }
    }

    private final void dragEnd() {
        if (Interface.DEBUG) {
            System.out.println(this + " dragEnd");
        }
        this.dragging = false;
        if (this.isDragCaptured() && this.selectDown) {
            this.selectUp();
        }
        if (this.dragListeners != null) {
            Iterator i = this.dragListeners.iterator();
            while (i.hasNext()) {
                if (!((DragListener)i.next()).dragEnd(this, this.buttonDownFlags)) continue;
                return;
            }
        }
    }

    private final void dragEnter(int x, int y, Component source) {
        if (Interface.DEBUG) {
            System.out.println(this + " dragEnter " + x + "," + y + " from " + source);
        }
        if (this.dragListeners != null) {
            Iterator i = this.dragListeners.iterator();
            while (i.hasNext()) {
                if (!((DragListener)i.next()).dragEnter(this, x, y, source, this.buttonDownFlags)) continue;
                return;
            }
        }
    }

    private final void dragLeave(int x, int y, Component source) {
        if (Interface.DEBUG) {
            System.out.println(this + " dragLeave " + x + "," + y + " from " + source);
        }
        if (this.dragListeners != null) {
            Iterator i = this.dragListeners.iterator();
            while (i.hasNext()) {
                if (!((DragListener)i.next()).dragLeave(this, x, y, source, this.buttonDownFlags)) continue;
                return;
            }
        }
    }

    private final void dragWithin(int x, int y, Component source) {
        if (Interface.DEBUG) {
            System.out.println(this + " dragWithin " + x + "," + y + " from " + source);
        }
        if (this.dragListeners != null) {
            Iterator i = this.dragListeners.iterator();
            while (i.hasNext()) {
                if (!((DragListener)i.next()).dragWithin(this, x, y, source, this.buttonDownFlags)) continue;
                return;
            }
        }
    }

    private Dialog findDialog() {
        if (this.parent != null) {
            if (this.parent instanceof Dialog) {
                return (Dialog)this.parent;
            }
            return this.parent.findDialog();
        }
        return null;
    }

    final void gainFocus() {
        if (Interface.DEBUG) {
            System.out.println(this + " gainFocus");
        }
        if (this.focusListeners != null) {
            Iterator i = this.focusListeners.iterator();
            while (i.hasNext()) {
                if (!((FocusListener)i.next()).gainFocus(this)) continue;
                return;
            }
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Rectangle getBorder(Rectangle ret) {
        if (ret == null) {
            ret = new Rectangle();
        }
        ret.setBounds((ReadableRectangle)this.border);
        return ret;
    }

    public final Rectangle getBounds(Rectangle ret) {
        if (ret == null) {
            ret = new Rectangle();
        }
        ret.setLocation(this.location.getX() - this.border.getX(), this.location.getY() - this.border.getY());
        ret.setSize(this.getWidth(), this.getHeight());
        return ret;
    }

    public final Component getComponentUnderMouse(Point mousePosition) {
        if (!this.visible || !this.contains(mousePosition)) {
            return null;
        }
        Component objectUnderMouse = null;
        if (this.children != null) {
            int n;
            int i = n = this.children.size();
            while (--i >= 0) {
                Component child = (Component)this.children.get(i);
                objectUnderMouse = child.getComponentUnderMouse(mousePosition);
                if (objectUnderMouse == null) continue;
                return objectUnderMouse;
            }
        }
        return this.getDelegate();
    }

    protected final Component getDelegate() {
        if (this.delegate == null) {
            return this;
        }
        return this.delegate.getDelegate();
    }

    public GLFont getFont() {
        if (this.font == null) {
            return Interface.getDefaultFont();
        }
        return this.font;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public final int getHeight() {
        return this.size.getHeight() + this.border.getY() + this.border.getHeight();
    }

    public final Point getLocalLocation(int x, int y, Point l) {
        if (l == null) {
            l = new Point(x, y);
        } else {
            l.setLocation(x, y);
        }
        this.removeScreenLocation(l);
        return l;
    }

    public final Point getLocation(Point l) {
        if (l == null) {
            l = new Point((ReadablePoint)this.location);
        } else {
            l.setLocation((ReadablePoint)this.location);
        }
        return l;
    }

    public final MousePointer getMousePointer() {
        if (this.mousePointer == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getMousePointer();
        }
        return this.mousePointer;
    }

    public final Component getParent() {
        return this.parent;
    }

    public final Point getScreenLocation(Point l) {
        if (l == null) {
            l = new Point((ReadablePoint)this.location);
        } else {
            l.setLocation((ReadablePoint)this.location);
        }
        if (this.parent != null) {
            this.parent.addScreenLocation(l);
        }
        return l;
    }

    public final Dimension getSize(Dimension s) {
        if (s == null) {
            s = new Dimension((ReadableDimension)this.size);
        } else {
            s.setSize((ReadableDimension)this.size);
        }
        return s;
    }

    public final int getWidth() {
        return this.size.getWidth() + this.border.getX() + this.border.getWidth();
    }

    public final int getX() {
        return this.location.getX();
    }

    public final int getY() {
        return this.location.getY();
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public final Component invalidate() {
        this.markParentInvalid();
        this.markChildrenInvalid();
        return this;
    }

    public final Component revalidate() {
        this.invalidate();
        this.layout();
        return this;
    }

    public boolean isCaptured() {
        return Interface.capture == this;
    }

    public final boolean isChanged() {
        return this.changed;
    }

    public final boolean isClipped() {
        return this.clipped;
    }

    public boolean isDragCaptured() {
        return this.dragCaptured;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    protected boolean isDragging() {
        return this.dragging;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMouseInside() {
        return this.mouseInside;
    }

    public boolean isSelectDown() {
        return this.selectDown;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Dialog d = this.getDialog();
        if (d == null) {
            return false;
        }
        return d.isVisible();
    }

    final void keyDown(int key) {
        if (!this.isEnabled()) {
            return;
        }
        if (Interface.DEBUG) {
            System.out.println(this + " keyDown " + key);
        }
        if (this.keyboardListeners != null) {
            Iterator i = this.keyboardListeners.iterator();
            while (i.hasNext()) {
                if (!((KeyboardListener)i.next()).keyDown(this, key)) continue;
                return;
            }
        }
        if (key == 57 && this.hasFocus()) {
            this.selectDown();
        }
        this.lastKeyDown = key;
        this.keyTyped(key);
    }

    private final void keyTyped(int key) {
        if (Interface.DEBUG) {
            System.out.println(this + " keyTyped " + key);
        }
        if (this.keyboardListeners != null) {
            Iterator i = this.keyboardListeners.iterator();
            while (i.hasNext()) {
                if (!((KeyboardListener)i.next()).keyTyped(this, key)) continue;
                return;
            }
        }
    }

    final void keyUp(int key) {
        if (Interface.DEBUG) {
            System.out.println(this + " keyUp " + key);
        }
        if (this.keyboardListeners != null) {
            Iterator i = this.keyboardListeners.iterator();
            while (i.hasNext()) {
                if (!((KeyboardListener)i.next()).keyUp(this, key)) continue;
                return;
            }
        }
        if (key == 57 && this.hasFocus() && this.lastKeyDown == 57 && this.selectDown) {
            this.selectUp();
            this.selected();
        }
        this.lastKeyDown = -1;
    }

    public final Component layout() {
        if (!this.visible) {
            return this;
        }
        do {
            if (this.children != null) {
                int n = this.children.size();
                int i = 0;
                while (i < n) {
                    ((Component)this.children.get(i)).layout();
                    ++i;
                }
            }
            if (this.valid) continue;
            this.valid = true;
            this.doLayout();
        } while (!this.valid);
        return this;
    }

    private final void leftButtonClicked(int x, int y) {
        float currentTime;
        if (Interface.DEBUG) {
            System.out.println(this + " leftButtonClicked " + x + "," + y);
        }
        this.clickCount = (currentTime = Interface.getTime()) - this.lastClickTime < Interface.getDoubleClickTime() ? ++this.clickCount : 1;
        this.lastClickTime = currentTime;
        if (this.mouseListeners != null) {
            Iterator i = this.mouseListeners.iterator();
            while (i.hasNext()) {
                if (!((MouseListener)i.next()).leftButtonClicked(this, x, y, this.clickCount)) continue;
                return;
            }
        }
    }

    private final void rightButtonClicked(int x, int y) {
        float currentTime;
        if (Interface.DEBUG) {
            System.out.println(this + " rightButtonClicked " + x + "," + y);
        }
        this.clickCount = (currentTime = Interface.getTime()) - this.lastClickTime < Interface.getDoubleClickTime() ? ++this.clickCount : 1;
        this.lastClickTime = currentTime;
        if (this.extraMouseListeners != null) {
            Iterator i = this.extraMouseListeners.iterator();
            while (i.hasNext()) {
                if (!((ExtraMouseListener)i.next()).rightButtonClicked(this, x, y, this.clickCount)) continue;
                return;
            }
        }
    }

    final void leftButtonDown(int x, int y) {
        if (!this.isEnabled()) {
            return;
        }
        if (Interface.DEBUG) {
            System.out.println(this + " leftButtonDown " + x + "," + y);
        }
        if (this.mouseListeners != null) {
            Iterator i = this.mouseListeners.iterator();
            while (i.hasNext()) {
                if (!((MouseListener)i.next()).leftButtonDown(this, x, y)) continue;
                return;
            }
        }
        this.buttonDownFlags |= 1;
        this.dragCount = 0;
        this.mouseDownX = x;
        this.mouseDownY = y;
        this.selectDown();
        Interface.setCapture(this);
    }

    final void scrollyWheel(int x, int y, int dz) {
        if (!this.isEnabled()) {
            return;
        }
        if (Interface.DEBUG) {
            System.out.println(this + " scrollyWheel " + x + "," + y + " : " + dz);
        }
        if (this.extraMouseListeners != null) {
            Iterator i = this.extraMouseListeners.iterator();
            while (i.hasNext()) {
                if (!((ExtraMouseListener)i.next()).mouseWheelScrolled(this, x, y, dz)) continue;
                return;
            }
        }
    }

    final void rightButtonDown(int x, int y) {
        if (!this.isEnabled()) {
            return;
        }
        if (Interface.DEBUG) {
            System.out.println(this + " rightButtonDown " + x + "," + y);
        }
        if (this.extraMouseListeners != null) {
            Iterator i = this.extraMouseListeners.iterator();
            while (i.hasNext()) {
                if (!((ExtraMouseListener)i.next()).rightButtonDown(this, x, y)) continue;
                return;
            }
        }
        this.buttonDownFlags |= 2;
        this.dragCount = 0;
        this.mouseDownX = x;
        this.mouseDownY = y;
        Interface.setCapture(this);
    }

    private final void leftButtonUp(int x, int y) {
        if (Interface.DEBUG) {
            System.out.println(this + " leftButtonUp " + x + "," + y);
        }
        if (this.mouseListeners != null) {
            Iterator i = this.mouseListeners.iterator();
            while (i.hasNext()) {
                if (!((MouseListener)i.next()).leftButtonUp(this, x, y)) continue;
                return;
            }
        }
        this.buttonDownFlags &= 0xFFFFFFFE;
    }

    private final void rightButtonUp(int x, int y) {
        if (Interface.DEBUG) {
            System.out.println(this + " rightButtonUp " + x + "," + y);
        }
        if (this.extraMouseListeners != null) {
            Iterator i = this.extraMouseListeners.iterator();
            while (i.hasNext()) {
                if (!((ExtraMouseListener)i.next()).rightButtonUp(this, x, y)) continue;
                return;
            }
        }
        this.buttonDownFlags &= 0xFFFFFFFD;
    }

    final void loseFocus() {
        if (Interface.DEBUG) {
            System.out.println(this + " loseFocus");
        }
        if (this.focusListeners != null) {
            Iterator i = this.focusListeners.iterator();
            while (i.hasNext()) {
                if (!((FocusListener)i.next()).loseFocus(this)) continue;
                return;
            }
        }
        this.lastKeyDown = -1;
    }

    final void mouseEntered(int x, int y, int buttonFlags) {
        if (Interface.DEBUG) {
            System.out.println(this + " mouseEntered " + x + "," + y + "," + buttonFlags);
        }
        if (this.mouseListeners != null) {
            Iterator i = this.mouseListeners.iterator();
            while (i.hasNext()) {
                if (!((MouseListener)i.next()).mouseEntered(this, x, y, buttonFlags)) continue;
                return;
            }
        }
        this.mouseInside = true;
    }

    final void mouseExited(int x, int y, int buttonFlags) {
        if (Interface.DEBUG) {
            System.out.println(this + " mouseExited " + x + "," + y + "," + buttonFlags);
        }
        if (this.mouseListeners != null) {
            Iterator i = this.mouseListeners.iterator();
            while (i.hasNext()) {
                if (!((MouseListener)i.next()).mouseExited(this, x, y, buttonFlags)) continue;
                return;
            }
        }
        this.mouseInside = false;
    }

    final void mouseMoved(int x, int y, int buttonFlags) {
        if (Interface.DEBUG) {
            System.out.println(this + " mouseMoved " + x + "," + y + "," + buttonFlags);
        }
        if (this.mouseListeners != null) {
            Iterator i = this.mouseListeners.iterator();
            while (i.hasNext()) {
                if (!((MouseListener)i.next()).mouseMoved(this, x, y, buttonFlags)) continue;
                return;
            }
        }
    }

    public Component pack() {
        if (this.children == null) {
            return this;
        }
        int n = this.children.size();
        if (n == 0) {
            return this;
        }
        Rectangle r = new Rectangle();
        Rectangle r2 = new Rectangle();
        int i = 0;
        while (i < n) {
            Component c = (Component)this.children.get(i);
            r.union((ReadableRectangle)c.getBounds(r2), (WritableRectangle)r);
            ++i;
        }
        this.setLocation(r.getX(), r.getY());
        this.setSize(r.getWidth(), r.getHeight());
        return this;
    }

    protected void postRender() {
    }

    protected void preRender() {
    }

    private void processDrag() {
        if (Interface.DEBUG) {
            System.out.println(this + " processDrag");
        }
        if (Interface.objectUnderMouse != Interface.lastObjectUnderMouse) {
            if (this.isDragCaptured()) {
                this.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
                this.dragWithin(Interface.local.getX(), Interface.local.getY(), this);
                this.setChanged(true);
            } else {
                if (Interface.lastObjectUnderMouse != null) {
                    Interface.lastObjectUnderMouse.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
                    Interface.lastObjectUnderMouse.dragLeave(Interface.local.getX(), Interface.local.getY(), this);
                    Interface.lastObjectUnderMouse.setChanged(true);
                }
                if (Interface.objectUnderMouse != null) {
                    Interface.objectUnderMouse.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
                    Interface.objectUnderMouse.dragEnter(Interface.local.getX(), Interface.local.getY(), this);
                    Interface.objectUnderMouse.setChanged(true);
                }
            }
        } else if (this.isDragCaptured()) {
            this.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
            this.dragWithin(Interface.local.getX(), Interface.local.getY(), this);
            this.setChanged(true);
        } else if (Interface.objectUnderMouse != null) {
            Interface.objectUnderMouse.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
            Interface.objectUnderMouse.dragWithin(Interface.local.getX(), Interface.local.getY(), this);
            Interface.objectUnderMouse.setChanged(true);
        }
    }

    final void processMouseEvent() {
        if (Interface.lastMousePos.newButtonFlags != 0 && this.buttonDownFlags != 0) {
            if (this.dragging) {
                this.processDrag();
            } else {
                this.processMouseMovement();
            }
        } else {
            if (Interface.objectUnderMouse == this) {
                if (this.dragging) {
                    this.dragEnd();
                }
                this.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
                int oldButtonDownFlags = this.buttonDownFlags;
                if ((oldButtonDownFlags & 1) != 0) {
                    this.leftButtonUp(Interface.local.getX(), Interface.local.getY());
                }
                if ((oldButtonDownFlags & 2) != 0) {
                    this.rightButtonUp(Interface.local.getX(), Interface.local.getY());
                }
                if (Interface.capture == this) {
                    if ((oldButtonDownFlags & 1) != 0) {
                        this.leftButtonClicked(Interface.local.getX(), Interface.local.getY());
                    }
                    if ((oldButtonDownFlags & 2) != 0) {
                        this.rightButtonClicked(Interface.local.getX(), Interface.local.getY());
                    }
                }
                if (this.selectDown) {
                    this.selectUp();
                    this.selected();
                }
                this.buttonDownFlags = 0;
                this.setChanged(true);
            } else if (Interface.objectUnderMouse == null) {
                if (this.dragging) {
                    this.dragEnd();
                    this.setChanged(true);
                }
            } else {
                Interface.objectUnderMouse.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
                if (this.dragging) {
                    this.dragEnd();
                    Interface.objectUnderMouse.dragDrop(Interface.local.getX(), Interface.local.getY(), this);
                    Interface.objectUnderMouse.setChanged(true);
                    this.setChanged(true);
                }
                if (Interface.capture == Interface.objectUnderMouse) {
                    if ((this.buttonDownFlags & 1) != 0) {
                        Interface.objectUnderMouse.leftButtonClicked(Interface.local.getX(), Interface.local.getY());
                    }
                    if ((this.buttonDownFlags & 1) != 0) {
                        Interface.objectUnderMouse.rightButtonClicked(Interface.local.getX(), Interface.local.getY());
                    }
                }
                if (Interface.objectUnderMouse.selectDown) {
                    Interface.objectUnderMouse.selectUp();
                    Interface.objectUnderMouse.selected();
                }
                Interface.objectUnderMouse.buttonDownFlags = 0;
            }
            Interface.setCapture(null);
        }
    }

    private void processMouseMovement() {
        if (Interface.DEBUG) {
            System.out.println(this + " processMouseMovement");
        }
        if (Interface.objectUnderMouse != Interface.lastObjectUnderMouse) {
            if (this.isDragCaptured()) {
                this.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
                this.dragCount = 3;
                this.capturedMouseMoved(this.mouseDownX, this.mouseDownY);
                this.setChanged(true);
            } else {
                if (Interface.lastObjectUnderMouse == this) {
                    this.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
                    this.buttonDownFlags = Interface.lastMousePos.newButtonFlags;
                    this.mouseExited(Interface.local.getX(), Interface.local.getY(), this.buttonDownFlags);
                    this.capturedMouseExited(Interface.local.getX(), Interface.local.getY());
                    this.setChanged(true);
                } else if (Interface.lastObjectUnderMouse != null) {
                    Interface.lastObjectUnderMouse.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
                    this.buttonDownFlags = Interface.lastMousePos.newButtonFlags;
                    Interface.lastObjectUnderMouse.mouseExited(Interface.local.getX(), Interface.local.getY(), this.buttonDownFlags);
                    Interface.lastObjectUnderMouse.capturedMouseExited(Interface.local.getX(), Interface.local.getY());
                    Interface.lastObjectUnderMouse.setChanged(true);
                }
                if (Interface.objectUnderMouse == this) {
                    this.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
                    this.buttonDownFlags = Interface.lastMousePos.newButtonFlags;
                    this.mouseEntered(Interface.local.getX(), Interface.local.getY(), this.buttonDownFlags);
                    this.capturedMouseEntered(Interface.local.getX(), Interface.local.getY());
                    this.setChanged(true);
                } else if (Interface.objectUnderMouse != null) {
                    Interface.objectUnderMouse.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
                    this.buttonDownFlags = Interface.lastMousePos.newButtonFlags;
                    Interface.objectUnderMouse.mouseEntered(Interface.local.getX(), Interface.local.getY(), this.buttonDownFlags);
                    Interface.objectUnderMouse.capturedMouseEntered(Interface.local.getX(), Interface.local.getY());
                    Interface.objectUnderMouse.setChanged(true);
                }
            }
        } else if (Interface.objectUnderMouse != null) {
            Interface.objectUnderMouse.getLocalLocation(Interface.lastMousePos.x, Interface.lastMousePos.y, Interface.local);
            Interface.objectUnderMouse.mouseMoved(Interface.local.getX(), Interface.local.getY(), this.buttonDownFlags);
            Interface.objectUnderMouse.capturedMouseMoved(Interface.local.getX(), Interface.local.getY());
            Interface.objectUnderMouse.setChanged(true);
            if (this.buttonDownFlags != Interface.lastMousePos.newButtonFlags) {
                if ((this.buttonDownFlags & 1) != 0 && (Interface.lastMousePos.newButtonFlags & 1) == 0) {
                    this.leftButtonUp(Interface.local.getX(), Interface.local.getY());
                } else if ((this.buttonDownFlags & 1) == 0 && (Interface.lastMousePos.newButtonFlags & 1) != 0) {
                    this.leftButtonDown(Interface.local.getX(), Interface.local.getY());
                }
                if ((this.buttonDownFlags & 2) != 0 && (Interface.lastMousePos.newButtonFlags & 2) == 0) {
                    this.rightButtonUp(Interface.local.getX(), Interface.local.getY());
                } else if ((this.buttonDownFlags & 2) == 0 && (Interface.lastMousePos.newButtonFlags & 2) != 0) {
                    this.rightButtonDown(Interface.local.getX(), Interface.local.getY());
                }
            }
            this.buttonDownFlags = Interface.lastMousePos.newButtonFlags;
        }
    }

    private final void removeScreenLocation(Point l) {
        l.translate(-this.location.getX(), -this.location.getY());
        if (this.parent != null) {
            this.parent.removeScreenLocation(l);
        }
    }

    public final void render() {
        block16: {
            this.changed = false;
            if (!this.visible) {
                return;
            }
            GL11.glPushMatrix();
            try {
                try {
                    boolean bordered;
                    GL11.glTranslatef((float)(this.location.getX() - this.border.getX()), (float)(this.location.getY() - this.border.getY()), (float)0.0f);
                    this.getScreenLocation(this.screenLocation);
                    this.clip.setBounds(this.screenLocation.getX() - this.border.getX(), this.screenLocation.getY() - this.border.getY(), this.getWidth(), this.getHeight());
                    if (this.parent != null) {
                        this.clip.intersection((ReadableRectangle)this.parent.clip, this.clip);
                    } else {
                        this.clip.intersection((ReadableRectangle)screenBounds, this.clip);
                    }
                    if (this.clipped && (this.clip.getWidth() <= 0 || this.clip.getHeight() <= 0)) break block16;
                    int clipx = this.clip.getX() * Game.getWidth() / 800;
                    int clipw = this.clip.getWidth() * Game.getWidth() / 800;
                    int clipy = this.clip.getY() * Game.getHeight() / 600;
                    int cliph = this.clip.getHeight() * Game.getHeight() / 600;
                    if (this.clipped) {
                        GL11.glScissor((int)clipx, (int)clipy, (int)clipw, (int)cliph);
                        GL11.glEnable((int)3089);
                    }
                    this.preRender();
                    this.renderBackground();
                    boolean bl = bordered = this.border.getX() != 0 || this.border.getY() != 0;
                    if (bordered) {
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)this.border.getX(), (float)this.border.getY(), (float)0.0f);
                    }
                    try {
                        this.renderChildren();
                        if (this.clipped) {
                            GL11.glScissor((int)clipx, (int)clipy, (int)clipw, (int)cliph);
                            GL11.glEnable((int)3089);
                        }
                        this.renderSelf();
                    }
                    finally {
                        if (bordered) {
                            GL11.glPopMatrix();
                        }
                    }
                    if (this.clipped) {
                        GL11.glDisable((int)3089);
                    }
                    this.renderForeground();
                    this.postRender();
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    this.setVisible(false);
                }
            }
            finally {
                GL11.glPopMatrix();
            }
        }
    }

    protected void renderBackground() {
        if (this.backgroundColor != null) {
            this.setGLColor(this.backgroundColor);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3553);
            GL11.glBegin((int)7);
            GL11.glVertex2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)(this.size.getWidth() + this.border.getX() + this.border.getWidth()), (float)0.0f);
            GL11.glVertex2f((float)(this.size.getWidth() + this.border.getX() + this.border.getWidth()), (float)(this.size.getHeight() + this.border.getY() + this.border.getHeight()));
            GL11.glVertex2f((float)0.0f, (float)(this.size.getHeight() + this.border.getY() + this.border.getHeight()));
            GL11.glEnd();
        }
    }

    protected void renderChildren() {
        if (this.children == null) {
            return;
        }
        int n = this.children.size();
        int i = 0;
        while (i < n) {
            ((Component)this.children.get(i)).render();
            ++i;
        }
    }

    protected void renderForeground() {
    }

    protected void renderSelf() {
    }

    public void requestFocus() {
        Interface.setCurrentFocus(this);
        this.setChanged(true);
    }

    private final void selectDown() {
        if (!this.isEnabled()) {
            return;
        }
        if (Interface.DEBUG) {
            System.out.println(this + " selectDown");
        }
        if (this.selectionListeners != null) {
            Iterator i = this.selectionListeners.iterator();
            while (i.hasNext()) {
                if (!((SelectionListener)i.next()).selectDown(this)) continue;
                return;
            }
        }
        this.requestFocus();
        this.selectDown = true;
    }

    private final void selected() {
        if (Interface.DEBUG) {
            System.out.println(this + " selected");
        }
        if (this.selectionListeners != null) {
            Iterator i = this.selectionListeners.iterator();
            while (i.hasNext()) {
                if (!((SelectionListener)i.next()).selected(this)) continue;
                return;
            }
        }
        this.setChanged(true);
    }

    private final void selectUp() {
        if (Interface.DEBUG) {
            System.out.println(this + " selectUp");
        }
        if (this.selectionListeners != null) {
            Iterator i = this.selectionListeners.iterator();
            while (i.hasNext()) {
                if (!((SelectionListener)i.next()).selectUp(this)) continue;
                return;
            }
        }
        this.selectDown = false;
    }

    public final Component setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.setChanged(true);
        return this;
    }

    public Component setBorder(int left, int bottom, int right, int top) {
        if (left != this.border.getX() || bottom != this.border.getY() || right != this.border.getWidth() || top != this.border.getHeight()) {
            this.setChanged(true);
            this.border.setBounds(left, bottom, right, top);
        }
        return this;
    }

    public Component setBorder(Rectangle newBorder) {
        return this.setBorder(newBorder.getX(), newBorder.getY(), newBorder.getWidth(), newBorder.getHeight());
    }

    public Component setBounds(int rx, int ry, int rwidth, int rheight) {
        if ((rx -= this.border.getX()) != this.location.getX() || (ry -= this.border.getY()) != this.location.getY() || (rwidth -= this.border.getX() + this.border.getWidth()) != this.size.getWidth() || (rheight -= this.border.getY() + this.border.getHeight()) != this.size.getHeight()) {
            this.location.setX(rx);
            this.location.setY(ry);
            this.size.setWidth(rwidth);
            this.size.setHeight(rheight);
            this.invalidate();
        }
        return this;
    }

    public Component setBounds(Rectangle r) {
        return this.setBounds(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    protected final void setCanFocus(boolean newCanFocus) {
        this.canFocus = newCanFocus;
        Interface.setFocusPathNeedsUpdating(true);
    }

    protected final void setChanged(boolean newChanged) {
        if (newChanged) {
            this.setParentChanged(true);
            this.setChildrenChanged(true);
        } else {
            this.changed = false;
        }
    }

    private final void setChildrenChanged(boolean newChanged) {
        this.changed = newChanged;
        if (this.children == null) {
            return;
        }
        int n = this.children.size();
        int i = 0;
        while (i < n) {
            ((Component)this.children.get(i)).setChildrenChanged(newChanged);
            ++i;
        }
    }

    private final void markChildrenInvalid() {
        this.valid = false;
        if (this.children != null) {
            int n = this.children.size();
            int i = 0;
            while (i < n) {
                ((Component)this.children.get(i)).markChildrenInvalid();
                ++i;
            }
        }
    }

    public final void setClipped(boolean newClipped) {
        if (newClipped != this.clipped) {
            this.setChanged(true);
            this.clipped = newClipped;
        }
    }

    public final void setKeyboardDelegate(Component delegate) {
        this.keyboardDelegate = delegate;
    }

    public final void setDelegate(Component delegate) {
        this.delegate = delegate;
    }

    public void setDragCaptured(boolean dragCaptured) {
        this.dragCaptured = dragCaptured;
    }

    public Component setDraggable(boolean newDraggable) {
        this.draggable = newDraggable;
        return this;
    }

    public Component setEnabled(boolean newEnabled) {
        if (this.enabled != newEnabled) {
            this.setChanged(true);
            this.enabled = newEnabled;
            Interface.setFocusPathNeedsUpdating(true);
        }
        return this;
    }

    public Component setFont(GLFont newFont) {
        if (this.font == null && newFont != null || this.font != null && !this.font.equals(newFont)) {
            this.invalidate();
            this.font = newFont;
        }
        return this;
    }

    public final Component setForegroundColor(Color color) {
        this.foregroundColor = color;
        this.setChanged(true);
        return this;
    }

    public final Component setHeight(int h) {
        if ((h -= this.border.getHeight() + this.border.getY()) != this.size.getHeight()) {
            this.invalidate();
            this.size.setHeight(h);
        }
        return this;
    }

    public final Component setLocation(int x, int y) {
        if (x != this.location.getX() || y != this.location.getY()) {
            this.invalidate();
            this.location.setLocation(x, y);
            if (this.buttonDownFlags != 0) {
                this.processMouseEvent();
            }
        }
        return this;
    }

    public final void setMousePointer(MousePointer pointer) {
        this.mousePointer = pointer;
    }

    private final void setParentChanged(boolean newChanged) {
        if (this.changed && this.parent != null) {
            this.parent.changed = true;
            this.parent.setParentChanged(true);
        }
    }

    private final void markParentInvalid() {
        if (this.parent != null) {
            this.parent.valid = false;
            this.parent.markParentInvalid();
        }
    }

    public final Component setSize(int w, int h) {
        if (w < 0 || h < 0) {
            throw new RuntimeException("Illegal size: " + w + ", " + h);
        }
        if (w != this.size.getWidth() || h != this.size.getHeight()) {
            this.invalidate();
            this.size.setSize(w, h);
        }
        return this;
    }

    public Component setVisible(boolean newVisible) {
        if (newVisible != this.visible) {
            this.setChanged(true);
            this.visible = newVisible;
            Interface.setFocusPathNeedsUpdating(true);
        }
        return this;
    }

    public final Component setWidth(int w) {
        if ((w -= this.border.getWidth() + this.border.getX()) != this.size.getWidth()) {
            this.invalidate();
            this.size.setWidth(w);
        }
        return this;
    }

    public final Component setX(int x) {
        if (x != this.location.getX()) {
            this.invalidate();
            this.location.setX(x);
        }
        return this;
    }

    public final Component setY(int y) {
        if (y != this.location.getY()) {
            this.invalidate();
            this.location.setY(y);
        }
        return this;
    }

    public final boolean tick() {
        if (!this.visible) {
            return false;
        }
        boolean changed = false;
        try {
            this.layout();
            changed = this.doTick();
            changed |= this.isChanged();
            if (this.visible && this.children != null) {
                int n = this.children.size();
                int i = 0;
                while (i < n) {
                    changed |= ((Component)this.children.get(i)).tick();
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            this.setVisible(false);
        }
        return changed;
    }

    public String toString() {
        return String.valueOf(this.name == null ? "Component" : this.name) + " [(" + this.location.getX() + ", " + this.location.getY() + "), " + this.size.getWidth() + "x" + this.size.getHeight() + ", visible=" + this.visible + " enabled=" + this.enabled + "]";
    }

    public void setGLColor(int red, int green, int blue, int alpha) {
        if (!$assertionsDisabled && this.getDialog() == null) {
            throw new AssertionError((Object)"Null dialog");
        }
        GL11.glColor4ub((byte)((byte)red), (byte)((byte)green), (byte)((byte)blue), (byte)((byte)(this.getDialog().isActive() ? alpha : alpha >> 2)));
    }

    public void setGLColor(byte red, byte green, byte blue, byte alpha) {
        if (!$assertionsDisabled && this.getDialog() == null) {
            throw new AssertionError((Object)"Null dialog");
        }
        GL11.glColor4ub((byte)red, (byte)green, (byte)blue, (byte)((byte)(this.getDialog().isActive() ? alpha : alpha >> 2 & 0x3F)));
    }

    public void setGLColor(Color c) {
        if (!$assertionsDisabled && c == null) {
            throw new AssertionError((Object)"Null color");
        }
        if (!$assertionsDisabled && this.getDialog() == null) {
            throw new AssertionError((Object)"Null dialog");
        }
        GL11.glColor4ub((byte)c.getRedByte(), (byte)c.getGreenByte(), (byte)c.getBlueByte(), (byte)((byte)(this.getDialog().isActive() ? c.getAlpha() : c.getAlpha() >> 2 & 0x3F)));
    }

    public void setGLColor(float red, float green, float blue, float alpha) {
        if (!$assertionsDisabled && this.getDialog() == null) {
            throw new AssertionError((Object)"Null dialog");
        }
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)(this.getDialog().isActive() ? alpha : alpha / 4.0f));
    }

    public void addKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners == null) {
            this.keyboardListeners = new ArrayList(1);
        }
        this.keyboardListeners.add(0, listener);
    }

    public void removeKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners != null) {
            this.keyboardListeners.remove(listener);
        }
    }

    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new ArrayList(1);
        }
        this.mouseListeners.add(0, listener);
    }

    public void addExtraMouseListener(ExtraMouseListener listener) {
        if (this.extraMouseListeners == null) {
            this.extraMouseListeners = new ArrayList(1);
        }
        this.extraMouseListeners.add(0, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        if (this.mouseListeners != null) {
            this.mouseListeners.remove(listener);
        }
    }

    public void removeExtraMouseListener(ExtraMouseListener listener) {
        if (this.extraMouseListeners != null) {
            this.extraMouseListeners.remove(listener);
        }
    }

    public void addDragListener(DragListener listener) {
        if (this.dragListeners == null) {
            this.dragListeners = new ArrayList(1);
        }
        this.dragListeners.add(0, listener);
    }

    public void removeDragListener(DragListener listener) {
        if (this.dragListeners != null) {
            this.dragListeners.remove(listener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList(1);
        }
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove(listener);
        }
    }

    public void addFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            this.focusListeners = new ArrayList(1);
        }
        this.focusListeners.add(0, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        if (this.focusListeners != null) {
            this.focusListeners.remove(listener);
        }
    }

    public void addCapturedMouseListener(CapturedMouseListener listener) {
        if (this.capturedMouseListeners == null) {
            this.capturedMouseListeners = new ArrayList(1);
        }
        this.capturedMouseListeners.add(0, listener);
    }

    public void removeCapturedMouseListener(CapturedMouseListener listener) {
        if (this.capturedMouseListeners != null) {
            this.capturedMouseListeners.remove(listener);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getHorizontalScrollNextPage(int vwidth, int xpos) {
        return 1;
    }

    public int getHorizontalScrollPrevPage(int vwidth, int xpos) {
        return -1;
    }

    public int getVerticalScrollNextPage(int vheight, int ypos) {
        return -1;
    }

    public int getVerticalScrollPrevPage(int vheight, int ypos) {
        return 1;
    }

    public void ensureVisible(Rectangle area) {
        if (this.parent != null) {
            area.translate(this.location.getX(), this.location.getY());
            this.parent.ensureVisible(area);
        }
    }

    public Rectangle getVisibleArea(Rectangle dest) {
        if (dest == null) {
            dest = new Rectangle();
        }
        Component parent = this.getParent();
        this.getBounds(dest);
        int finalOffsetX = -dest.getX();
        int finalOffsetY = -dest.getY();
        int parentX = 0;
        int parentY = 0;
        while (parent != null) {
            parent.getBounds(tempBounds0);
            parentX = tempBounds0.getX();
            parentY = tempBounds0.getY();
            tempBounds0.setLocation(0, 0);
            dest.intersection((ReadableRectangle)tempBounds0, dest);
            dest.translate(parentX, parentY);
            finalOffsetX -= parentX;
            finalOffsetY -= parentY;
            parent = parent.getParent();
        }
        dest.translate(finalOffsetX, finalOffsetY);
        return dest;
    }

    protected boolean handleNextFocus() {
        return false;
    }

    protected boolean handlePriorFocus() {
        return false;
    }
}

