/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.w3c.dom.Element;
import xap.Game;
import xap.Gidrah;
import xap.HomingMovement;
import xap.features.EntityFeature;
import xap.features.GidrahFeature;
import xap.gidrahs.BasicGidrahFeature;
import xap.resources.HomingMovementResource;

public class TwitchyPodFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private static final Vector3i scratchVector = new Vector3i();
    private String animation;
    private String shadowAnimation;
    private String splitsInto;
    private int minSplits;
    private int maxSplits;
    private int difficultyFactor;
    private HomingMovementResource movementResource;
    private transient Animation animationResource;
    private transient Animation shadowAnimationResource;
    private transient GidrahFeature splitsIntoFeature;

    public TwitchyPodFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new TwitchyPodInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.animation = XMLUtil.getString((Element)element, (String)"animation");
        this.shadowAnimation = XMLUtil.getString((Element)element, (String)"shadowanimation");
        this.splitsInto = XMLUtil.getString((Element)element, (String)"splitsinto", null);
        if (this.splitsInto != null) {
            this.minSplits = XMLUtil.getInt((Element)element, (String)"minsplits");
            this.maxSplits = XMLUtil.getInt((Element)element, (String)"maxsplits");
        }
        this.difficultyFactor = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"difficultyfactor"));
        this.movementResource = new HomingMovementResource();
        this.movementResource.load(element, loader);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.animationResource = (Animation)Resources.get((String)this.animation);
        this.shadowAnimationResource = (Animation)Resources.get((String)this.shadowAnimation);
        if (this.splitsInto != null) {
            this.splitsIntoFeature = (GidrahFeature)Resources.get((String)this.splitsInto);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.animationResource = null;
        this.shadowAnimationResource = null;
        this.splitsIntoFeature = null;
    }

    private class TwitchyPodInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private HomingMovement movementInstance;

        TwitchyPodInstance() {
            this.movementInstance = TwitchyPodFeature.this.movementResource.spawn(this);
        }

        protected void initSprite() {
            this.sprite.setAnimation(TwitchyPodFeature.this.animationResource);
            this.shadowSprite.setAnimation(TwitchyPodFeature.this.shadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            if (Math.random() < 0.0025) {
                this.selectNewTarget();
            }
            this.movementInstance.tick();
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected void doResIn() {
            this.randomLocation(this.position);
            this.selectNewTarget();
        }

        private void selectNewTarget() {
            this.randomLocation(scratchVector);
            this.movementInstance.setDestination(scratchVector.getX(), scratchVector.getY());
        }

        protected void onDeath() {
            super.onDeath();
            if (TwitchyPodFeature.this.splitsIntoFeature != null) {
                int mult = Game.getCurrentLevel() * TwitchyPodFeature.this.difficultyFactor;
                int num = TwitchyPodFeature.this.minSplits + FPMath.intValue((int)FPMath.mul((int)mult, (int)TwitchyPodFeature.this.maxSplits));
                int i = 0;
                while (i < num) {
                    Gidrah gidrah = (Gidrah)TwitchyPodFeature.this.splitsIntoFeature.spawn();
                    gidrah.setPosition(this.position.getX() + Util.random((int)(-FPMath.EIGHT), (int)FPMath.EIGHT), this.position.getY() + Util.random((int)(-FPMath.EIGHT), (int)FPMath.EIGHT), 0);
                    ++i;
                }
            }
        }
    }
}

