/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.w3c.dom.Element;
import xap.Bullet;
import xap.Game;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;

public class PuffbombFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private static final int WAITING = 0;
    private static final int EXPLODING = 1;
    private static final int FLYING = 2;
    private static final Vector3i scratchVector = new Vector3i();
    private int minTime;
    private int maxTime;
    private int minSpores;
    private int maxSpores;
    private int minVelocity;
    private int maxVelocity;
    private String sporeImage;
    private String sporeShadowImage;
    private String explosionAnimation;
    private String explosionShadowAnimation;
    private String sporeExplosionEmitter;
    private int resInVariation;
    private int resInDistance;
    private int deceleration;
    private int maxChildren;
    private int maxPuffbombs;
    private transient SpriteImage sporeImageResource;
    private transient SpriteImage sporeShadowImageResource;
    private transient Animation explosionAnimationResource;
    private transient Animation explosionShadowAnimationResource;
    private transient EmitterFeature sporeExplosionEmitterFeature;
    private transient int totalPuffbombs;

    public PuffbombFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new PuffbombInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.sporeImageResource = (SpriteImage)Resources.get((String)this.sporeImage);
        this.sporeShadowImageResource = (SpriteImage)Resources.get((String)this.sporeShadowImage);
        this.explosionAnimationResource = (Animation)Resources.get((String)this.explosionAnimation);
        this.explosionShadowAnimationResource = (Animation)Resources.get((String)this.explosionShadowAnimation);
        this.sporeExplosionEmitterFeature = (EmitterFeature)Resources.get((String)this.sporeExplosionEmitter);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.sporeImageResource = null;
        this.sporeShadowImageResource = null;
        this.explosionAnimationResource = null;
        this.explosionShadowAnimationResource = null;
        this.sporeExplosionEmitterFeature = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.resInVariation = XMLUtil.getInt((Element)element, (String)"resinvariation");
        this.resInDistance = XMLUtil.getInt((Element)element, (String)"resindistance");
        this.maxChildren = XMLUtil.getInt((Element)element, (String)"maxchildren");
        this.minTime = XMLUtil.getInt((Element)element, (String)"mintime");
        this.maxTime = XMLUtil.getInt((Element)element, (String)"maxtime");
        this.minSpores = XMLUtil.getInt((Element)element, (String)"minspores");
        this.maxSpores = XMLUtil.getInt((Element)element, (String)"maxspores");
        this.minVelocity = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"minvelocity"));
        this.maxVelocity = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"maxvelocity"));
        this.deceleration = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"deceleration"));
        this.sporeImage = XMLUtil.getString((Element)element, (String)"sporeimage");
        this.sporeShadowImage = XMLUtil.getString((Element)element, (String)"sporeshadowimage");
        this.explosionAnimation = XMLUtil.getString((Element)element, (String)"explosionanimation");
        this.explosionShadowAnimation = XMLUtil.getString((Element)element, (String)"explosionshadowanimation");
        this.sporeExplosionEmitter = XMLUtil.getString((Element)element, (String)"sporeexplosionemitter");
        this.maxPuffbombs = XMLUtil.getInt((Element)element, (String)"maxpuffbombs");
    }

    public void onNewLevel() throws Exception {
        super.onNewLevel();
        this.totalPuffbombs = 0;
    }

    private class PuffbombInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private int tick;
        private int phase;
        private int speed;
        private int angle;
        private int children;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.gidrahs.full.PuffbombFeature$PuffbombInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        PuffbombInstance() {
        }

        protected void initSprite() {
            this.sprite.setImage(PuffbombFeature.this.sporeImageResource);
            this.shadowSprite.setImage(PuffbombFeature.this.sporeShadowImageResource);
            this.shadowSprite.setScale(FPMath.TWO);
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            block0 : switch (this.phase) {
                case 0: {
                    this.tick -= Game.getOptions().getTicksPerFrame();
                    if (this.tick <= 0) {
                        this.explode();
                    } else {
                        return;
                    }
                }
                case 1: {
                    if (this.sprite.getEvent() == 0) {
                        return;
                    }
                    this.remove();
                    int nSpores = Util.random((int)PuffbombFeature.this.minSpores, (int)PuffbombFeature.this.maxSpores);
                    if (this.children >= PuffbombFeature.this.maxChildren || PuffbombFeature.this.totalPuffbombs >= PuffbombFeature.this.maxPuffbombs) {
                        int i = 0;
                        while (i < nSpores) {
                            int angle = Util.random((int)0, (int)65535);
                            scratchVector.set(this.position.getX() + (FPMath.cos((int)angle) << 8), this.position.getY() + (FPMath.sin((int)angle) << 8), 0);
                            Bullet b = (Bullet)PuffbombFeature.this.bulletFeature.spawn();
                            if (b == null) break block0;
                            b.fireAt(this, scratchVector, 100);
                            ++i;
                        }
                    } else {
                        ++this.children;
                        int i = 0;
                        while (i < nSpores) {
                            PuffbombInstance newBomb = (PuffbombInstance)PuffbombFeature.this.spawn();
                            if (newBomb == null) break block0;
                            newBomb.position.set((ReadableVector3i)this.position);
                            newBomb.phase = 2;
                            newBomb.children = this.children;
                            newBomb.angle = Util.random((int)0, (int)65535);
                            newBomb.speed = Util.random((int)PuffbombFeature.this.minVelocity, (int)PuffbombFeature.this.maxVelocity) << Game.getOptions().getSpeedShift();
                            newBomb.hatch();
                            ++i;
                        }
                    }
                    break;
                }
                case 2: {
                    this.speed -= PuffbombFeature.this.deceleration << Game.getOptions().getSpeedShift();
                    if (this.speed <= 0) {
                        this.phase = 0;
                        this.tick = Util.random((int)PuffbombFeature.this.minTime, (int)PuffbombFeature.this.maxTime);
                        break;
                    }
                    this.velocity.set(FPMath.mul((int)FPMath.cos((int)this.angle), (int)this.speed), FPMath.mul((int)FPMath.sin((int)this.angle), (int)this.speed), 0);
                    Vector3i.add((ReadableVector3i)this.position, (ReadableVector3i)this.velocity, (WritableVector3i)this.position);
                    this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
                    this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        protected void doResIn() {
            this.randomLocation(Game.getPlayer().getLastKnownPosition(), ((float)Math.random() - 0.5f) * (float)PuffbombFeature.this.resInVariation + (float)PuffbombFeature.this.resInDistance, this.position);
            this.phase = 0;
            this.tick = Util.random((int)PuffbombFeature.this.minTime, (int)PuffbombFeature.this.maxTime);
        }

        private void explode() {
            this.sprite.setAnimation(PuffbombFeature.this.explosionAnimationResource);
            this.shadowSprite.setAnimation(PuffbombFeature.this.explosionShadowAnimationResource);
            this.phase = 1;
            PuffbombFeature.this.sporeExplosionEmitterFeature.spawn(this.position.getX(), this.position.getY(), 0, 0, 0, 0);
        }

        protected void doGidrahBirth() {
            super.doGidrahBirth();
            PuffbombFeature puffbombFeature = PuffbombFeature.this;
            puffbombFeature.totalPuffbombs = puffbombFeature.totalPuffbombs + 1;
        }

        protected void doGidrahRemove() {
            super.doGidrahRemove();
            PuffbombFeature puffbombFeature = PuffbombFeature.this;
            puffbombFeature.totalPuffbombs = puffbombFeature.totalPuffbombs - 1;
        }
    }
}

