/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.Game;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;

public class MushroomFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private String animation;
    private String shadowAnimation;
    private int resInDistance;
    private int resInVariation;
    private String soundEffect;
    private transient Animation animationResource;
    private transient Animation shadowAnimationResource;
    private transient ALBuffer soundEffectResource;

    public MushroomFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new MushroomInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.animationResource = (Animation)Resources.get((String)this.animation);
        this.shadowAnimationResource = (Animation)Resources.get((String)this.shadowAnimation);
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.animationResource = null;
        this.shadowAnimationResource = null;
        this.soundEffect = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.animation = XMLUtil.getString((Element)element, (String)"animation");
        this.shadowAnimation = XMLUtil.getString((Element)element, (String)"shadowanimation");
        this.resInDistance = XMLUtil.getInt((Element)element, (String)"resindistance");
        this.resInVariation = XMLUtil.getInt((Element)element, (String)"resinvariation");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
    }

    private class MushroomInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private boolean immune;

        protected void initSprite() {
            this.sprite.setAnimation(MushroomFeature.this.animationResource);
            this.shadowSprite.setAnimation(MushroomFeature.this.shadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            switch (this.sprite.getEvent()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.fire();
                    this.sprite.setEvent(0);
                    break;
                }
                case 2: {
                    this.teleport();
                    this.immune = true;
                    this.sprite.setEvent(0);
                    break;
                }
                case 3: {
                    this.immune = false;
                    this.sprite.rewind();
                    this.shadowSprite.rewind();
                    this.sprite.setEvent(0);
                    Game.allocateSound(MushroomFeature.this.soundEffectResource, this.position, null, this);
                }
            }
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected void doResIn() {
            this.teleport();
        }

        private void teleport() {
            this.randomLocation(Game.getPlayer().getLastKnownPosition(), ((float)Math.random() - 0.5f) * (float)MushroomFeature.this.resInVariation + (float)MushroomFeature.this.resInDistance, this.position);
        }

        public boolean canCollide() {
            return super.canCollide() && !this.immune;
        }
    }
}

