/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.Blob;
import xap.Game;
import xap.HomingMovement;
import xap.MadJelly;
import xap.features.BlobFeature;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;
import xap.resources.HomingMovementResource;

public class BlitterFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private HomingMovementResource movementFeature;
    private String animation;
    private String shadowAnimation;
    private transient Animation animationResource;
    private transient Animation shadowAnimationResource;

    public BlitterFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.movementFeature = new HomingMovementResource();
        this.movementFeature.load(element, loader);
        this.animation = XMLUtil.getString((Element)element, (String)"animation");
        this.shadowAnimation = XMLUtil.getString((Element)element, (String)"shadowanimation");
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.animationResource = (Animation)Resources.get((String)this.animation);
        this.shadowAnimationResource = (Animation)Resources.get((String)this.shadowAnimation);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.animationResource = null;
        this.shadowAnimationResource = null;
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new BlitterInstance();
    }

    private final class BlitterInstance
    extends BasicGidrahFeature.BasicGidrahInstance
    implements MadJelly {
        private final HomingMovement movement;
        private Blob blob;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.gidrahs.full.BlitterFeature$BlitterInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        BlitterInstance() {
            this.movement = BlitterFeature.this.movementFeature.spawn(this);
        }

        protected void doGidrahBirth() {
        }

        protected void initSprite() {
            this.sprite.setAnimation(BlitterFeature.this.animationResource);
            this.shadowSprite.setAnimation(BlitterFeature.this.shadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            int desty;
            int destx;
            super.doGidrahTick();
            if (this.blob == null || Math.random() < 0.0025 || !this.blob.isAlive()) {
                this.blob = BlobFeature.getRandomBlob();
            }
            if (this.blob == null) {
                destx = Game.getPlayer().getLastKnownPosition().getX();
                desty = Game.getPlayer().getLastKnownPosition().getY();
            } else {
                destx = this.blob.getPosition().getX();
                desty = this.blob.getPosition().getY();
            }
            this.movement.setDestination(destx, desty);
            this.movement.tick();
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected void doResIn() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }
}

