/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import org.w3c.dom.Element;
import xap.Emitter;
import xap.Game;
import xap.Gunner;
import xap.HomingMovement;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;
import xap.resources.HomingMovementResource;

public class GunnerFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private HomingMovementResource movementFeature;
    private int shootInterval;
    private float resInDistance;
    private float difficultyFactor;
    private String gunnerAnimation;
    private String gunnerShadowAnimation;
    private String smokeEmitter;
    private transient Animation gunnerAnimationResource;
    private transient Animation gunnerShadowAnimationResource;
    private transient EmitterFeature smokeEmitterFeature;

    public GunnerFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.movementFeature = new HomingMovementResource();
        this.movementFeature.load(element, loader);
        this.shootInterval = XMLUtil.getInt((Element)element, (String)"shootinterval");
        this.difficultyFactor = XMLUtil.getFloat((Element)element, (String)"difficultyfactor");
        this.resInDistance = XMLUtil.getFloat((Element)element, (String)"resindistance");
        this.gunnerAnimation = XMLUtil.getString((Element)element, (String)"gunneranimation");
        this.gunnerShadowAnimation = XMLUtil.getString((Element)element, (String)"gunnershadowanimation");
        this.smokeEmitter = XMLUtil.getString((Element)element, (String)"smokeemitter");
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.gunnerAnimationResource = (Animation)Resources.get((String)this.gunnerAnimation);
        this.gunnerShadowAnimationResource = (Animation)Resources.get((String)this.gunnerShadowAnimation);
        this.smokeEmitterFeature = (EmitterFeature)Resources.get((String)this.smokeEmitter);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.gunnerAnimationResource = null;
        this.gunnerShadowAnimationResource = null;
        this.smokeEmitterFeature = null;
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new GunnerInstance();
    }

    private final class GunnerInstance
    extends BasicGidrahFeature.BasicGidrahInstance
    implements Gunner {
        private int shootTick;
        private Emitter smokeEmitterInstance;
        private final HomingMovement movement;

        GunnerInstance() {
            this.movement = GunnerFeature.this.movementFeature.spawn(this);
        }

        protected void initSprite() {
            this.sprite.setAnimation(GunnerFeature.this.gunnerAnimationResource);
            this.shadowSprite.setAnimation(GunnerFeature.this.gunnerShadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doResIn() {
            this.randomLocation(this.position);
        }

        protected void doGidrahBirth() {
            this.randomLocation(Game.getPlayer().getLastKnownPosition(), GunnerFeature.this.resInDistance, this.position);
            this.shootTick = GunnerFeature.this.shootInterval;
            this.smokeEmitterInstance = GunnerFeature.this.smokeEmitterFeature.spawn(this.position.getX(), this.position.getY(), this.position.getZ(), 0, 0, 0);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            this.movement.setDestination(Game.getPlayer().getLastKnownPosition().getX(), Game.getPlayer().getLastKnownPosition().getY());
            this.movement.tick();
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.smokeEmitterInstance.getVelocity().set((ReadableVector3i)this.velocity);
            this.shootTick -= Game.getOptions().getTicksPerFrame();
            if (this.shootTick <= 0) {
                this.fire();
                this.shootTick = (int)Math.max((float)(GunnerFeature.this.shootInterval / 2), (float)GunnerFeature.this.shootInterval - (float)Game.getCurrentLevel() * GunnerFeature.this.difficultyFactor) >> Game.getOptions().getSpeedShift();
            }
        }

        protected void doGidrahRemove() {
            super.doGidrahRemove();
            if (this.smokeEmitterInstance != null) {
                this.smokeEmitterInstance.remove();
            }
        }
    }
}

