/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs;

import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import xap.Game;
import xap.features.GidrahFeature;

public abstract class BasicGidrahFeature
extends GidrahFeature {
    public static final long serialVersionUID = 1L;
    private static final Vector3i scratchVector = new Vector3i();

    public BasicGidrahFeature(String name) {
        super(name);
    }

    public abstract class BasicGidrahInstance
    extends GidrahFeature.GidrahInstance {
        protected Sprite sprite;
        protected Sprite shadowSprite;
        private int damageIndicationTick;

        protected BasicGidrahInstance() {
        }

        protected final void onGidrahBirth() {
            this.sprite = Game.allocateSprite(this);
            this.shadowSprite = Game.allocateSprite(this);
            this.shadowSprite.setLayer(-2);
            this.initSprite();
            this.doGidrahBirth();
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected final void removeSprites() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
            if (this.shadowSprite != null) {
                this.shadowSprite.deallocate();
                this.shadowSprite = null;
            }
        }

        protected void doGidrahBirth() {
        }

        protected void doGidrahTick() {
            if (this.damageIndicationTick > 0) {
                this.damageIndicationTick -= Game.getOptions().getTicksPerFrame();
                if (this.damageIndicationTick <= 0) {
                    this.sprite.setFlash(false);
                }
            }
        }

        protected abstract void initSprite();

        public final int constantVelocity(Vector3i a, Vector3i b, int speed, Vector3i dest) {
            Vector3i.sub((ReadableVector3i)b, (ReadableVector3i)a, (WritableVector3i)scratchVector);
            int ret = Math.max(1, FPMath.intValue((int)FPMath.div((int)scratchVector.length(), (int)(speed << Game.getOptions().getSpeedShift()))));
            scratchVector.normalize();
            dest.set((ReadableVector3i)scratchVector);
            dest.scale(speed << Game.getOptions().getSpeedShift());
            return ret;
        }

        protected void indicateDamage() {
            this.sprite.setFlash(true);
            this.damageIndicationTick = 4;
        }
    }
}

