/*
 * Decompiled with CFR 0.152.
 */
package xap.features.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Entity;
import xap.Game;
import xap.Gidrah;
import xap.HomingMovement;
import xap.Orb;
import xap.features.EntityFeature;
import xap.resources.HomingMovementResource;

public class OrbFeature
extends EntityFeature {
    public static final long serialVersionUID = 1L;
    private static OrbFeature orbFeature;
    private int hitPoints;
    private HomingMovementResource movementFeature;
    private String animation;
    private String shadowAnimation;
    private Animation animationResource;
    private Animation shadowAnimationResource;

    public OrbFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new OrbInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.hitPoints = XMLUtil.getInt((Element)element, (String)"hitpoints");
        this.animation = XMLUtil.getString((Element)element, (String)"animation");
        this.shadowAnimation = XMLUtil.getString((Element)element, (String)"shadowanimation");
        this.movementFeature = new HomingMovementResource();
        this.movementFeature.load(element, loader);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.animationResource = (Animation)Resources.get((String)this.animation);
        this.shadowAnimationResource = (Animation)Resources.get((String)this.shadowAnimation);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.animationResource = null;
        this.shadowAnimationResource = null;
    }

    public void register() {
        super.register();
        orbFeature = this;
    }

    public void deregister() {
        super.deregister();
        orbFeature = null;
    }

    public static OrbFeature getOrbFeature() throws Exception {
        if (!orbFeature.isCreated()) {
            orbFeature.create();
        }
        return orbFeature;
    }

    private final class OrbInstance
    extends EntityFeature.EntityInstance
    implements Orb {
        private int hits;
        private final HomingMovement movement;
        private Sprite sprite;
        private Sprite shadowSprite;

        OrbInstance() {
            this.movement = OrbFeature.this.movementFeature.spawn(this);
        }

        public void inCollisionWith(Entity dest) {
            dest.inCollisionWithOrb(this);
        }

        public boolean canCollide() {
            return true;
        }

        protected void doRemove() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
                this.shadowSprite.deallocate();
                this.shadowSprite = null;
            }
        }

        public void inCollisionWithGidrah(Gidrah gidrah) {
            ++this.hits;
            if (this.hits >= OrbFeature.this.hitPoints) {
                Game.getPlayer().removeSpinningOrb();
                this.remove();
            }
        }

        public void spawn() {
            this.sprite = Game.allocateSprite(this);
            this.sprite.setAnimation(OrbFeature.this.animationResource);
            this.shadowSprite = Game.allocateSprite(this);
            this.shadowSprite.setAnimation(OrbFeature.this.shadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
            this.velocity.set(FPMath.fpValue((int)Util.random((int)-4, (int)4)), FPMath.fpValue((int)Util.random((int)-4, (int)4)), 0);
        }

        protected void tick() {
            this.movement.setDestination(Game.getPlayer().getPosition().getX(), Game.getPlayer().getPosition().getY());
            this.movement.tick();
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            return 0.0f;
        }
    }
}

