/*
 * Decompiled with CFR 0.152.
 */
package xap.features.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.algorithms.Bresenham;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Bullet;
import xap.Entity;
import xap.Game;
import xap.Living;
import xap.Player;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;

public class BeamFeature
extends EntityFeature {
    public static final long serialVersionUID = 1L;
    private static final Color tempColor = new Color();
    private static final ArrayList proximal = new ArrayList();
    private static final Bresenham bresenham = new Bresenham();
    private static final int DORMANT = 0;
    private static final int CHARGING = 1;
    private static final int ZAPPING = 2;
    private static final int FADING = 3;
    private int range;
    private String colorSequence;
    private int chargingTime;
    private String soundEffect;
    private String emitter;
    private transient ColorSequenceResource colorSequenceResource;
    private transient ALBuffer soundEffectResource;
    private transient EmitterFeature emitterFeature;
    private transient SpriteImage endSpriteImage;

    public BeamFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new BeamInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.range = XMLUtil.getInt((Element)element, (String)"range");
        this.colorSequence = XMLUtil.getString((Element)element, (String)"colorsequence");
        this.chargingTime = XMLUtil.getInt((Element)element, (String)"chargingtime");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
        this.emitter = XMLUtil.getString((Element)element, (String)"emitter");
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.colorSequenceResource = (ColorSequenceResource)Resources.get((String)this.colorSequence);
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
        this.emitterFeature = (EmitterFeature)Resources.get((String)this.emitter);
        this.endSpriteImage = (SpriteImage)Resources.get((String)"spotlight.16.imagebank.0");
    }

    protected void doDestroy() {
        super.doDestroy();
        this.colorSequenceResource = null;
        this.soundEffectResource = null;
        this.emitterFeature = null;
        this.endSpriteImage = null;
    }

    private class BeamInstance
    extends EntityFeature.EntityInstance
    implements Bullet {
        private int phase;
        private int tick;
        private Living from;
        private final Vector3i target = new Vector3i();
        private SoundEffect chargingSound;
        private Sprite endSprite;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.features.full.BeamFeature$BeamInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        BeamInstance() {
        }

        public void fireAt(Living from, Vector3i target, int accuracy) {
            this.from = from;
            this.target.set((ReadableVector3i)target);
            int aim = Util.random((int)0, (int)100);
            if (aim > accuracy) {
                double angle = Math.random() * Math.PI * 2.0;
                this.target.setX(this.target.getX() + FPMath.fpValue((double)(Math.cos(angle) * (double)(aim - accuracy) * 4.0)));
                this.target.setY(this.target.getY() + FPMath.fpValue((double)(Math.sin(angle) * (double)(aim - accuracy) * 4.0)));
            }
            this.setPhase(1);
            this.chargingSound = Game.allocateSound(BeamFeature.this.soundEffectResource, from.getPosition(), from.getVelocity(), this);
            this.endSprite.setActive(true);
        }

        public void inCollisionWith(Entity dest) {
            dest.inCollisionWithBullet(this);
        }

        public boolean canCollide() {
            return this.phase == 2;
        }

        protected void doRemove() {
            this.endSprite.deallocate();
        }

        public void inCollisionWithPlayer(Player player) {
            this.setPhase(3);
        }

        private void setPhase(int newPhase) {
            switch (newPhase) {
                case 1: {
                    if (!$assertionsDisabled && this.phase != 0) {
                        throw new AssertionError((Object)"Illegal phase change.");
                    }
                    this.phase = newPhase;
                    this.tick = -1;
                    break;
                }
                case 2: {
                    if (!$assertionsDisabled && this.phase != 1) {
                        throw new AssertionError((Object)"Illegal phase change.");
                    }
                    this.phase = newPhase;
                    this.tick = -1;
                    break;
                }
                case 3: {
                    if (!$assertionsDisabled && this.phase != 2) {
                        throw new AssertionError((Object)"Illegal phase change.");
                    }
                    this.phase = newPhase;
                    this.tick = -1;
                    BeamFeature.this.emitterFeature.spawn(this.position.getX(), this.position.getY(), 0, 0, 0, 0);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        public void render() {
            switch (this.phase) {
                case 0: 
                case 1: {
                    return;
                }
                case 2: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"Shouldn't be rendering a zapping beam!");
                    }
                    return;
                }
                case 3: {
                    BeamFeature.this.colorSequenceResource.getColor(this.tick, tempColor);
                    this.endSprite.setColors(tempColor.getRed(), tempColor.getGreen(), tempColor.getBlue(), 255);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glLineWidth((float)(FPMath.floatValue((int)this.getRadius()) + 2.0f));
                    GL11.glBegin((int)1);
                    GL11.glColor4ub((byte)tempColor.getRedByte(), (byte)tempColor.getGreenByte(), (byte)tempColor.getBlueByte(), (byte)0);
                    GL11.glVertex2f((float)FPMath.floatValue((int)this.from.getPosition().getX()), (float)FPMath.floatValue((int)this.from.getPosition().getY()));
                    GL11.glColor4ub((byte)tempColor.getRedByte(), (byte)tempColor.getGreenByte(), (byte)tempColor.getBlueByte(), (byte)tempColor.getAlphaByte());
                    GL11.glVertex2f((float)FPMath.floatValue((int)this.position.getX()), (float)FPMath.floatValue((int)this.position.getY()));
                    GL11.glEnd();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        public void spawn() {
            this.endSprite = Game.allocateSprite(this);
            this.endSprite.setImage(BeamFeature.this.endSpriteImage);
            this.endSprite.setActive(false);
        }

        protected void tick() {
            switch (this.phase) {
                case 0: {
                    return;
                }
                case 1: {
                    if (!this.from.isAlive()) {
                        this.chargingSound.stop((Object)this);
                        this.remove();
                        return;
                    }
                    this.tick += Game.getOptions().getTicksPerFrame();
                    if (this.tick < BeamFeature.this.chargingTime) {
                        return;
                    }
                    this.setPhase(2);
                }
                case 2: {
                    this.doZap();
                }
                case 3: {
                    this.tick += Game.getOptions().getTicksPerFrame();
                    if (this.tick <= BeamFeature.this.colorSequenceResource.getDuration()) break;
                    this.remove();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private void doZap() {
            this.from.getPosition(this.position);
            int dx = this.position.getX() - this.target.getX();
            int dy = this.position.getY() - this.target.getY();
            int length = FPMath.sqrt((long)(FPMath.lmul((int)dx, (int)dx) + FPMath.lmul((int)dy, (int)dy)));
            BeamFeature.calculateProximity(this.position.getX() + this.target.getX() >> 1, this.position.getY() + this.target.getY() >> 1, length + this.getRadius(), proximal);
            int n = proximal.size();
            bresenham.plot(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), FPMath.intValue((int)this.target.getX()), FPMath.intValue((int)this.target.getY()));
            block0: while (bresenham.next() && this.tick < BeamFeature.this.range) {
                this.position.set(FPMath.fpValue((int)bresenham.getX()), FPMath.fpValue((int)bresenham.getY()), 0);
                if ((++this.tick & 3) != 0) continue;
                int j = 0;
                while (j < n) {
                    EntityFeature.EntityInstance ent = (EntityFeature.EntityInstance)proximal.get(j);
                    if (ent != this && ent.isTouching(this)) {
                        ent.inCollisionWith(this);
                        this.inCollisionWith(ent);
                        if (this.phase != 2) break block0;
                    }
                    ++j;
                }
            }
            this.endSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            if (this.phase == 2) {
                this.setPhase(3);
            }
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            return 0.0f;
        }
    }
}

