/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.ArrayList;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Emitter;
import xap.Entity;
import xap.FloatingLabel;
import xap.Game;
import xap.Player;
import xap.Powerup;
import xap.effects.LabelEffect;
import xap.features.EmitterFeature;
import xap.features.LivingEntityFeature;

public abstract class PowerupFeature
extends LivingEntityFeature {
    public static final long serialVersionUID = 1L;
    private static final ArrayList powerups = new ArrayList(12);
    private static final ArrayList availablePowerups = new ArrayList(12);
    private static final ArrayList availableGunPowerups = new ArrayList(12);
    private static int lastRandomPowerup = -1;
    private static int numImportantPowerups = 0;
    private String animation;
    private String shadowAnimation;
    private String powerupName;
    private String powerupNameFont;
    private String powerupNameColorSequence;
    private boolean available;
    private boolean important;
    private boolean registeredOnly;
    private boolean gun;
    private String beamInEmitter;
    private String collectEmitter;
    private transient Animation animationResource;
    private transient Animation shadowAnimationResource;
    private transient GLFont powerupNameFontResource;
    private transient ColorSequenceResource powerupNameColorSequenceResource;
    private transient EmitterFeature beamInEmitterResource;
    private transient EmitterFeature collectEmitterResource;

    protected PowerupFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.animation = XMLUtil.getString((Element)element, (String)"animation");
        this.shadowAnimation = XMLUtil.getString((Element)element, (String)"shadowanimation");
        this.powerupName = XMLUtil.getString((Element)element, (String)"powerupname");
        this.powerupNameFont = XMLUtil.getString((Element)element, (String)"powerupnamefont");
        this.powerupNameColorSequence = XMLUtil.getString((Element)element, (String)"powerupnamecolorsequence");
        this.available = XMLUtil.getBoolean((Element)element, (String)"available", (boolean)true);
        this.important = XMLUtil.getBoolean((Element)element, (String)"important", (boolean)true);
        this.beamInEmitter = XMLUtil.getString((Element)element, (String)"beaminemitter");
        this.collectEmitter = XMLUtil.getString((Element)element, (String)"collectemitter");
        this.gun = XMLUtil.getBoolean((Element)element, (String)"gun", (boolean)false);
        this.registeredOnly = XMLUtil.getBoolean((Element)element, (String)"registeredonly", (boolean)false);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.animationResource = (Animation)Resources.get((String)this.animation);
        this.shadowAnimationResource = (Animation)Resources.get((String)this.shadowAnimation);
        this.powerupNameFontResource = (GLFont)Resources.get((String)this.powerupNameFont);
        this.powerupNameColorSequenceResource = (ColorSequenceResource)Resources.get((String)this.powerupNameColorSequence);
        this.beamInEmitterResource = (EmitterFeature)Resources.get((String)this.beamInEmitter);
        this.collectEmitterResource = (EmitterFeature)Resources.get((String)this.collectEmitter);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.animationResource = null;
        this.shadowAnimationResource = null;
        this.powerupNameFontResource = null;
        this.powerupNameColorSequenceResource = null;
        this.beamInEmitterResource = null;
        this.collectEmitterResource = null;
    }

    public void register() {
        super.register();
        powerups.add(this);
        if (this.available) {
            availablePowerups.add(this);
        }
        if (this.gun) {
            availableGunPowerups.add(this);
        }
    }

    public void deregister() {
        super.deregister();
        powerups.remove(this);
        if (this.available) {
            availablePowerups.remove(this);
        }
        if (this.gun) {
            availableGunPowerups.remove(this);
        }
    }

    public static PowerupFeature getRandomPowerup() throws Exception {
        int nextPowerup = 0;
        PowerupFeature ret = null;
        do {
            int tries = 5;
            while (--tries > 0 && (nextPowerup = Util.random((int)0, (int)(availablePowerups.size() - 1))) == lastRandomPowerup) {
            }
            lastRandomPowerup = nextPowerup;
            ret = (PowerupFeature)availablePowerups.get(nextPowerup);
        } while (ret.registeredOnly && !Game.isRegistered());
        if (!ret.isCreated()) {
            ret.create();
        }
        return ret;
    }

    public static PowerupFeature getRandomGunPowerup() throws Exception {
        int nextPowerup = 0;
        int tries = 3;
        while (--tries > 0 && (nextPowerup = Util.random((int)0, (int)(availableGunPowerups.size() - 1))) == lastRandomPowerup) {
        }
        lastRandomPowerup = nextPowerup;
        PowerupFeature ret = (PowerupFeature)availableGunPowerups.get(nextPowerup);
        if (!ret.isCreated()) {
            ret.create();
        }
        return ret;
    }

    public static void test() throws Exception {
        int i = 0;
        while (i < powerups.size()) {
            PowerupFeature pf = (PowerupFeature)powerups.get(i);
            if (!pf.isCreated()) {
                pf.create();
            }
            pf.spawn();
            ++i;
        }
    }

    public static int getNumImportantPowerups() {
        return numImportantPowerups;
    }

    protected abstract class PowerupInstance
    extends LivingEntityFeature.LivingEntityInstance
    implements Powerup {
        private Emitter beamInEmitterInstance;
        private Emitter collectionEmitterInstance;
        private Sprite sprite;
        private Sprite shadowSprite;
        private FloatingLabel label;
        private boolean collected;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.features.PowerupFeature$PowerupInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        protected PowerupInstance() {
        }

        public final boolean isCollected() {
            return this.collected;
        }

        public final void inCollisionWith(Entity dest) {
            dest.inCollisionWithPowerup(this);
        }

        public final void inCollisionWithPlayer(Player player) {
            this.resOut();
            this.collected = true;
            this.doCollect(player);
        }

        protected abstract void doCollect(Player var1);

        protected final void doRemove() {
            this.removeSprites();
            if (this.label != null) {
                this.label.remove();
            }
            if (PowerupFeature.this.important) {
                numImportantPowerups = numImportantPowerups - 1;
            }
        }

        private void removeSprites() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
                this.shadowSprite.deallocate();
                this.shadowSprite = null;
            }
        }

        public final void displayName() {
            if (this.label != null) {
                this.label.reset();
            } else {
                this.label = LabelEffect.spawn(this.position.getX(), this.position.getY() + this.getRadius(), 0, 0, PowerupFeature.this.powerupNameFontResource, PowerupFeature.this.powerupNameColorSequenceResource, PowerupFeature.this.powerupName, false);
            }
        }

        public final float getRadarBlip(Color color, Vector3i pos) {
            color.set((byte)-1, (byte)-1, (byte)0);
            pos.set((ReadableVector3i)this.position);
            return 1.0f;
        }

        protected final void doAliveTick() {
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            if (this.label != null && !this.label.isVisible()) {
                this.label = null;
            }
        }

        protected final void doDyingTick() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        protected final void doResOut() {
            if (!this.collectionEmitterInstance.isActive()) {
                this.remove();
            }
        }

        protected final void doSpawnTick() {
            if (!this.beamInEmitterInstance.isActive()) {
                this.hatch();
            }
        }

        protected final void onBirth() {
            this.sprite = Game.allocateSprite(this);
            this.sprite.setAnimation(PowerupFeature.this.animationResource);
            this.shadowSprite = Game.allocateSprite(this);
            this.shadowSprite.setAnimation(PowerupFeature.this.shadowAnimationResource);
            this.shadowSprite.setLayer(-1);
        }

        protected final void onDeath() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        protected final void onResOut() {
            this.collectionEmitterInstance = PowerupFeature.this.collectEmitterResource.spawn(this.position.getX(), this.position.getY(), this.position.getZ(), 0, 0, 0);
            this.removeSprites();
        }

        public final void spawn() {
            this.randomLocation(this.position);
            this.beamInEmitterInstance = PowerupFeature.this.beamInEmitterResource.spawn(this.position.getX(), this.position.getY(), this.position.getZ(), 0, 0, 0);
            if (PowerupFeature.this.important) {
                numImportantPowerups = numImportantPowerups + 1;
            }
        }
    }
}

