/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.lwjgl.openal.AL10;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.BattleZone;
import xap.Bindings;
import xap.Blob;
import xap.Bullet;
import xap.Emitter;
import xap.Entity;
import xap.Game;
import xap.Gidrah;
import xap.Laser;
import xap.Player;
import xap.ProximityCounter;
import xap.Rocket;
import xap.ThrusterEmitter;
import xap.effects.BubbleAttackEffect;
import xap.effects.LabelEffect;
import xap.emitters.ThrusterEmitterFeature;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;
import xap.features.LaserFeature;
import xap.features.LivingEntityFeature;
import xap.features.RocketFeature;
import xap.features.SmartBombFeature;
import xap.features.full.OrbFeature;
import xap.gidrahs.GunnerFeature;
import xap.gui.Interface;

public class PlayerFeature
extends LivingEntityFeature {
    public static final long serialVersionUID = 1L;
    private static final Vector3i scratchVelocity;
    private static final Vector3i scratchVector;
    private static PlayerFeature feature;
    private static final Vector3i beaminTarget;
    private static final Vector3i lastKnownPosition;
    private static final ProximityCounter proximityCounter;
    private static int shieldHintCycle;
    private static int smartBombHintCycle;
    private static int controlHintCycle;
    private static final String[] SHIELD_HINTS;
    private static final String[] SMARTBOMB_HINTS;
    private static final String[] CONTROL_HINTS;
    private int shieldsRadius;
    private int shieldsRadiusSquared;
    private int defaultThrust;
    private int defaultDeceleration;
    private int defaultMaxSpeed;
    private String laser;
    private String explosionEmitter;
    private String beaminEmitter;
    private String thrusterEmitter;
    private String resOutEmitter;
    private String shieldsSoundEffect;
    private String invulnerabilitySoundEffect;
    private int maxOrbs;
    private int surplusPowerupBonus;
    private String surplusBonusFont;
    private String surplusBonusColorSequence;
    private String hintFont;
    private String hintColorSequence;
    private int respawnInvulnerability;
    private int autofireIncrease;
    private transient EmitterFeature explosionEmitterFeature;
    private transient EmitterFeature beaminEmitterFeature;
    private transient ThrusterEmitterFeature thrusterEmitterFeature;
    private transient EmitterFeature resOutEmitterFeature;
    private transient int lives;
    private transient int shields;
    private transient int smartBombs;
    private transient int homingRockets;
    private transient int spinningOrbs;
    private transient int laserDelay;
    private transient int smartBombDelay;
    private transient SpriteImage[] rotation;
    private transient SpriteImage[] shadowRotation;
    private transient Animation shieldAnimationResource;
    private transient Animation invulnerabilityAnimationResource;
    private transient GunnerFeature gunnerFeature;
    private transient int thrust;
    private transient int deceleration;
    private transient int maxSpeed;
    private transient int autofireReduction;
    private transient int laserPower = 0;
    private transient ALBuffer shieldsSoundEffectResource;
    private transient ALBuffer invulnerabilitySoundEffectResource;
    private transient EmitterFeature ricochetFeature;
    private transient GLFont surplusBonusFontResource;
    private transient ColorSequenceResource surplusBonusColorSequenceResource;
    private transient GLFont hintFontResource;
    private transient ColorSequenceResource hintColorSequenceResource;
    private static final int WAIT = 0;
    private static final int BEAMIN = 1;
    private static final int WAIT_DURATION = 60;
    private static final int NORMAL_SHIELD = 0;
    private static final int INVULN_SHIELD = 1;
    private transient PlayerInstance instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.PlayerFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        scratchVelocity = new Vector3i();
        scratchVector = new Vector3i();
        beaminTarget = new Vector3i();
        lastKnownPosition = new Vector3i();
        proximityCounter = new ProximityCounter();
        SHIELD_HINTS = new String[]{"Don't forget to use your SHIELDS!", "Having trouble with shields? Enable AUTO-SHIELDS in Controls!"};
        SMARTBOMB_HINTS = new String[]{"Don't forget to use your SMARTBOMBS!", "Having trouble with smartbombs? Enable AUTO-SMARTBOMBS in Controls!"};
        CONTROL_HINTS = new String[]{"Use your SHIELDS to fly safely through aliens!", "Having trouble flying? Adjust ACCELERATION and DECELERATION in Controls!", "Having trouble flying? Use the DIRECTIONAL THRUST keys instead of the crosshair!", "Having trouble with the controls? Change them in the Controls window to suit you!"};
    }

    public PlayerFeature(String name) {
        super(name);
    }

    public void onNewGame() throws Exception {
        super.onNewGame();
        Game.getGameMode().initialize(new Player.Initializer(){

            public void beginNewGame(int lives, int smartBombs) {
                PlayerFeature.this.lives = lives;
                PlayerFeature.this.smartBombs = smartBombs;
                PlayerFeature.this.homingRockets = 0;
                PlayerFeature.this.spinningOrbs = 0;
                PlayerFeature.this.autofireReduction = 0;
                PlayerFeature.this.laserPower = 0;
            }
        });
    }

    public void onNewLevel() throws Exception {
        super.onNewLevel();
        this.shields = Game.getGameMode().getInitialShields();
        beaminTarget.set(BattleZone.FPHEIGHT / 2, BattleZone.FPWIDTH / 2, 0);
        lastKnownPosition.set((ReadableVector3i)beaminTarget);
        this.respawn();
    }

    private void respawn() {
        if (Game.isGameOver()) {
            return;
        }
        this.instance = (PlayerInstance)this.spawn();
        try {
            Game.getGameMode().doPlayerSpawn();
        }
        catch (Exception e) {
            Game.handleException(e);
        }
    }

    public void onEndLevel() throws Exception {
        super.onEndLevel();
        this.instance.resOut();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.defaultMaxSpeed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"maxspeed"));
        this.defaultThrust = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"thrust"));
        this.defaultDeceleration = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"deceleration"));
        this.laser = XMLUtil.getString((Element)element, (String)"laser");
        this.explosionEmitter = XMLUtil.getString((Element)element, (String)"explosionemitter");
        this.beaminEmitter = XMLUtil.getString((Element)element, (String)"beaminemitter");
        this.thrusterEmitter = XMLUtil.getString((Element)element, (String)"thrusteremitter");
        this.resOutEmitter = XMLUtil.getString((Element)element, (String)"resoutemitter");
        this.shieldsRadius = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"shieldsradius"));
        this.shieldsRadiusSquared = FPMath.mul((int)this.shieldsRadius, (int)this.shieldsRadius);
        this.shieldsSoundEffect = XMLUtil.getString((Element)element, (String)"shieldssoundeffect");
        this.surplusPowerupBonus = XMLUtil.getInt((Element)element, (String)"surpluspowerupbonus");
        this.surplusBonusFont = XMLUtil.getString((Element)element, (String)"surplusbonusfont");
        this.surplusBonusColorSequence = XMLUtil.getString((Element)element, (String)"surplusbonuscolorsequence");
        this.maxOrbs = XMLUtil.getInt((Element)element, (String)"maxorbs");
        this.respawnInvulnerability = XMLUtil.getInt((Element)element, (String)"respawninvulnerability");
        this.invulnerabilitySoundEffect = XMLUtil.getString((Element)element, (String)"invulnerabilitysoundeffect");
        this.autofireIncrease = XMLUtil.getInt((Element)element, (String)"autofireincrease");
        this.hintFont = XMLUtil.getString((Element)element, (String)"hintfont");
        this.hintColorSequence = XMLUtil.getString((Element)element, (String)"hintcolorsequence");
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && feature != null) {
            throw new AssertionError();
        }
        feature = this;
    }

    public void deregister() {
        super.deregister();
        feature = null;
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.explosionEmitterFeature = (EmitterFeature)Resources.get((String)this.explosionEmitter);
        this.beaminEmitterFeature = (EmitterFeature)Resources.get((String)this.beaminEmitter);
        this.thrusterEmitterFeature = (ThrusterEmitterFeature)Resources.get((String)this.thrusterEmitter);
        this.resOutEmitterFeature = (EmitterFeature)Resources.get((String)this.resOutEmitter);
        if (Game.hasSound()) {
            this.shieldsSoundEffectResource = (ALBuffer)Resources.get((String)this.shieldsSoundEffect);
        }
        this.invulnerabilitySoundEffectResource = (ALBuffer)Resources.get((String)this.invulnerabilitySoundEffect);
        this.rotation = new SpriteImage[32];
        int i = 0;
        while (i < 32) {
            this.rotation[i] = i < 10 ? (SpriteImage)Resources.get((String)("spriteimage.player000" + i)) : (SpriteImage)Resources.get((String)("spriteimage.player00" + i));
            ++i;
        }
        this.shadowRotation = new SpriteImage[32];
        i = 0;
        while (i < 32) {
            this.shadowRotation[i] = i < 10 ? (SpriteImage)Resources.get((String)("spriteimage.player_shadow000" + i)) : (SpriteImage)Resources.get((String)("spriteimage.player_shadow00" + i));
            ++i;
        }
        this.shieldAnimationResource = (Animation)Resources.get((String)"shield.animation");
        this.invulnerabilityAnimationResource = (Animation)Resources.get((String)"shield_invulnerability.animation");
        this.gunnerFeature = (GunnerFeature)Resources.get((String)"gidrah_gunner");
        this.ricochetFeature = (EmitterFeature)Resources.get((String)"ricochet.emitter");
        this.surplusBonusColorSequenceResource = (ColorSequenceResource)Resources.get((String)this.surplusBonusColorSequence);
        this.surplusBonusFontResource = (GLFont)Resources.get((String)this.surplusBonusFont);
        this.hintFontResource = (GLFont)Resources.get((String)this.hintFont);
        this.hintColorSequenceResource = (ColorSequenceResource)Resources.get((String)this.hintColorSequence);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.explosionEmitterFeature = null;
        this.beaminEmitterFeature = null;
        this.thrusterEmitterFeature = null;
        this.resOutEmitterFeature = null;
        this.shieldsSoundEffectResource = null;
        this.invulnerabilitySoundEffectResource = null;
        this.rotation = null;
        this.shadowRotation = null;
        this.shieldAnimationResource = null;
        this.invulnerabilityAnimationResource = null;
        this.gunnerFeature = null;
        this.ricochetFeature = null;
        this.surplusBonusColorSequenceResource = null;
        this.surplusBonusFontResource = null;
        this.hintFontResource = null;
        this.hintColorSequence = null;
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new PlayerInstance();
    }

    public static void displayStats(Player.StatsDisplay display) {
        display.setLives(PlayerFeature.feature.lives);
        display.setSmartBombs(PlayerFeature.feature.smartBombs);
        display.setShields(PlayerFeature.feature.shields, Game.getGameMode().getInitialShields());
    }

    public static Player getPlayer() {
        return PlayerFeature.feature.instance;
    }

    private final class PlayerInstance
    extends LivingEntityFeature.LivingEntityInstance
    implements Player,
    Player.Collider {
        private final Vector3i velocity = new Vector3i();
        private final Vector3i laserTarget = new Vector3i();
        private Emitter beamInEmitterInstance;
        private Emitter explosionEmitterInstance;
        private ThrusterEmitter thrusterEmitterInstance1;
        private ThrusterEmitter thrusterEmitterInstance2;
        private final Vector3i target = new Vector3i();
        private boolean shieldsUp;
        private LaserFeature laserInstance;
        private Sprite sprite;
        private Sprite shadowSprite;
        private Sprite shieldSprite;
        private boolean fireLaser;
        private int tick;
        private int phase;
        private boolean strayWarningDone;
        private boolean fireSmartBomb;
        private SoundEffect shieldsSoundEffectInstance;
        private SoundEffect invulnerabilitySoundEffectInstance;
        private boolean invulnerable;
        private int powerupInvulnerability = 0;
        private int invisible = 0;
        private int shieldType = 0;
        private int autoShieldDelay = 0;
        int waiter = 0;
        boolean dontDecelerate = false;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.features.PlayerFeature$PlayerInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        PlayerInstance() {
            PlayerFeature.this.thrust = PlayerFeature.this.defaultThrust;
            PlayerFeature.this.deceleration = PlayerFeature.this.defaultDeceleration;
            PlayerFeature.this.maxSpeed = PlayerFeature.this.defaultMaxSpeed;
        }

        protected void onBirth() {
            this.position.set((ReadableVector3i)beaminTarget);
            this.sprite = Game.allocateSprite(this);
            this.shadowSprite = Game.allocateSprite(this);
            this.shadowSprite.setLayer(-2);
            this.shieldSprite = Game.allocateSprite(this);
            this.shieldSprite.setActive(false);
            this.shadowSprite.setScale(FPMath.TWO);
            this.thrusterEmitterInstance1 = (ThrusterEmitter)PlayerFeature.this.thrusterEmitterFeature.spawn(this.position.getX(), this.position.getY(), 0, 0, 0, 0);
            this.thrusterEmitterInstance2 = (ThrusterEmitter)PlayerFeature.this.thrusterEmitterFeature.spawn(this.position.getX(), this.position.getY(), 0, 0, 0, 0);
            try {
                this.laserInstance = (LaserFeature)Resources.get((String)(String.valueOf(PlayerFeature.this.laser) + PlayerFeature.this.laserPower));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                int i = 0;
                while (i < PlayerFeature.this.spinningOrbs) {
                    OrbFeature.getOrbFeature().spawn();
                    ++i;
                }
            }
            catch (Exception e) {
                Game.handleException(e);
            }
            this.tick = PlayerFeature.this.respawnInvulnerability;
            this.invulnerable = true;
        }

        protected void onDeath() {
            int yy;
            int xx;
            Vector3i adjust;
            this.sprite.deallocate();
            this.sprite = null;
            this.shadowSprite.deallocate();
            this.shadowSprite = null;
            this.shieldSprite.deallocate();
            this.shieldSprite = null;
            this.stopThrusters();
            if (this.thrusterEmitterInstance1 != null) {
                this.thrusterEmitterInstance1.remove();
            }
            if (this.thrusterEmitterInstance2 != null) {
                this.thrusterEmitterInstance2.remove();
            }
            this.thrusterEmitterInstance1 = null;
            this.thrusterEmitterInstance2 = null;
            if (PlayerFeature.this.laserPower > 0) {
                this.powerdownLaser();
            } else if (PlayerFeature.this.autofireReduction > 0) {
                this.powerdownAutofire();
            }
            this.powerdownShield();
            this.removeSpinningOrb();
            this.explosionEmitterInstance = PlayerFeature.this.explosionEmitterFeature.spawn(this.position.getX(), this.position.getY(), this.position.getZ(), 0, 0, 0);
            Game.shake(60, 20);
            Game.getGameMode().getScore().incLives();
            String hint = null;
            if (Game.getCurrentLevel() < 5) {
                if ((float)PlayerFeature.this.shields > (float)Game.getGameMode().getInitialShields() * 0.9f) {
                    String[] stringArray = SHIELD_HINTS;
                    int n = shieldHintCycle;
                    shieldHintCycle = n + 1;
                    hint = stringArray[n];
                    shieldHintCycle = shieldHintCycle % SHIELD_HINTS.length;
                } else if (PlayerFeature.this.smartBombs > PlayerFeature.this.lives) {
                    String[] stringArray = SMARTBOMB_HINTS;
                    int n = smartBombHintCycle;
                    smartBombHintCycle = n + 1;
                    hint = stringArray[n];
                    smartBombHintCycle = smartBombHintCycle % SMARTBOMB_HINTS.length;
                } else {
                    String[] stringArray = CONTROL_HINTS;
                    int n = controlHintCycle;
                    controlHintCycle = n + 1;
                    hint = stringArray[n];
                    controlHintCycle = controlHintCycle % CONTROL_HINTS.length;
                }
            }
            if ((adjust = new Vector3i(xx = this.position.getX() - (BattleZone.FPWIDTH >> 1), yy = this.position.getY() - (BattleZone.FPHEIGHT >> 1), 0)).length() > BattleZone.FPWIDTH) {
                adjust.scale(FPMath.div((int)BattleZone.FPWIDTH, (int)adjust.length()));
                beaminTarget.set((BattleZone.FPWIDTH >> 1) + adjust.getX(), (BattleZone.FPHEIGHT >> 1) + adjust.getY(), 0);
            } else {
                beaminTarget.set((ReadableVector3i)this.position);
            }
            if (hint != null) {
                LabelEffect.spawn(FPMath.fpValue((int)400), 0, 0, FPMath.TWO << Game.getOptions().getSpeedShift(), PlayerFeature.this.hintFontResource, PlayerFeature.this.hintColorSequenceResource, hint, true);
            }
            try {
                Game.getGameMode().doPlayerDeath();
            }
            catch (Exception e) {
                Game.handleException(e);
            }
        }

        protected void onResOut() {
            this.setShields(false);
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
            if (this.shadowSprite != null) {
                this.shadowSprite.deallocate();
                this.shadowSprite = null;
            }
            if (this.shieldSprite != null) {
                this.shieldSprite.deallocate();
                this.shieldSprite = null;
            }
            this.stopThrusters();
            this.tick = 0;
            PlayerFeature.this.resOutEmitterFeature.spawn(this.position.getX(), this.position.getY(), 0, 0, 0, 0);
        }

        protected void doSpawnTick() {
            ++this.tick;
            switch (this.phase) {
                case 0: {
                    if (this.tick < 60) {
                        return;
                    }
                    this.phase = 1;
                    this.tick = 0;
                    this.beamInEmitterInstance = PlayerFeature.this.beaminEmitterFeature.spawn(beaminTarget.getX(), beaminTarget.getY(), 0, 0, 0, 0);
                }
                case 1: {
                    this.beamInEmitterInstance.setPosition(beaminTarget.getX(), beaminTarget.getY(), 0);
                    if (this.beamInEmitterInstance.isActive()) {
                        return;
                    }
                    this.tick = 0;
                    this.hatch();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        protected void doAliveTick() {
            scratchVector.set(BattleZone.FPWIDTH >> 1, BattleZone.FPHEIGHT >> 1, 0);
            Vector3i.sub((ReadableVector3i)scratchVector, (ReadableVector3i)this.position, (WritableVector3i)scratchVector);
            if (scratchVector.lengthSquared() > FPMath.lmul((int)BattleZone.FPWIDTH, (int)BattleZone.FPWIDTH)) {
                if (!this.strayWarningDone) {
                    LabelEffect.spawn(FPMath.fpValue((int)400), 0, 0, FPMath.TWO << Game.getOptions().getSpeedShift(), PlayerFeature.this.hintFontResource, PlayerFeature.this.hintColorSequenceResource, "Don't stray too far from the Fluffies!", true);
                    this.strayWarningDone = true;
                }
                if (scratchVector.lengthSquared() > FPMath.lmul((int)(BattleZone.FPWIDTH * 2), (int)(BattleZone.FPWIDTH * 2))) {
                    if (this.waiter > 0) {
                        --this.waiter;
                    } else {
                        PlayerFeature.this.gunnerFeature.spawn();
                        this.waiter = 60 >> Game.getOptions().getSpeedShift();
                    }
                    this.accelerate(BattleZone.FPWIDTH >> 1, BattleZone.FPWIDTH >> 1, 2.0f * FPMath.floatValue((int)(PlayerFeature.this.thrust << Game.getOptions().getSpeedShift())));
                }
            }
            this.position.translate(this.velocity.getX(), this.velocity.getY(), 0);
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            Vector3i.sub((ReadableVector3i)this.target, (ReadableVector3i)this.position, (WritableVector3i)scratchVector);
            double angle = Math.atan2(scratchVector.getY(), scratchVector.getX());
            int spriteAngle = (int)((double)PlayerFeature.this.rotation.length * angle / (Math.PI * 2));
            spriteAngle += 40;
            this.sprite.setImage(PlayerFeature.this.rotation[spriteAngle %= 32]);
            this.shadowSprite.setImage(PlayerFeature.this.shadowRotation[spriteAngle]);
            if (this.invulnerable) {
                --this.tick;
                if (this.tick == 0) {
                    this.invulnerable = false;
                    this.sprite.setVisible(true);
                    this.shadowSprite.setVisible(true);
                } else {
                    this.sprite.setVisible((this.tick & 4) == 4);
                    this.shadowSprite.setVisible((this.tick & 4) == 4);
                }
            }
            if (Game.hasSound()) {
                AL10.alListener3f((int)4100, (float)FPMath.floatValue((int)this.position.getX()), (float)FPMath.floatValue((int)this.position.getY()), (float)0.0f);
                AL10.alListener3f((int)4102, (float)FPMath.floatValue((int)this.velocity.getX()), (float)FPMath.floatValue((int)this.velocity.getY()), (float)0.0f);
            }
            if (this.fireLaser) {
                if (PlayerFeature.this.laserDelay > 0) {
                    PlayerFeature playerFeature = PlayerFeature.this;
                    playerFeature.laserDelay = playerFeature.laserDelay - 1;
                } else {
                    this.doFireLaser();
                }
                this.fireLaser = false;
            } else {
                PlayerFeature.this.laserDelay = 0;
            }
            if (Game.getGameMode().isUsingAutoShield()) {
                boolean override = Bindings.isShieldsDown() && !Interface.isConsoleVisible();
                proximityCounter.reset();
                proximityCounter.calculate(this.position.getX(), this.position.getY(), FPMath.fpValue((int)120));
                if (override) {
                    this.setShields(true);
                    this.autoShieldDelay = 30;
                } else if (proximityCounter.bullets > 0 || proximityCounter.gidrahs > 0) {
                    this.autoShieldDelay = this.autoShieldDelay < 8 ? (this.autoShieldDelay += Game.getOptions().getTicksPerFrame()) : 30;
                    this.setShields(this.autoShieldDelay >= 8);
                } else if (this.autoShieldDelay >= 0) {
                    this.autoShieldDelay -= Game.getOptions().getTicksPerFrame();
                } else {
                    this.setShields(false);
                }
            } else {
                this.setShields(Bindings.isShieldsDown() && !Interface.isConsoleVisible());
            }
            if (Bindings.isSmartbombDown() && !Interface.isConsoleVisible()) {
                this.fireSmartBomb = true;
            } else if (!this.fireSmartBomb && Game.getGameMode().isUsingAutoSmartbomb() && PlayerFeature.this.smartBombDelay == 0 && PlayerFeature.this.smartBombs > 0) {
                proximityCounter.reset();
                proximityCounter.calculate(this.position.getX(), this.position.getY(), SmartBombFeature.getSmartBombRadius());
                if (proximityCounter.gidrahs >= 14) {
                    this.fireSmartBomb = true;
                }
            }
            if (PlayerFeature.this.smartBombDelay > 0) {
                PlayerFeature playerFeature = PlayerFeature.this;
                playerFeature.smartBombDelay = playerFeature.smartBombDelay - 1;
            }
            if (this.fireSmartBomb) {
                if (PlayerFeature.this.smartBombDelay == 0) {
                    this.doFireSmartBomb();
                }
                this.fireSmartBomb = false;
            }
            Game.getGameMode().getScore().incTime(Game.getOptions().getTicksPerFrame());
            if (this.shieldsUp || this.powerupInvulnerability > 0) {
                this.shieldSprite.setLocation(this.sprite.getX(), this.sprite.getY(), 0);
            }
            if (this.invisible > 0) {
                this.invisible -= Game.getOptions().getTicksPerFrame();
                if (this.invisible > 0) {
                    if (this.invisible < 60) {
                        this.sprite.setAlpha((this.invisible & 4) == 4 ? 255 : 32);
                    } else {
                        this.sprite.setAlpha(32);
                    }
                } else {
                    this.sprite.setAlpha(255);
                    lastKnownPosition.set((ReadableVector3i)this.position);
                }
            } else {
                lastKnownPosition.set((ReadableVector3i)this.position);
            }
            beaminTarget.set((ReadableVector3i)this.position);
            this.dontDecelerate = false;
        }

        protected void doDyingTick() {
            if (!this.explosionEmitterInstance.isActive()) {
                this.remove();
                PlayerFeature playerFeature = PlayerFeature.this;
                playerFeature.lives = playerFeature.lives - 1;
                if (PlayerFeature.this.lives == 0) {
                    if (!Game.isGameOver()) {
                        Game.gameOver();
                    }
                } else {
                    PlayerFeature.this.respawn();
                }
            } else {
                this.position.translate(this.velocity.getX(), this.velocity.getY(), 0);
                lastKnownPosition.set((ReadableVector3i)this.position);
            }
        }

        public boolean isMoving() {
            return this.isAlive() && this.velocity.lengthSquared() > 0L;
        }

        public void spawn() {
            this.position.set((ReadableVector3i)lastKnownPosition);
            this.waiter = 60 >> Game.getOptions().getSpeedShift();
            PlayerFeature.this.shields = Game.getGameMode().getInitialShields();
        }

        protected void doRemove() {
            this.powerupInvulnerability = 0;
            this.setShields(false);
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
            if (this.shadowSprite != null) {
                this.shadowSprite.deallocate();
                this.shadowSprite = null;
            }
            if (this.shieldSprite != null) {
                this.shieldSprite.deallocate();
                this.shieldSprite = null;
            }
        }

        public void setBeamInTarget(int x, int y) {
            beaminTarget.set(x, y, 0);
            this.position.set(x, y, 0);
        }

        public Vector3i getBeamInTarget() {
            return beaminTarget;
        }

        public void accelerate(int x, int y, float force) {
            if (!this.isAlive()) {
                return;
            }
            scratchVelocity.set(x, y, 0);
            Vector3i.sub((ReadableVector3i)scratchVelocity, (ReadableVector3i)this.position, (WritableVector3i)scratchVelocity);
            scratchVelocity.normalize();
            scratchVelocity.scale(FPMath.fpValue((float)force) << Game.getOptions().getSpeedShift());
            Vector3i.add((ReadableVector3i)this.velocity, (ReadableVector3i)scratchVelocity, (WritableVector3i)this.velocity);
            this.dontDecelerate = true;
        }

        public void accelerate(int x, int y) {
            scratchVelocity.set(x - this.position.getX(), y - this.position.getY(), 0);
            if (scratchVelocity.getX() != 0 || scratchVelocity.getY() != 0) {
                scratchVelocity.normalize();
                scratchVelocity.scale(FPMath.mul((int)PlayerFeature.this.thrust, (int)Bindings.getAcceleration()) << Game.getOptions().getSpeedShift());
            }
            Vector3i.add((ReadableVector3i)this.velocity, (ReadableVector3i)scratchVelocity, (WritableVector3i)this.velocity);
            int maxSpeed2 = PlayerFeature.this.maxSpeed << Game.getOptions().getSpeedShift();
            if (this.velocity.lengthSquared() > (long)FPMath.mul((int)maxSpeed2, (int)maxSpeed2)) {
                this.velocity.normalize();
                this.velocity.scale(maxSpeed2);
            }
            Vector3i.sub((ReadableVector3i)this.target, (ReadableVector3i)this.position, (WritableVector3i)scratchVector);
            double angle = Math.atan2(scratchVector.getY(), -scratchVector.getX());
            this.thrusterEmitterInstance1.setThrustOn(true);
            this.thrusterEmitterInstance2.setThrustOn(true);
            int fpAngle = FPMath.fpYaklyDegrees((double)angle);
            this.thrusterEmitterInstance1.setPosition(this.position.getX() + 12 * FPMath.cos((int)(fpAngle + 16384)), this.position.getY() + 12 * FPMath.sin((int)(fpAngle + 16384)), 0);
            this.thrusterEmitterInstance2.setPosition(this.position.getX() + 12 * FPMath.cos((int)(fpAngle - 16384)), this.position.getY() + 12 * FPMath.sin((int)(fpAngle - 16384)), 0);
            this.thrusterEmitterInstance1.setAngle(fpAngle);
            this.thrusterEmitterInstance2.setAngle(fpAngle);
        }

        public void decelerate() {
            int deceleration2 = FPMath.mul((int)PlayerFeature.this.deceleration, (int)Bindings.getDeceleration()) << Game.getOptions().getSpeedShift();
            this.stopThrusters();
            if (this.dontDecelerate) {
                return;
            }
            if (this.velocity.getX() == 0 && this.velocity.getY() == 0 && this.velocity.getZ() == 0) {
                return;
            }
            int currentVelocity = this.velocity.length();
            if (currentVelocity <= deceleration2) {
                this.velocity.set(0, 0, 0);
            } else {
                int newVelocity = Math.max(0, currentVelocity - deceleration2);
                this.velocity.scale(FPMath.div((int)newVelocity, (int)currentVelocity));
            }
        }

        private void stopThrusters() {
            if (this.thrusterEmitterInstance1 != null) {
                this.thrusterEmitterInstance1.setThrustOn(false);
            }
            if (this.thrusterEmitterInstance2 != null) {
                this.thrusterEmitterInstance2.setThrustOn(false);
            }
        }

        public void setShields(boolean on) {
            if (this.powerupInvulnerability > 0) {
                on = true;
            }
            if (on) {
                if (this.powerupInvulnerability > 0) {
                    this.powerupInvulnerability -= Game.getOptions().getTicksPerFrame();
                    if (this.powerupInvulnerability <= 0) {
                        this.setShields(false);
                        return;
                    }
                    if (!this.shieldsUp || this.shieldType == 0) {
                        this.shieldType = 1;
                        this.shieldSprite.setActive(true);
                        this.shadowSprite.setActive(false);
                        this.shieldSprite.setVisible(true);
                        this.shieldSprite.setAnimation(PlayerFeature.this.invulnerabilityAnimationResource);
                        this.shieldSprite.setLayer(1);
                        this.shieldsUp = true;
                        if (this.shieldsSoundEffectInstance != null) {
                            this.shieldsSoundEffectInstance.setFade(10, 0.0f, true, (Object)this);
                            this.shieldsSoundEffectInstance = null;
                        }
                        this.invulnerabilitySoundEffectInstance = Game.allocateBackgroundSound(PlayerFeature.this.invulnerabilitySoundEffectResource, this);
                        if (this.invulnerabilitySoundEffectInstance != null) {
                            this.invulnerabilitySoundEffectInstance.setLooped(true, (Object)this);
                        }
                    }
                    if (this.powerupInvulnerability < 60) {
                        this.shieldSprite.setVisible((this.powerupInvulnerability & 4) == 0);
                        if (this.invulnerabilitySoundEffectInstance != null) {
                            this.invulnerabilitySoundEffectInstance.setPitch(LinearInterpolator.instance.interpolate(0.2f, PlayerFeature.this.invulnerabilitySoundEffectResource.getPitch(), (float)this.powerupInvulnerability / 60.0f), (Object)this);
                        }
                    }
                } else {
                    PlayerFeature playerFeature = PlayerFeature.this;
                    playerFeature.shields = playerFeature.shields - Game.getOptions().getTicksPerFrame();
                    if (PlayerFeature.this.shields <= 0) {
                        this.setShields(false);
                        return;
                    }
                    if (!this.shieldsUp || this.shieldType == 1) {
                        this.shieldType = 0;
                        this.shieldSprite.setActive(true);
                        this.shadowSprite.setActive(false);
                        this.shieldSprite.setVisible(true);
                        this.shieldSprite.setAnimation(PlayerFeature.this.shieldAnimationResource);
                        this.shieldSprite.setLayer(1);
                        this.shieldsUp = true;
                        this.shieldsSoundEffectInstance = Game.allocateBackgroundSound(PlayerFeature.this.shieldsSoundEffectResource, this);
                        if (this.shieldsSoundEffectInstance != null) {
                            this.shieldsSoundEffectInstance.setLooped(true, (Object)this);
                        }
                    }
                }
                Game.getGameMode().getScore().incShields(Game.getOptions().getSpeedShift());
            } else if (this.shieldsUp) {
                this.shieldsUp = false;
                if (this.shieldSprite != null) {
                    this.shieldSprite.setActive(false);
                }
                if (this.shadowSprite != null) {
                    this.shadowSprite.setActive(true);
                }
                if (this.invulnerabilitySoundEffectInstance != null) {
                    this.invulnerabilitySoundEffectInstance.stop((Object)this);
                    this.invulnerabilitySoundEffectInstance = null;
                }
                if (this.shieldsSoundEffectInstance != null) {
                    this.shieldsSoundEffectInstance.stop((Object)this);
                    this.shieldsSoundEffectInstance = null;
                }
            }
        }

        public void fireLaser(Vector3i target) {
            this.fireLaser = true;
            this.laserTarget.set((ReadableVector3i)target);
        }

        private void doFireLaser() {
            Laser newLaser = (Laser)this.laserInstance.spawn();
            if (newLaser != null) {
                Game.getGameMode().getScore().incShots();
                newLaser.fireAt(this.position, this.laserTarget);
                PlayerFeature.this.laserDelay = this.laserInstance.getAutofireDelay() - PlayerFeature.this.autofireReduction * PlayerFeature.this.autofireIncrease >> Game.getOptions().getSpeedShift();
            }
            this.fireLaser = false;
        }

        private void doFireSmartBomb() {
            if (PlayerFeature.this.smartBombs > 0) {
                PlayerFeature playerFeature = PlayerFeature.this;
                playerFeature.smartBombs = playerFeature.smartBombs - 1;
                PlayerFeature.this.smartBombDelay = 60 >> Game.getOptions().getSpeedShift();
                try {
                    SmartBombFeature.fire();
                    Game.getGameMode().getScore().incSmarts();
                }
                catch (Exception e) {
                    Game.handleException(e);
                }
            }
            this.fireSmartBomb = false;
        }

        public void addLives(int moreLives) {
            PlayerFeature playerFeature = PlayerFeature.this;
            playerFeature.lives = playerFeature.lives + moreLives;
        }

        public void addSmartBombs(int bombs) {
            PlayerFeature playerFeature = PlayerFeature.this;
            playerFeature.smartBombs = playerFeature.smartBombs + bombs;
        }

        public void inCollisionWith(Entity dest) {
            dest.inCollisionWithPlayer(this);
        }

        public void inCollisionWithBullet(Bullet bullet) {
            Game.getGameMode().handleCollision((Player.Collider)this, bullet);
        }

        public void inCollisionWithGidrah(Gidrah gidrah) {
            Game.getGameMode().handleCollision((Player.Collider)this, gidrah);
        }

        public boolean isShieldUp() {
            return this.shieldsUp;
        }

        public void endLevel() {
            if (this.isAlive()) {
                this.resOut();
            }
        }

        public void fireSmartBomb() {
            this.fireSmartBomb = true;
        }

        public void setTarget(int x, int y) {
            this.target.set(x, y, 0);
        }

        public void powerdownAutofire() {
            if (PlayerFeature.this.autofireReduction > 0) {
                PlayerFeature playerFeature = PlayerFeature.this;
                playerFeature.autofireReduction = playerFeature.autofireReduction - 1;
            }
        }

        public void powerdownLaser() {
            if (PlayerFeature.this.laserPower > 0) {
                PlayerFeature playerFeature = PlayerFeature.this;
                playerFeature.laserPower = playerFeature.laserPower - 1;
                try {
                    this.laserInstance = (LaserFeature)Resources.get((String)("player.laser" + PlayerFeature.this.laserPower));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void powerdownShield() {
        }

        public void powerupAutofire() {
            if (PlayerFeature.this.autofireReduction < 2) {
                PlayerFeature playerFeature = PlayerFeature.this;
                playerFeature.autofireReduction = playerFeature.autofireReduction + 1;
            } else {
                this.awardBonus(PlayerFeature.this.surplusPowerupBonus);
            }
        }

        public void powerupLaser() {
            if (PlayerFeature.this.laserPower < 2) {
                PlayerFeature playerFeature = PlayerFeature.this;
                playerFeature.laserPower = playerFeature.laserPower + 1;
                try {
                    this.laserInstance = (LaserFeature)Resources.get((String)("player.laser" + PlayerFeature.this.laserPower));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.awardBonus(PlayerFeature.this.surplusPowerupBonus);
            }
        }

        public void powerupShield() {
            PlayerFeature.this.shields = Game.getGameMode().getInitialShields();
        }

        protected void doResOut() {
        }

        public int getRadius() {
            if (this.shieldsUp || this.powerupInvulnerability > 0) {
                return PlayerFeature.this.shieldsRadius;
            }
            return super.getRadius();
        }

        public int getRadiusSquared() {
            if (this.shieldsUp || this.powerupInvulnerability > 0) {
                return PlayerFeature.this.shieldsRadiusSquared;
            }
            return super.getRadiusSquared();
        }

        public void addHomingRockets(int rockets) {
            PlayerFeature playerFeature = PlayerFeature.this;
            playerFeature.homingRockets = playerFeature.homingRockets + rockets;
        }

        public boolean addSpinningOrb() {
            if (PlayerFeature.this.spinningOrbs < PlayerFeature.this.maxOrbs) {
                PlayerFeature playerFeature = PlayerFeature.this;
                playerFeature.spinningOrbs = playerFeature.spinningOrbs + 1;
                return true;
            }
            this.awardBonus(PlayerFeature.this.surplusPowerupBonus);
            return false;
        }

        public void removeSpinningOrb() {
            if (PlayerFeature.this.spinningOrbs > 0) {
                PlayerFeature playerFeature = PlayerFeature.this;
                playerFeature.spinningOrbs = playerFeature.spinningOrbs - 1;
            }
        }

        public void awardBonus(int bonus) {
            Game.getGameMode().addScore(bonus);
            LabelEffect.spawn(this.position.getX(), this.position.getY(), 0, FPMath.fpValue((float)0.5f), PlayerFeature.this.surplusBonusFontResource, PlayerFeature.this.surplusBonusColorSequenceResource, String.valueOf(bonus), false);
        }

        public void tooManyBlobs() {
            this.awardBonus(PlayerFeature.this.surplusPowerupBonus);
        }

        public void notifyAttack(Blob blob) {
            BubbleAttackEffect.spawn(blob);
            if (!this.isAlive()) {
                return;
            }
            if (PlayerFeature.this.homingRockets > 0) {
                PlayerFeature playerFeature = PlayerFeature.this;
                playerFeature.homingRockets = playerFeature.homingRockets - 1;
                try {
                    Rocket rocket = (Rocket)RocketFeature.getRocketFeature().spawn();
                    rocket.fireAt(blob);
                }
                catch (Exception e) {
                    Game.handleException(e);
                }
            }
        }

        public boolean isShieldEmpty() {
            return PlayerFeature.this.shields <= 60;
        }

        public void invisible(int ticks) {
            this.invisible += ticks;
        }

        public void invulnerable(int ticks) {
            this.powerupInvulnerability += ticks;
        }

        public Vector3i getLastKnownPosition() {
            return lastKnownPosition;
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            color.set((byte)-1, (byte)-1, (byte)-1);
            pos.set((ReadableVector3i)this.position);
            return 1.0f;
        }

        public boolean isPathetic() {
            if (PlayerFeature.this.laserPower == 0 && PlayerFeature.this.autofireReduction == 0) {
                return true;
            }
            return (PlayerFeature.this.laserPower == 0 || PlayerFeature.this.autofireReduction == 0) && Game.getGameMode().isDifficult();
        }

        public boolean isInvulnerable() {
            return this.invulnerable || this.powerupInvulnerability > 0;
        }

        public void useShields(int points) {
            if (!$assertionsDisabled && points <= 0) {
                throw new AssertionError();
            }
            PlayerFeature.this.shields = Math.max(0, PlayerFeature.this.shields - points);
        }

        public void spawnRicochet() {
            PlayerFeature.this.ricochetFeature.spawn(this.position.getX(), this.position.getY(), 0, this.velocity.getX(), this.velocity.getY(), 0);
        }
    }
}

