/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import xap.LivingEntity;
import xap.features.EntityFeature;

public abstract class LivingEntityFeature
extends EntityFeature {
    public static final long serialVersionUID = 1L;
    private static final int SPAWNING = 0;
    private static final int ALIVE = 1;
    private static final int DYING = 2;
    private static final int RESOUT = 3;

    public LivingEntityFeature(String name) {
        super(name);
    }

    protected abstract class LivingEntityInstance
    extends EntityFeature.EntityInstance
    implements LivingEntity {
        private transient int state;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.features.LivingEntityFeature$LivingEntityInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        protected LivingEntityInstance() {
        }

        private final void setState(int newState) {
            block11: {
                block10: {
                    if (newState == this.state) break block10;
                    switch (newState) {
                        case 1: {
                            if (!$assertionsDisabled && this.state != 0) {
                                throw new AssertionError((Object)"Invalid state change");
                            }
                            this.state = 1;
                            this.onBirth();
                            this.tick();
                            break block11;
                        }
                        case 2: {
                            if (!$assertionsDisabled && this.state != 1) {
                                throw new AssertionError((Object)"Invalid state change");
                            }
                            this.state = 2;
                            this.onDeath();
                            this.tick();
                            break block11;
                        }
                        case 3: {
                            if (!$assertionsDisabled && this.state != 1) {
                                throw new AssertionError((Object)"Invalid state change");
                            }
                            this.state = 3;
                            this.onResOut();
                            this.tick();
                            break block11;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)"Illegal living entity state.");
                            }
                            break block11;
                        }
                    }
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Illegal state change");
                }
            }
        }

        public final void hatch() {
            this.setState(1);
        }

        public final void kill() {
            this.setState(2);
        }

        public final void resOut() {
            this.setState(3);
        }

        public final boolean isAlive() {
            return this.state == 1;
        }

        public final boolean isSpawning() {
            return this.state == 0;
        }

        public final boolean isDying() {
            return this.state == 2;
        }

        public final boolean isRezzingOut() {
            return this.state == 3;
        }

        protected abstract void onBirth();

        protected abstract void onDeath();

        protected abstract void onResOut();

        public boolean canCollide() {
            return this.isAlive();
        }

        public final void tick() {
            int currentState;
            do {
                currentState = this.state;
                switch (currentState) {
                    case 0: {
                        this.doSpawnTick();
                        break;
                    }
                    case 1: {
                        this.doAliveTick();
                        break;
                    }
                    case 2: {
                        this.doDyingTick();
                        break;
                    }
                    case 3: {
                        this.doResOut();
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        } else {
                            break;
                        }
                    }
                }
            } while (this.state != currentState);
        }

        protected abstract void doSpawnTick();

        protected abstract void doAliveTick();

        protected abstract void doDyingTick();

        protected abstract void doResOut();
    }
}

