/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.algorithms.Bresenham;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Blob;
import xap.Entity;
import xap.Game;
import xap.Gidrah;
import xap.Laser;
import xap.features.EntityFeature;

public class LaserFeature
extends EntityFeature {
    public static final long serialVersionUID = 1L;
    private static final Color fadeColor;
    private static final ArrayList proximal;
    private static final int POOLED = 0;
    private static final int ZAPPING = 1;
    private static final int FADING = 2;
    private int poolSize;
    private int speed;
    private int faderSpeed;
    private int faderDistance;
    private String colorSeqName;
    private int damage;
    private int delay;
    private String soundEffect;
    private float soundPitch;
    private transient int currentPoolSize;
    private transient LaserInstance[] pool;
    private transient ColorSequenceResource colorSeq;
    private transient ALBuffer soundEffectResource;
    private transient SpriteImage endSpriteImage;
    private transient SpriteImage bodySpriteImage;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.LaserFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        fadeColor = new Color();
        proximal = new ArrayList();
    }

    public LaserFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        if (this.currentPoolSize == this.poolSize) {
            return null;
        }
        return this.pool[this.currentPoolSize++];
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.colorSeq = (ColorSequenceResource)Resources.get((String)this.colorSeqName);
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
        this.endSpriteImage = (SpriteImage)Resources.get((String)"spotlight.16.imagebank.0");
        this.pool = new LaserInstance[this.poolSize];
        int i = 0;
        while (i < this.poolSize) {
            this.pool[i] = new LaserInstance();
            this.pool[i].index = i;
            ++i;
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.colorSeq = null;
        this.soundEffectResource = null;
        this.endSpriteImage = null;
        this.pool = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.poolSize = XMLUtil.getInt((Element)element, (String)"poolsize");
        this.speed = XMLUtil.getInt((Element)element, (String)"speed");
        this.faderSpeed = XMLUtil.getInt((Element)element, (String)"faderspeed");
        this.faderDistance = XMLUtil.getInt((Element)element, (String)"faderdistance");
        this.colorSeqName = XMLUtil.getString((Element)element, (String)"colorseq");
        this.damage = XMLUtil.getInt((Element)element, (String)"damage");
        this.delay = XMLUtil.getInt((Element)element, (String)"delay");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
        this.soundPitch = XMLUtil.getFloat((Element)element, (String)"soundpitch");
    }

    private void returnLaserToPool(LaserInstance laser) {
        if (!$assertionsDisabled && laser.state == 0) {
            throw new AssertionError();
        }
        laser.setState(0);
        this.pool[((LaserInstance)laser).index] = this.pool[this.currentPoolSize - 1];
        this.pool[laser.index].index = laser.index;
        this.pool[this.currentPoolSize - 1] = laser;
        laser.index = --this.currentPoolSize;
    }

    public void onNewGame() throws Exception {
        super.onNewGame();
        int i = this.currentPoolSize;
        while (--i >= 0) {
            this.pool[i].remove();
        }
    }

    public int getAutofireDelay() {
        return this.delay;
    }

    private final class LaserInstance
    extends EntityFeature.EntityInstance
    implements Laser,
    Laser.Collider {
        private int index;
        private final Bresenham headBresenham = new Bresenham();
        private final Bresenham tailBresenham = new Bresenham();
        private int state;
        private Sprite headSprite = Game.allocateSprite(this);
        private int tick;
        private int fadeTick;
        private SoundEffect fx;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.features.LaserFeature$LaserInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        LaserInstance() {
            this.headSprite.setActive(false);
        }

        public void spawn() {
            this.setState(1);
            this.headSprite.setActive(true);
            this.tick = LaserFeature.this.faderDistance;
            this.fadeTick = 0;
            this.headSprite.setImage(LaserFeature.this.endSpriteImage);
        }

        private final void setState(int newState) {
            if (newState != this.state) {
                switch (newState) {
                    case 1: {
                        if (!$assertionsDisabled && this.state != 0) {
                            throw new AssertionError((Object)"Invalid state change");
                        }
                        this.state = 1;
                        break;
                    }
                    case 2: {
                        if (!$assertionsDisabled && this.state != 1) {
                            throw new AssertionError((Object)("Invalid state change from " + this.state));
                        }
                        this.state = 2;
                        break;
                    }
                    case 0: {
                        if (!$assertionsDisabled && this.state == 0) {
                            throw new AssertionError((Object)"Invalid state change");
                        }
                        this.state = 0;
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"Illegal laser state.");
                        }
                        break;
                    }
                }
            }
        }

        public final boolean isZapping() {
            return this.state == 1;
        }

        public final boolean isFading() {
            return this.state == 2;
        }

        public final boolean isPooled() {
            return this.state == 0;
        }

        public final void fade() {
            this.setState(2);
        }

        public boolean canCollide() {
            return this.state == 1;
        }

        public void inCollisionWith(Entity dest) {
            dest.inCollisionWithLaser(this);
        }

        public void inCollisionWithBlob(Blob blob) {
            Game.getGameMode().handleCollision((Laser.Collider)this, blob);
        }

        public void inCollisionWithGidrah(Gidrah gidrah) {
            Game.getGameMode().handleCollision((Laser.Collider)this, gidrah);
        }

        protected void doRemove() {
            this.headSprite.setActive(false);
            this.fx = null;
            LaserFeature.this.returnLaserToPool(this);
        }

        public void tick() {
            switch (this.state) {
                case 0: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"Should never tick a pooled laser");
                    }
                    break;
                }
                case 1: {
                    this.animateAliveLaser();
                }
                case 2: {
                    this.animateDyingLaser();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"Illegal laser state");
                    }
                    break;
                }
            }
        }

        private void animateAliveLaser() {
            int speed2 = LaserFeature.this.speed << Game.getOptions().getSpeedShift();
            LaserFeature.calculateProximity(FPMath.fpValue((int)this.headBresenham.getX()) + (this.velocity.getX() >> 1), FPMath.fpValue((int)this.headBresenham.getY()) + (this.velocity.getY() >> 1), FPMath.fpValue((int)speed2) + (this.getRadius() << 1), proximal);
            int n = proximal.size();
            int i = 0;
            block0: while (i < speed2) {
                if (this.headBresenham.next()) {
                    this.position.set(FPMath.fpValue((int)this.headBresenham.getX()), FPMath.fpValue((int)this.headBresenham.getY()), 0);
                    if ((i & 1) == 0) {
                        int j = 0;
                        while (j < n) {
                            EntityFeature.EntityInstance ent = (EntityFeature.EntityInstance)proximal.get(j);
                            if (ent != this && ent.isTouching(this)) {
                                ent.inCollisionWith(this);
                                this.inCollisionWith(ent);
                                if (!this.isZapping()) break block0;
                            }
                            ++j;
                        }
                    }
                } else {
                    this.fade();
                    break;
                }
                ++i;
            }
            if (this.fx != null) {
                this.fx.setPosition((float)this.headBresenham.getX(), (float)this.headBresenham.getY(), 0.0f, (Object)this);
            }
        }

        private void animateDyingLaser() {
            if (this.tick > 0) {
                --this.tick;
                if (this.tick > 0) {
                    this.tick -= Game.getOptions().getSpeedShift();
                }
            } else {
                int faderSpeed2 = LaserFeature.this.faderSpeed << Game.getOptions().getSpeedShift();
                int i = 0;
                while (i < faderSpeed2) {
                    if (this.tailBresenham.next()) {
                        if (this.tailBresenham.getX() == this.headBresenham.getX() && this.tailBresenham.getY() == this.headBresenham.getY()) {
                            this.remove();
                            break;
                        }
                    } else {
                        this.remove();
                        break;
                    }
                    ++i;
                }
            }
            this.headSprite.setLocation(this.headBresenham.getX(), this.headBresenham.getY(), 0);
            this.headSprite.setScale(Util.random((int)FPMath.ONE, (int)FPMath.TWO));
        }

        public void fireAt(Vector3i source, Vector3i target) {
            this.position.set((ReadableVector3i)source);
            this.headBresenham.plot(FPMath.intValue((int)source.getX()), FPMath.intValue((int)source.getY()), FPMath.intValue((int)target.getX()), FPMath.intValue((int)target.getY()));
            this.tailBresenham.plot(FPMath.intValue((int)source.getX()), FPMath.intValue((int)source.getY()), FPMath.intValue((int)target.getX()), FPMath.intValue((int)target.getY()));
            Vector3i.sub((ReadableVector3i)target, (ReadableVector3i)this.position, (WritableVector3i)this.velocity);
            this.velocity.normalize();
            this.velocity.scale(LaserFeature.this.speed << Game.getOptions().getSpeedShift());
            this.fx = Game.allocateSound(LaserFeature.this.soundEffectResource, this.position, this.velocity, this);
            if (this.fx != null) {
                this.fx.setPitch(LaserFeature.this.soundPitch, (Object)this);
            }
            this.tick();
        }

        public int getDamage() {
            return LaserFeature.this.damage;
        }

        public void render() {
            if (this.state != 0) {
                GL11.glLineWidth((float)(5.0f + FPMath.floatValue((int)this.getRadius())));
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)1);
                GL11.glBegin((int)1);
                if (this.state == 1) {
                    LaserFeature.this.colorSeq.getColor(this.tick >> 2, fadeColor);
                    GL11.glColor4ub((byte)fadeColor.getRedByte(), (byte)fadeColor.getGreenByte(), (byte)fadeColor.getBlueByte(), (byte)fadeColor.getAlphaByte());
                } else {
                    LaserFeature.this.colorSeq.getColor(this.fadeTick, fadeColor);
                    GL11.glColor4ub((byte)fadeColor.getRedByte(), (byte)fadeColor.getGreenByte(), (byte)fadeColor.getBlueByte(), (byte)fadeColor.getAlphaByte());
                    this.headSprite.setAlpha(fadeColor.getAlpha());
                }
                GL11.glVertex2f((float)this.headBresenham.getX(), (float)this.headBresenham.getY());
                if (this.tick > 0) {
                    LaserFeature.this.colorSeq.getColor(this.tick >> 2, fadeColor);
                    GL11.glColor4ub((byte)fadeColor.getRedByte(), (byte)fadeColor.getGreenByte(), (byte)fadeColor.getBlueByte(), (byte)0);
                } else {
                    LaserFeature.this.colorSeq.getColor(this.fadeTick++, fadeColor);
                    GL11.glColor4ub((byte)fadeColor.getRedByte(), (byte)fadeColor.getGreenByte(), (byte)fadeColor.getBlueByte(), (byte)0);
                }
                GL11.glVertex2f((float)this.tailBresenham.getX(), (float)this.tailBresenham.getY());
                GL11.glEnd();
                GL11.glLineWidth((float)1.0f);
            }
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            return 0.0f;
        }
    }
}

