/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.Feature;
import xap.Game;
import xap.MadJelly;
import xap.Ticked;
import xap.Ticker;
import xap.effects.StrobeEffect;
import xap.gidrahs.MadJellyFeature;

public class JellyIncursionFeature
extends Feature
implements Ticked {
    public static final long serialVersionUID = 1L;
    private static JellyIncursionFeature feature;
    private int baseJellies;
    private int jelliesPerLevel;
    private int initialJellies;
    private int initialJelliesPerLevel;
    private int delay;
    private String soundEffect;
    private int shakeDuration;
    private int shakeMagnitude;
    private String strobe;
    private String jelly;
    private transient MadJellyFeature madJellyFeature;
    private transient ALBuffer soundEffectResource;
    private transient ColorSequenceResource strobeResource;
    private transient JellyIncursionInstance instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.JellyIncursionFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public JellyIncursionFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.baseJellies = XMLUtil.getInt((Element)element, (String)"basejellies");
        this.jelliesPerLevel = XMLUtil.getInt((Element)element, (String)"jelliesperlevel");
        this.initialJellies = XMLUtil.getInt((Element)element, (String)"initialjellies");
        this.initialJelliesPerLevel = XMLUtil.getInt((Element)element, (String)"initialjelliesperlevel");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
        this.delay = XMLUtil.getInt((Element)element, (String)"delay");
        this.shakeDuration = XMLUtil.getInt((Element)element, (String)"shakeduration");
        this.shakeMagnitude = XMLUtil.getInt((Element)element, (String)"shakemagnitude");
        this.strobe = XMLUtil.getString((Element)element, (String)"strobe");
        this.jelly = XMLUtil.getString((Element)element, (String)"jelly");
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.madJellyFeature = (MadJellyFeature)Resources.get((String)this.jelly);
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
        this.strobeResource = (ColorSequenceResource)Resources.get((String)this.strobe);
        Ticker.register(this);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.madJellyFeature = null;
        this.soundEffectResource = null;
        this.strobeResource = null;
        Ticker.deregister(this);
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && feature != null) {
            throw new AssertionError();
        }
        feature = this;
    }

    public void deregister() {
        super.deregister();
        feature = null;
    }

    public boolean tick() {
        if (this.instance != null) {
            this.instance.tick();
            return true;
        }
        return false;
    }

    public void onLastBlobDeath() throws Exception {
        super.onLastBlobDeath();
        if (!this.isCreated()) {
            this.create();
        }
        this.instance = new JellyIncursionInstance();
        StrobeEffect.spawn(this.strobeResource);
        Game.shake(this.shakeDuration, this.shakeMagnitude);
        Game.allocateBackgroundSound(this.soundEffectResource, this);
    }

    public void onEndGame() throws Exception {
        super.onEndGame();
        this.instance = null;
    }

    private class JellyIncursionInstance {
        private int numToCreate;
        private int tick;

        JellyIncursionInstance() {
            this.numToCreate = JellyIncursionFeature.this.baseJellies + JellyIncursionFeature.this.jelliesPerLevel * Game.getCurrentLevel();
            int n = Math.min(this.numToCreate, JellyIncursionFeature.this.initialJellies + JellyIncursionFeature.this.initialJelliesPerLevel * Game.getCurrentLevel());
            int i = 0;
            while (i < n) {
                this.makeJelly();
                ++i;
            }
        }

        private void makeJelly() {
            MadJelly jelly = (MadJelly)JellyIncursionFeature.this.madJellyFeature.spawn();
            if (jelly != null) {
                --this.numToCreate;
                if (this.numToCreate == 0) {
                    JellyIncursionFeature.this.instance = null;
                }
                jelly.resIn();
            }
        }

        private void tick() {
            ++this.tick;
            if (this.tick >= JellyIncursionFeature.this.delay >> Game.getOptions().getSpeedShift()) {
                this.tick = 0;
                this.makeJelly();
            }
        }
    }
}

