/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.ArrayList;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Bullet;
import xap.Emitter;
import xap.Entity;
import xap.Feature;
import xap.Game;
import xap.Gidrah;
import xap.Laser;
import xap.Nuke;
import xap.Orb;
import xap.Player;
import xap.Rocket;
import xap.SmartBomb;
import xap.effects.LabelEffect;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;
import xap.features.GameModeFeature;
import xap.features.LivingEntityFeature;

public abstract class GidrahFeature
extends LivingEntityFeature {
    public static final long serialVersionUID = 1L;
    public static final int MAX_GIDRAHS = 32;
    private static int numGidrahs;
    private static int numActiveGidrahs;
    private static final ArrayList queue;
    private static final ArrayList eolgRegistry;
    private int score;
    private int accuracy;
    private int hitPoints;
    private String bullets;
    private String beamInEmitter;
    private String explosionEmitter;
    private String soundEffect;
    private boolean cloud;
    private String ricochet;
    private boolean eolg;
    protected transient EntityFeature bulletFeature;
    protected transient EmitterFeature beamInEmitterFeature;
    protected transient EmitterFeature explosionEmitterFeature;
    protected transient EmitterFeature ricochetFeature;
    protected transient ALBuffer soundEffectResource;
    private transient GLFont scoreLabelFontResource;
    private transient ColorSequenceResource scoreLabelColorSequenceResource;

    static {
        queue = new ArrayList(32);
        eolgRegistry = new ArrayList(4);
        if (Game.isRunning()) {
            GameModeFeature.addGameEventListener(new Feature(){

                public void onEndGame() throws Exception {
                    super.onEndGame();
                    queue.clear();
                }
            });
        }
    }

    public GidrahFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.score = XMLUtil.getInt((Element)element, (String)"score");
        this.hitPoints = XMLUtil.getInt((Element)element, (String)"hitpoints");
        this.bullets = XMLUtil.getString((Element)element, (String)"bullets", null);
        if (this.bullets != null) {
            this.accuracy = XMLUtil.getInt((Element)element, (String)"accuracy");
        }
        this.explosionEmitter = XMLUtil.getString((Element)element, (String)"explosionemitter");
        this.beamInEmitter = XMLUtil.getString((Element)element, (String)"beaminemitter", null);
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect", null);
        this.cloud = XMLUtil.getBoolean((Element)element, (String)"cloud", (boolean)true);
        this.eolg = XMLUtil.getBoolean((Element)element, (String)"eolg", (boolean)false);
        if (this.hitPoints > 3) {
            this.ricochet = XMLUtil.getString((Element)element, (String)"ricochet");
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.explosionEmitterFeature = (EmitterFeature)Resources.get((String)this.explosionEmitter);
        if (this.beamInEmitter != null) {
            this.beamInEmitterFeature = (EmitterFeature)Resources.get((String)this.beamInEmitter);
        }
        if (this.hitPoints > 3) {
            this.ricochetFeature = (EmitterFeature)Resources.get((String)this.ricochet);
        }
        if (this.bullets != null) {
            this.bulletFeature = (EntityFeature)Resources.get((String)this.bullets);
        }
        if (Game.hasSound() && this.soundEffect != null) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
        this.scoreLabelFontResource = (GLFont)Resources.get((String)"impact-plain-18.glfont");
        this.scoreLabelColorSequenceResource = (ColorSequenceResource)Resources.get((String)"gidrah_score.colorseq");
    }

    protected void doDestroy() {
        super.doDestroy();
        this.explosionEmitterFeature = null;
        this.beamInEmitterFeature = null;
        this.ricochetFeature = null;
        this.bulletFeature = null;
        this.soundEffectResource = null;
        this.scoreLabelColorSequenceResource = null;
        this.scoreLabelFontResource = null;
    }

    public static void deregisterEOLG(GidrahFeature eolg) {
        eolgRegistry.remove(eolg);
    }

    public static void registerEOLG(GidrahFeature eolg) {
        eolgRegistry.add(eolg);
    }

    public static GidrahFeature getEOLG(int index) {
        return (GidrahFeature)eolgRegistry.get(index);
    }

    public static int getNumEOLGs() {
        return eolgRegistry.size();
    }

    public static int getNumGidrahs() {
        return numGidrahs;
    }

    public static int getNumQueuedGidrahs() {
        return queue.size();
    }

    public static int getNumActiveGidrahs() {
        return numActiveGidrahs;
    }

    public void register() {
        super.register();
        if (this.eolg) {
            GidrahFeature.registerEOLG(this);
        }
    }

    public void deregister() {
        super.deregister();
        if (this.eolg) {
            GidrahFeature.deregisterEOLG(this);
        }
    }

    public boolean canBeCreatedByCloud() {
        return this.cloud;
    }

    protected abstract class GidrahInstance
    extends LivingEntityFeature.LivingEntityInstance
    implements Gidrah,
    Gidrah.Collider {
        private boolean queued;
        private int wounds;
        private SmartBomb lastSmartBombHit;
        private int tick;
        private boolean rezFlag;
        private Emitter beamInEmitterInstance;
        private SoundEffect soundEffectInstance;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.features.GidrahFeature$GidrahInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        protected GidrahInstance() {
            super(GidrahFeature.this);
            numGidrahs = numGidrahs + 1;
        }

        protected final void doAliveTick() {
            if (this.soundEffectInstance != null) {
                this.soundEffectInstance.setPosition(FPMath.floatValue((int)this.position.getX()), FPMath.floatValue((int)this.position.getY()), 0.0f, (Object)this);
            }
            this.doGidrahTick();
        }

        protected void doDyingTick() {
        }

        protected final void doSpawnTick() {
            if (this.queued) {
                return;
            }
            ++this.tick;
            if (this.beamInEmitterInstance == null || !this.beamInEmitterInstance.isActive()) {
                this.hatch();
            } else {
                this.doGidrahSpawnTick();
            }
        }

        protected void doGidrahSpawnTick() {
        }

        protected void onDeath() {
            this.remove();
            GidrahFeature.this.explosionEmitterFeature.spawn(this.position.getX(), this.position.getY(), this.position.getZ(), this.velocity.getX(), this.velocity.getY(), this.velocity.getZ());
        }

        protected abstract void doGidrahTick();

        public final void inCollisionWith(Entity dest) {
            dest.inCollisionWithGidrah(this);
        }

        public final void inCollisionWithLaser(Laser laser) {
            Game.getGameMode().handleCollision((Gidrah.Collider)this, laser);
        }

        public void inCollisionWithRocket(Rocket rocket) {
            this.damage(10, rocket.getPosition().getX(), rocket.getPosition().getY());
        }

        public void inCollisionWithOrb(Orb orb) {
            this.damage(3, orb.getPosition().getX(), orb.getPosition().getY());
        }

        public void inCollisionWithSmartBomb(SmartBomb smartBomb) {
            if (this.lastSmartBombHit == smartBomb) {
                return;
            }
            this.lastSmartBombHit = smartBomb;
            this.damage(smartBomb.getDamage(), this.position.getX(), this.position.getY());
        }

        public void inCollisionWithNuke(Nuke nuke) {
            this.kill();
        }

        public void damage(int points, int x, int y) {
            this.wounds += points;
            if (this.wounds >= GidrahFeature.this.hitPoints) {
                this.kill();
                Game.getGameMode().addScore(GidrahFeature.this.score);
                LabelEffect.spawn(this.position.getX(), this.position.getY(), 0, 0, GidrahFeature.this.scoreLabelFontResource, GidrahFeature.this.scoreLabelColorSequenceResource, String.valueOf(GidrahFeature.this.score), false);
            } else {
                this.makeRicochetSound(x, y);
                this.indicateDamage();
            }
        }

        protected void makeRicochetSound(int x, int y) {
            GidrahFeature.this.ricochetFeature.spawn(x, y, 0, this.velocity.getX(), this.velocity.getY(), 0);
        }

        protected abstract void indicateDamage();

        protected void setWounds(int newWounds) {
            this.wounds = newWounds;
            if (this.wounds >= GidrahFeature.this.hitPoints) {
                this.kill();
                Game.getGameMode().addScore(GidrahFeature.this.score);
            }
        }

        public void inCollisionWithPlayer(Player player) {
            Game.getGameMode().handleCollision((Gidrah.Collider)this, player);
        }

        public void spawn() {
        }

        protected final void doRemove() {
            this.removeSprites();
            numGidrahs = numGidrahs - 1;
            if (!this.queued) {
                numActiveGidrahs = numActiveGidrahs - 1;
                if (queue.size() > 0 && numActiveGidrahs < 32) {
                    GidrahInstance newGidrah = (GidrahInstance)queue.remove(0);
                    newGidrah.queued = false;
                    newGidrah.spawn();
                    newGidrah.resIn();
                }
            } else {
                queue.remove(this);
            }
            if (this.soundEffectInstance != null) {
                this.soundEffectInstance.stop((Object)this);
            }
            this.doGidrahRemove();
            if (!($assertionsDisabled || numGidrahs >= 0 && numActiveGidrahs >= 0)) {
                throw new AssertionError();
            }
        }

        protected void fire() {
            if (!$assertionsDisabled && GidrahFeature.this.bulletFeature == null) {
                throw new AssertionError();
            }
            Bullet b = (Bullet)GidrahFeature.this.bulletFeature.spawn();
            if (b == null) {
                return;
            }
            b.fireAt(this, Game.getPlayer().getLastKnownPosition(), GidrahFeature.this.accuracy);
        }

        protected abstract void removeSprites();

        protected void doGidrahRemove() {
        }

        public final void resIn() {
            if (!$assertionsDisabled && this.queued) {
                throw new AssertionError((Object)"Can't res-in a queued gidrah!");
            }
            if (!$assertionsDisabled && GidrahFeature.this.beamInEmitterFeature == null) {
                throw new AssertionError((Object)"Can't res-in this gidrah!");
            }
            if (!GidrahFeature.this.eolg && numActiveGidrahs >= 32) {
                this.queued = true;
                queue.add(this);
                return;
            }
            numActiveGidrahs = numActiveGidrahs + 1;
            this.rezFlag = true;
            this.tick = 0;
            this.doResIn();
            this.beamInEmitterInstance = GidrahFeature.this.beamInEmitterFeature.spawn(this.position.getX(), this.position.getY(), 0, 0, 0, 0);
        }

        protected abstract void doResIn();

        protected final void onBirth() {
            if (!this.rezFlag) {
                numActiveGidrahs = numActiveGidrahs + 1;
            }
            if (GidrahFeature.this.soundEffectResource != null) {
                this.soundEffectInstance = Game.allocateSound(GidrahFeature.this.soundEffectResource, this.position, this.velocity, this);
            }
            this.onGidrahBirth();
        }

        protected void onGidrahBirth() {
        }

        protected void doResOut() {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Gidrahs can't res out!");
            }
        }

        protected void onResOut() {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Gidrahs can't res out!");
            }
        }

        public int getHitPoints() {
            return GidrahFeature.this.hitPoints;
        }

        public int getPointsValue() {
            return GidrahFeature.this.score;
        }

        public int getWounds() {
            return this.wounds;
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            color.set((byte)-1, (byte)0, (byte)0);
            pos.set((ReadableVector3i)this.position);
            return 1.0f;
        }
    }
}

