/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import xap.Feature;
import xap.Game;
import xap.GameEventListener;
import xap.GameMode;
import xap.Player;
import xap.Ticked;
import xap.Ticker;
import xap.features.GameModeFeature;
import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.Window;

public abstract class GameModeFeature
extends Feature
implements GameMode,
Ticked {
    public static final long serialVersionUID = 1L;
    private static final ArrayList allGameModes = new ArrayList(4);
    private static final ArrayList gameEventListeners = new ArrayList();
    private static GameMode lastChosenMode;
    private static GameModeFeature defaultGameModeFeature;
    private int initialLives;
    private int initialSmartbombs;
    private int initialShields;
    private int difficultyLevel;
    private int difficultyOffset;
    private int mode;
    private boolean needsUnlock;
    private int numberOfLevels;
    private String display;
    private ArrayList features;
    private boolean isDefault;
    private transient boolean gameIsOver;
    private transient int level;

    static {
        if (Game.isRunning()) {
            Ticker.register(new Ticked(){

                public boolean tick() {
                    Game.getGameMode().tick();
                    return true;
                }
            });
        }
    }

    public GameModeFeature(String name) {
        super(name);
    }

    public void deregister() {
        super.deregister();
        allGameModes.remove(this);
        if (this.isDefault) {
            defaultGameModeFeature = null;
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.mode = XMLUtil.getInt((Element)element, (String)"mode");
        this.initialLives = XMLUtil.getInt((Element)element, (String)"initiallives");
        this.initialSmartbombs = XMLUtil.getInt((Element)element, (String)"initialsmartbombs");
        this.initialShields = XMLUtil.getInt((Element)element, (String)"initialshields");
        this.difficultyLevel = XMLUtil.getInt((Element)element, (String)"difficultylevel");
        this.difficultyOffset = XMLUtil.getInt((Element)element, (String)"difficultyoffset", (int)0);
        this.needsUnlock = XMLUtil.getBoolean((Element)element, (String)"needsunlock");
        this.numberOfLevels = XMLUtil.getInt((Element)element, (String)"numberoflevels");
        this.display = XMLUtil.getString((Element)element, (String)"display");
        this.isDefault = XMLUtil.getBoolean((Element)element, (String)"default", (boolean)false);
        NodeList childNodes = element.getElementsByTagName("feature");
        if (childNodes.getLength() == 0) {
            throw new Exception(this + " has no Features!");
        }
        this.features = new ArrayList(childNodes.getLength());
        int i = 0;
        while (i < childNodes.getLength()) {
            Element node = (Element)childNodes.item(i);
            Text tn = (Text)node.getFirstChild();
            if (tn == null) {
                throw new Exception("Blank feature specified in " + this);
            }
            this.features.add(tn.getData());
            ++i;
        }
    }

    public void register() {
        super.register();
        allGameModes.add(this);
        if (this.isDefault) {
            defaultGameModeFeature = this;
        }
    }

    public static List getAllGameModes() {
        return allGameModes;
    }

    public static void beginNewGame() throws Exception {
        class Chooser
        extends Window {
            Chooser() throws Exception {
                super("Choose Game Mode");
                this.createGUI();
            }

            void createGUI() throws Exception {
                int n = GameModeFeature.access$0().size();
                GLFont font = (GLFont)Resources.get((String)"impact-plain-24.glfont");
                Color white = new Color(255, 255, 255);
                int i = 0;
                while (i < n) {
                    GameMode gameMode = (GameMode)GameModeFeature.access$0().get(n - i - 1);
                    CommandButton cb = new CommandButton(gameMode.getDisplay());
                    cb.pack().setLocation(50, i * 40).setWidth(150).setFont(font).setForegroundColor(white);
                    cb.setEnabled(gameMode.isUnlocked());
                    cb.addCommandButtonListener(new CommandButtonListener(this, gameMode){
                        final /* synthetic */ Chooser this$1;
                        private final /* synthetic */ GameMode val$gameMode;
                        {
                            this.this$1 = chooser;
                            this.val$gameMode = gameMode;
                        }

                        public boolean selected(CommandButton cb) {
                            this.this$1.close();
                            Game.beginNewGame(this.val$gameMode);
                            GameModeFeature.access$1(this.val$gameMode);
                            return false;
                        }
                    });
                    this.addChild(cb);
                    if (gameMode == GameModeFeature.access$2()) {
                        cb.requestFocus();
                    } else if (GameModeFeature.access$2() == null && gameMode.isDefault()) {
                        cb.requestFocus();
                    }
                    ++i;
                }
                this.pack();
                this.setWidth(250);
                this.setBorder(5, 15, 5, 5);
                this.centre();
            }
        }
        new Chooser().open();
    }

    public int getInitialShields() {
        return this.initialShields;
    }

    public int getDifficultyLevel() {
        return this.difficultyLevel;
    }

    public int getDifficultyOffset() {
        return this.difficultyOffset;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean needsUnlock() {
        return this.needsUnlock;
    }

    public int getNumberOfLevels() {
        return this.numberOfLevels;
    }

    public String getDisplay() {
        return this.display;
    }

    public final void doNewGame() throws Exception {
        this.onNewGame();
        this.level = -1;
        int i = 0;
        while (i < gameEventListeners.size()) {
            GameEventListener feature = (GameEventListener)gameEventListeners.get(i);
            feature.onNewGame();
            ++i;
        }
        Iterator i2 = this.features.iterator();
        while (i2.hasNext()) {
            String featureName = (String)i2.next();
            Feature feature = (Feature)Resources.get((String)featureName);
            feature.onNewGame();
        }
        this.doNewLevel();
    }

    public final void doNewLevel() throws Exception {
        if (!this.checkNextLevel()) {
            this.doGameOver();
            return;
        }
        this.onNewLevel();
        int i = 0;
        while (i < gameEventListeners.size()) {
            GameEventListener feature = (GameEventListener)gameEventListeners.get(i);
            feature.onNewLevel();
            ++i;
        }
        Iterator i2 = this.features.iterator();
        while (i2.hasNext()) {
            String featureName = (String)i2.next();
            Feature feature = (Feature)Resources.get((String)featureName);
            feature.onNewLevel();
        }
    }

    public abstract boolean checkNextLevel();

    public final void doEndGame() throws Exception {
        this.onEndGame();
        int i = 0;
        while (i < gameEventListeners.size()) {
            GameEventListener feature = (GameEventListener)gameEventListeners.get(i);
            feature.onEndGame();
            ++i;
        }
        Iterator i2 = this.features.iterator();
        while (i2.hasNext()) {
            String featureName = (String)i2.next();
            Feature feature = (Feature)Resources.get((String)featureName);
            feature.onEndGame();
        }
    }

    public final void doEndLevel() throws Exception {
        this.onEndLevel();
        int i = 0;
        while (i < gameEventListeners.size()) {
            GameEventListener feature = (GameEventListener)gameEventListeners.get(i);
            feature.onEndLevel();
            ++i;
        }
        Iterator i2 = this.features.iterator();
        while (i2.hasNext()) {
            String featureName = (String)i2.next();
            Feature feature = (Feature)Resources.get((String)featureName);
            feature.onEndLevel();
        }
    }

    public final void doGameOver() throws Exception {
        this.onGameOver();
        int i = 0;
        while (i < gameEventListeners.size()) {
            GameEventListener feature = (GameEventListener)gameEventListeners.get(i);
            feature.onGameOver();
            ++i;
        }
        Iterator i2 = this.features.iterator();
        while (i2.hasNext()) {
            String featureName = (String)i2.next();
            Feature feature = (Feature)Resources.get((String)featureName);
            feature.onGameOver();
        }
    }

    public final void doPlayerDeath() throws Exception {
        this.onPlayerDeath();
        int i = 0;
        while (i < gameEventListeners.size()) {
            GameEventListener feature = (GameEventListener)gameEventListeners.get(i);
            feature.onPlayerDeath();
            ++i;
        }
        Iterator i2 = this.features.iterator();
        while (i2.hasNext()) {
            String featureName = (String)i2.next();
            Feature feature = (Feature)Resources.get((String)featureName);
            feature.onPlayerDeath();
        }
    }

    public final void doPlayerSpawn() throws Exception {
        this.onPlayerSpawn();
        int i = 0;
        while (i < gameEventListeners.size()) {
            GameEventListener feature = (GameEventListener)gameEventListeners.get(i);
            feature.onPlayerSpawn();
            ++i;
        }
        Iterator i2 = this.features.iterator();
        while (i2.hasNext()) {
            String featureName = (String)i2.next();
            Feature feature = (Feature)Resources.get((String)featureName);
            feature.onPlayerSpawn();
        }
    }

    public final void doIntermission() throws Exception {
        this.onIntermission();
        int i = 0;
        while (i < gameEventListeners.size()) {
            GameEventListener feature = (GameEventListener)gameEventListeners.get(i);
            feature.onIntermission();
            ++i;
        }
        Iterator i2 = this.features.iterator();
        while (i2.hasNext()) {
            String featureName = (String)i2.next();
            Feature feature = (Feature)Resources.get((String)featureName);
            feature.onIntermission();
        }
    }

    public final void doLastBlobDeath() throws Exception {
        this.onLastBlobDeath();
        int i = 0;
        while (i < gameEventListeners.size()) {
            GameEventListener feature = (GameEventListener)gameEventListeners.get(i);
            feature.onLastBlobDeath();
            ++i;
        }
        Iterator i2 = this.features.iterator();
        while (i2.hasNext()) {
            String featureName = (String)i2.next();
            Feature feature = (Feature)Resources.get((String)featureName);
            feature.onLastBlobDeath();
        }
    }

    public void initialize(Player.Initializer playerFeature) {
        playerFeature.beginNewGame(this.initialLives, this.initialSmartbombs);
    }

    public boolean isGameOver() {
        return this.gameIsOver;
    }

    public void onGameOver() throws Exception {
        super.onGameOver();
        this.gameIsOver = true;
    }

    public void onNewGame() throws Exception {
        super.onNewGame();
        this.gameIsOver = false;
    }

    public void onNewLevel() throws Exception {
        super.onNewLevel();
        ++this.level;
    }

    public void displayStats(GameMode.StatsDisplay display) {
        display.setLevelNumber(this.level);
    }

    public int getCurrentLevel() {
        return this.level;
    }

    public void setCurrentLevel(int level) throws Exception {
        this.doEndLevel();
        this.level = level - 1;
    }

    public final boolean isDefault() {
        return this.isDefault;
    }

    public static void addGameEventListener(GameEventListener listener) {
        gameEventListeners.add(listener);
    }

    public static void removeGameEventListener(GameEventListener listener) {
        gameEventListeners.remove(listener);
    }

    static /* synthetic */ ArrayList access$0() {
        return allGameModes;
    }

    static /* synthetic */ void access$1(GameMode gameMode) {
        lastChosenMode = gameMode;
    }

    static /* synthetic */ GameMode access$2() {
        return lastChosenMode;
    }
}

