/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.ArrayList;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import xap.BattleZone;
import xap.Blob;
import xap.Compass;
import xap.Emitter;
import xap.Entity;
import xap.FloatingLabel;
import xap.Game;
import xap.Laser;
import xap.effects.LabelEffect;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;

public class BlobFeature
extends EntityFeature {
    public static final long serialVersionUID = 1L;
    private static BlobFeature instance;
    private static int nameCounter;
    private static final int THINKING = 0;
    private static final int MOVING = 1;
    private static final int CAPTURED = 2;
    private static final int MUTATING = 3;
    private static final int DYING = 4;
    private String explosionEmitter;
    private String capturedSoundEffect;
    private String rescuedSoundEffect;
    private String[] cuteName;
    private int rescueBonus;
    private int stylishRescueBonus;
    private String bonusPointsFont;
    private String bonusPointsColorSequence;
    private String blobNameFont;
    private String blobNameColorSequence;
    private String goldenBlobEmitter;
    private int defaultBlobs;
    private int maxBlobs;
    private transient EmitterFeature explosionEmitterFeature;
    private transient ALBuffer capturedSoundEffectResource;
    private transient ALBuffer rescuedSoundEffectResource;
    private transient Animation blobAnimationResource;
    private transient Animation blobShadowAnimationResource;
    private transient GLFont bonusPointsFontResource;
    private transient ColorSequenceResource bonusPointsColorSequenceResource;
    private transient GLFont blobNameFontResource;
    private transient ColorSequenceResource blobNameColorSequenceResource;
    private transient EmitterFeature goldenBlobEmitterFeature;
    private transient SpriteImage haloImageResource;
    private transient ArrayList blobs;
    private transient ArrayList survivors;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.BlobFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public BlobFeature(String name) {
        super(name);
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && instance != null) {
            throw new AssertionError();
        }
        instance = this;
    }

    public void deregister() {
        super.deregister();
        instance = null;
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new BlobInstance();
    }

    public void onNewGame() throws Exception {
        super.onNewGame();
        this.survivors.clear();
    }

    public void onNewLevel() throws Exception {
        super.onNewLevel();
        int n = this.survivors.size();
        int i = 0;
        while (i < n) {
            BlobInstance blob = (BlobInstance)this.spawn();
            blob.respawnAs(i);
            ++i;
        }
        if (Game.getGameMode().isCheckPointLevel()) {
            i = 0;
            while (i < this.defaultBlobs - n) {
                this.survivors.add(this.spawn());
                ++i;
            }
        }
    }

    public static void createNewBlob(int x, int y) {
        instance.doCreateNewBlob(x, y);
    }

    private void doCreateNewBlob(int x, int y) {
        if (this.survivors.size() == this.maxBlobs) {
            Game.getPlayer().tooManyBlobs();
        } else {
            BlobInstance blob = (BlobInstance)this.spawn();
            blob.setPosition(x, y, 0);
            this.survivors.add(blob);
        }
    }

    public static Blob getRandomBlob() {
        return instance.doGetRandomBlob();
    }

    private Blob doGetRandomBlob() {
        if (this.blobs.size() == 0) {
            return null;
        }
        return (Blob)this.blobs.get(Util.random((int)0, (int)(this.blobs.size() - 1)));
    }

    public static Blob getBlob(int index) {
        return (Blob)BlobFeature.instance.survivors.get(index);
    }

    public static int getNumBlobs() {
        return BlobFeature.instance.survivors.size();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.explosionEmitterFeature = (EmitterFeature)Resources.get((String)this.explosionEmitter);
        if (Game.hasSound()) {
            this.rescuedSoundEffectResource = (ALBuffer)Resources.get((String)this.rescuedSoundEffect);
            this.capturedSoundEffectResource = (ALBuffer)Resources.get((String)this.capturedSoundEffect);
        }
        this.blobAnimationResource = (Animation)Resources.get((String)"blob.animation");
        this.blobShadowAnimationResource = (Animation)Resources.get((String)"blob_shadow.animation");
        this.bonusPointsFontResource = (GLFont)Resources.get((String)this.bonusPointsFont);
        this.bonusPointsColorSequenceResource = (ColorSequenceResource)Resources.get((String)this.bonusPointsColorSequence);
        this.blobNameFontResource = (GLFont)Resources.get((String)this.blobNameFont);
        this.blobNameColorSequenceResource = (ColorSequenceResource)Resources.get((String)this.blobNameColorSequence);
        this.goldenBlobEmitterFeature = (EmitterFeature)Resources.get((String)this.goldenBlobEmitter);
        this.haloImageResource = (SpriteImage)Resources.get((String)"pointlight.64.imagebank.0");
        this.blobs = new ArrayList(this.maxBlobs);
        this.survivors = new ArrayList(this.maxBlobs);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.explosionEmitterFeature = null;
        this.rescuedSoundEffectResource = null;
        this.capturedSoundEffectResource = null;
        this.blobAnimationResource = null;
        this.blobShadowAnimationResource = null;
        this.bonusPointsFontResource = null;
        this.bonusPointsColorSequenceResource = null;
        this.blobNameFontResource = null;
        this.blobNameColorSequenceResource = null;
        this.goldenBlobEmitterFeature = null;
        this.blobs = null;
        this.survivors = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.explosionEmitter = XMLUtil.getString((Element)element, (String)"explosionemitter");
        this.rescuedSoundEffect = XMLUtil.getString((Element)element, (String)"rescuedsoundeffect");
        this.capturedSoundEffect = XMLUtil.getString((Element)element, (String)"capturedsoundeffect");
        this.rescueBonus = XMLUtil.getInt((Element)element, (String)"rescuebonus");
        this.stylishRescueBonus = XMLUtil.getInt((Element)element, (String)"stylishrescuebonus");
        this.bonusPointsFont = XMLUtil.getString((Element)element, (String)"bonuspointsfont");
        this.bonusPointsColorSequence = XMLUtil.getString((Element)element, (String)"bonuspointscolorsequence");
        this.blobNameFont = XMLUtil.getString((Element)element, (String)"blobnamefont");
        this.blobNameColorSequence = XMLUtil.getString((Element)element, (String)"blobnamecolorsequence");
        this.goldenBlobEmitter = XMLUtil.getString((Element)element, (String)"goldenblobemitter");
        this.defaultBlobs = XMLUtil.getInt((Element)element, (String)"defaultblobs");
        this.maxBlobs = XMLUtil.getInt((Element)element, (String)"maxblobs");
        NodeList nodeList = element.getElementsByTagName("cutename");
        this.cuteName = new String[nodeList.getLength()];
        int i = 0;
        while (i < nodeList.getLength()) {
            Element cuteNameElement = (Element)nodeList.item(i);
            this.cuteName[i] = ((Text)cuteNameElement.getFirstChild()).getData();
            ++i;
        }
    }

    public void squeak(Vector3i position) {
        Game.allocateSound(this.capturedSoundEffectResource, position, null, this);
    }

    public Animation getBlobAnimationResource() {
        return this.blobAnimationResource;
    }

    public Animation getBlobShadowAnimationResource() {
        return this.blobShadowAnimationResource;
    }

    private final class BlobInstance
    extends EntityFeature.EntityInstance
    implements Blob,
    Blob.Collider {
        private Sprite sprite;
        private Sprite shadowSprite;
        private Sprite haloSprite;
        private int dx;
        private int dy;
        private int duration;
        private int state;
        private int myCuteName;
        private FloatingLabel label;
        private int survivalTime;
        private Emitter goldenEmitter;
        private int immuneTick;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.features.BlobFeature$BlobInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        BlobInstance() {
            super(BlobFeature.this);
            this.sprite = Game.allocateSprite(this);
            this.sprite.setAnimation(BlobFeature.this.blobAnimationResource);
            this.sprite.setActive(false);
            this.shadowSprite = Game.allocateSprite(this);
            this.shadowSprite.setLayer(-2);
            this.shadowSprite.setAnimation(BlobFeature.this.blobShadowAnimationResource);
            this.shadowSprite.setActive(false);
            this.shadowSprite.setScale(FPMath.TWO);
            this.haloSprite = Game.allocateSprite(this);
            this.haloSprite.setLayer(-3);
            this.haloSprite.setImage(BlobFeature.this.haloImageResource);
            this.haloSprite.setActive(false);
            this.haloSprite.setColors(255, 255, 128, 127);
            this.haloSprite.setScale(FPMath.TWO);
            int n = nameCounter;
            nameCounter = n + 1;
            this.myCuteName = n;
            nameCounter = nameCounter % BlobFeature.this.cuteName.length;
        }

        public void spawn() {
            this.sprite.setActive(true);
            this.shadowSprite.setActive(true);
            this.position.set(FPMath.fpValue((int)(Util.random((int)0, (int)896) + 64)), FPMath.fpValue((int)(Util.random((int)0, (int)896) + 64)), 0);
            BlobFeature.this.blobs.add(this);
        }

        private void respawnAs(int index) {
            BlobInstance s = (BlobInstance)BlobFeature.this.survivors.get(index);
            this.myCuteName = s.myCuteName;
            this.survivalTime = s.survivalTime + 1;
            BlobFeature.this.survivors.set(index, this);
            if (this.isGolden()) {
                this.goldenEmitter = BlobFeature.this.goldenBlobEmitterFeature.spawn(0, 0, 0, 0, 0, 0);
                this.haloSprite.setActive(true);
            }
        }

        public void tick() {
            switch (this.state) {
                case 0: {
                    if (!(Math.random() < 0.05)) break;
                    int dir = Util.random((int)0, (int)3);
                    int destx = 0;
                    int desty = 0;
                    do {
                        dir = dir + 1 & 3;
                        this.dx = FPMath.fpValue((int)Compass.dx[dir << 1]);
                        this.dy = FPMath.fpValue((int)Compass.dy[dir << 1]);
                        destx = this.position.getX() + (this.dx << 5 + Game.getOptions().getSpeedShift());
                        desty = this.position.getY() + (this.dy << 5 + Game.getOptions().getSpeedShift());
                    } while (destx < 0 || destx >= BattleZone.FPWIDTH || desty < 0 || desty >= BattleZone.FPWIDTH);
                    this.duration = 16 >> Game.getOptions().getSpeedShift();
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.position.translate(this.dx, this.dy, 0);
                    --this.duration;
                    if (this.duration != 0) break;
                    this.state = 0;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    --this.duration;
                    if (this.duration != 0) break;
                    this.remove();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            if (this.immuneTick > 0) {
                this.immuneTick -= Game.getOptions().getTicksPerFrame();
            }
            if (this.sprite != null) {
                this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
                this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
                if (this.goldenEmitter != null) {
                    this.goldenEmitter.setPosition(this.position.getX(), this.position.getY(), 0);
                }
                if (this.isGolden()) {
                    this.haloSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
                }
            }
            if (this.label != null && !this.label.isVisible()) {
                this.label = null;
            }
        }

        public void inCollisionWith(Entity dest) {
            dest.inCollisionWithBlob(this);
        }

        public void inCollisionWithLaser(Laser laser) {
            Game.getGameMode().handleCollision(this, laser);
        }

        public boolean capture() {
            switch (this.state) {
                case 0: {
                    Game.allocateSound(BlobFeature.this.capturedSoundEffectResource, this.position, null, this);
                    Game.getPlayer().notifyAttack(this);
                    this.setState(2);
                    return true;
                }
                case 1: 
                case 2: 
                case 3: {
                    return false;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }

        private void setState(int newState) {
            if (this.state != newState) {
                switch (newState) {
                    case 0: {
                        this.state = newState;
                        break;
                    }
                    case 1: {
                        if (!$assertionsDisabled && this.state != 0) {
                            throw new AssertionError((Object)"Illegal blob state change");
                        }
                        this.state = newState;
                        break;
                    }
                    case 2: {
                        if (!$assertionsDisabled && this.state != 0) {
                            throw new AssertionError((Object)"Illegal blob state change");
                        }
                        this.state = newState;
                        break;
                    }
                    case 3: {
                        if (!$assertionsDisabled && this.state != 2) {
                            throw new AssertionError((Object)"Illegal blob state change");
                        }
                        this.state = newState;
                        break;
                    }
                    case 4: {
                        if (!$assertionsDisabled && this.state == 3) {
                            throw new AssertionError((Object)"Illegal blob state change");
                        }
                        this.state = newState;
                        this.remove();
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"Illegal blob state");
                        }
                        break;
                    }
                }
            }
        }

        protected void doRemove() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
            if (this.shadowSprite != null) {
                this.shadowSprite.deallocate();
                this.shadowSprite = null;
            }
            if (this.haloSprite != null) {
                this.haloSprite.deallocate();
                this.haloSprite = null;
            }
            if (this.goldenEmitter != null) {
                this.goldenEmitter.remove();
            }
            BlobFeature.this.blobs.remove(this);
        }

        private void decrementBlobCount() {
            BlobFeature.this.survivors.remove(this);
            if (BlobFeature.this.survivors.size() == 0 && !Game.isGameOver()) {
                try {
                    Game.getGameMode().doLastBlobDeath();
                }
                catch (Exception e) {
                    Game.handleException(e);
                }
            }
        }

        public void kill() {
            Game.getGameMode().onBlobDeath(this);
            this.setState(4);
            BlobFeature.this.blobs.remove(this);
            this.decrementBlobCount();
            BlobFeature.this.explosionEmitterFeature.spawn(this.position.getX(), this.position.getY(), 0, 0, 0, 0);
        }

        public void mutate() {
            this.setState(3);
            BlobFeature.this.blobs.remove(this);
            this.sprite.setActive(false);
            this.shadowSprite.setActive(false);
            if (this.goldenEmitter != null) {
                this.goldenEmitter.setActive(false);
            }
        }

        public void release() {
            this.setState(0);
            int bonus = this.isGolden() ? BlobFeature.this.stylishRescueBonus * 2 : BlobFeature.this.stylishRescueBonus;
            LabelEffect.spawn(this.position.getX(), this.position.getY(), 0, FPMath.fpValue((float)0.5f), BlobFeature.this.bonusPointsFontResource, BlobFeature.this.bonusPointsColorSequenceResource, String.valueOf(bonus), false);
            Game.allocateSound(BlobFeature.this.rescuedSoundEffectResource, this.position, null, this);
            Game.getGameMode().addScore(bonus);
            Game.getGameMode().onBlobRelease(this);
        }

        public void rescue() {
            this.setState(0);
            int bonus = this.isGolden() ? BlobFeature.this.rescueBonus * 2 : BlobFeature.this.rescueBonus;
            LabelEffect.spawn(this.position.getX(), this.position.getY(), 0, FPMath.fpValue((float)0.5f), BlobFeature.this.bonusPointsFontResource, BlobFeature.this.bonusPointsColorSequenceResource, String.valueOf(bonus), false);
            Game.getGameMode().addScore(bonus);
            Game.getGameMode().onBlobRescue(this);
            Game.allocateSound(BlobFeature.this.rescuedSoundEffectResource, this.position, null, this);
            this.sprite.setActive(true);
            this.shadowSprite.setActive(true);
            if (this.goldenEmitter != null) {
                this.goldenEmitter.setActive(true);
            }
            BlobFeature.this.blobs.add(this);
            this.immuneTick = 15;
        }

        public void jellify() {
            this.remove();
            this.decrementBlobCount();
        }

        public boolean isAlive() {
            return this.state == 1 || this.state == 0 || this.state == 2;
        }

        public boolean isCaptured() {
            return this.state == 2 || this.state == 3;
        }

        public boolean canCollide() {
            return this.isAlive() && this.immuneTick <= 0;
        }

        public String getCuteName() {
            return BlobFeature.this.cuteName[this.myCuteName];
        }

        public void displayName() {
            if (this.label != null) {
                this.label.reset();
            } else {
                this.label = LabelEffect.spawn(this.position.getX(), this.position.getY() + this.getRadius(), 0, 0, BlobFeature.this.blobNameFontResource, BlobFeature.this.blobNameColorSequenceResource, this.getCuteName(), false);
            }
        }

        public boolean isGolden() {
            return this.survivalTime > 4;
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            if (this.state == 3) {
                return 0.0f;
            }
            color.set((byte)0, (byte)64, (byte)-1);
            pos.set((ReadableVector3i)this.position);
            return 1.0f;
        }
    }
}

