/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Image;
import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.geometry.Classifier;
import com.shavenpuppy.jglib.geometry.storage.GeometryStorage;
import com.shavenpuppy.jglib.geometry.storage.QuadTree;
import com.shavenpuppy.jglib.opengl.GLBumpMap;
import com.shavenpuppy.jglib.opengl.GLFrozenBumpMap;
import com.shavenpuppy.jglib.opengl.GLNormalisationCubeMapTexture;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLRenderableObject;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.opengl.nvidia.AGPMemory;
import com.shavenpuppy.jglib.opengl.nvidia.GLFence;
import com.shavenpuppy.jglib.renderer.Renderer;
import com.shavenpuppy.jglib.renderer.Triangle;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.ObjectList;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.Color;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.w3c.dom.Element;
import xap.CellularTexture;
import xap.Feature;
import xap.Game;
import xap.background.BackgroundGeometry;
import xap.background.BumpMapPassState;
import xap.background.BumpMappedGeometry;
import xap.background.BumpMappedGeometrySortState;
import xap.background.BumpMappedShader;
import xap.background.CheapassAmbientPassState;
import xap.background.CheapassDiffusePassState;
import xap.background.CheapassShader;
import xap.background.DiffusePassState;
import xap.background.Light;
import xap.background.LitShader;
import xap.background.PlainGeometry;
import xap.background.PlainGeometrySortState;
import xap.background.PlainPassState;
import xap.background.PlainShader;
import xap.background.TextureSortState;
import xap.features.BackgroundFeature;

public class BackgroundFeature
extends Feature
implements GLRenderable {
    public static final long serialVersionUID = 1L;
    private static final float SQUARESIZE = 64.0f;
    private static final int SIZE = 128;
    private static final int MAX_TRIANGLES = 32768;
    private static final int MAX_VERTICES = 16641;
    private static Memory memory;
    private static ByteBuffer vertexBuffer;
    private static GLNormalisationCubeMapTexture ncm;
    private static GLFence fence;
    private static QuadTree quadTree;
    private static Renderer renderer;
    private static BackgroundGeometry geometry;
    private static final ObjectList visibleTriangles;
    private static final ObjectList visibleTrianglesShaders;
    private static final Light light;
    private static int vertexCount;
    private static int rendererStyle;
    private static final int BUMPMAPPED_RENDERER = 0;
    private static final int PLAIN_RENDERER = 1;
    private static final int CHEAPASS_RENDERER = 2;
    private String diffuseTextureType;
    private String bumpTextureType;
    private String diffuseColor;
    private transient ColorSequenceResource diffuseColorResource;
    private transient GLTexture diffuseTexture;
    private transient GLBumpMap bumpMapTexture;
    private transient LitShader litShader;
    private transient CellularTexture.CellType diffuseTextureTypeInstance;
    private transient CellularTexture.CellType bumpTextureTypeInstance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.BackgroundFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        visibleTriangles = new ObjectList(32768);
        visibleTrianglesShaders = new ObjectList(32768);
        light = new Light();
    }

    public BackgroundFeature() {
    }

    public BackgroundFeature(String name) {
        super(name);
    }

    protected void doCreate() throws Exception {
        this.diffuseTextureTypeInstance = CellularTexture.decode(this.diffuseTextureType);
        this.bumpTextureTypeInstance = CellularTexture.decode(this.bumpTextureType);
        if (this.diffuseColorResource == null) {
            this.diffuseColorResource = (ColorSequenceResource)Resources.get((String)this.diffuseColor);
        }
        this.diffuseTexture = new GLTexture("background_texture", (Image)new CellularTexture(64, 64, 0, this.diffuseTextureTypeInstance, 16, this.diffuseColorResource), 3553, 6407, 9728, 9729, true);
        this.diffuseTexture.create();
        switch (rendererStyle) {
            case 0: {
                this.bumpMapTexture = new GLBumpMap("bumpmap_texture", (Image)new CellularTexture(128, 128, 2, this.bumpTextureTypeInstance, 32, null), 64.0f);
                break;
            }
            case 1: 
            case 2: {
                this.bumpMapTexture = new GLFrozenBumpMap("bumpmap_texture", (Image)new CellularTexture(128, 128, 2, this.bumpTextureTypeInstance, 32, null), 64.0f, (Vector3f)new Vector3f(1.0f, -1.0f, 1.0f).normalise());
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        this.bumpMapTexture.create();
        switch (rendererStyle) {
            case 0: {
                BumpMappedGeometrySortState geometrySortState = new BumpMappedGeometrySortState((BumpMappedGeometry)geometry);
                DiffusePassState diffusePassState = new DiffusePassState((BumpMappedGeometry)geometry);
                TextureSortState textureSortState = new TextureSortState(0, (GLRenderableObject)this.diffuseTexture);
                TextureSortState bumpTextureSortState = new TextureSortState(0, (GLRenderableObject)this.bumpMapTexture);
                BumpMapPassState bumpMapPassState = new BumpMapPassState((BumpMappedGeometry)geometry, ncm);
                this.litShader = new BumpMappedShader(geometrySortState, bumpMapPassState, diffusePassState, bumpTextureSortState, textureSortState, 16641);
                break;
            }
            case 1: {
                PlainGeometrySortState geometrySortState = new PlainGeometrySortState((PlainGeometry)geometry);
                PlainPassState plainPassState = new PlainPassState((PlainGeometry)geometry);
                TextureSortState textureSortState = new TextureSortState(0, (GLRenderableObject)this.diffuseTexture);
                TextureSortState bumpTextureSortState = new TextureSortState(1, (GLRenderableObject)this.bumpMapTexture);
                this.litShader = new PlainShader(geometrySortState, plainPassState, textureSortState, bumpTextureSortState, 16641);
                break;
            }
            case 2: {
                PlainGeometrySortState geometrySortState = new PlainGeometrySortState((PlainGeometry)geometry);
                CheapassAmbientPassState ambientPassState = new CheapassAmbientPassState((PlainGeometry)geometry);
                CheapassDiffusePassState diffusePassState = new CheapassDiffusePassState((PlainGeometry)geometry);
                TextureSortState ambientSortState = new TextureSortState(0, (GLRenderableObject)this.diffuseTexture);
                TextureSortState diffuseSortState = new TextureSortState(0, (GLRenderableObject)this.bumpMapTexture);
                this.litShader = new CheapassShader(geometrySortState, ambientPassState, diffusePassState, ambientSortState, diffuseSortState, 16641);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public static void init() throws Exception {
        int vertexSize;
        ContextCapabilities capabilities = GLContext.getCapabilities();
        if (!Game.CHEAPASS && Game.getOptions().useBumpMapping() && (capabilities.GL_ARB_texture_env_dot3 || capabilities.GL_EXT_texture_env_dot3) && capabilities.GL_ARB_multitexture) {
            rendererStyle = 0;
            vertexSize = 32;
        } else if (!Game.CHEAPASS && (capabilities.GL_ARB_texture_env_combine || capabilities.GL_EXT_texture_env_combine) && capabilities.GL_ARB_multitexture) {
            rendererStyle = 1;
            vertexSize = 32;
        } else {
            rendererStyle = 2;
            vertexSize = 32;
        }
        memory = AGPMemory.allocate((int)(16641 * vertexSize));
        vertexBuffer = memory.getBuffer();
        switch (rendererStyle) {
            case 0: {
                geometry = new BumpMappedGeometry(vertexBuffer);
                ncm = new GLNormalisationCubeMapTexture(128);
                ncm.create();
                break;
            }
            case 1: 
            case 2: {
                geometry = new PlainGeometry(vertexBuffer);
                if (ncm == null) break;
                if (ncm.isCreated()) {
                    ncm.destroy();
                }
                ncm = null;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        renderer = new Renderer(32768, 4);
        vertexCount = 0;
        class BigFlatPlane
        implements BackgroundGeometry.Geometry {
            final int size;
            final float scale;
            final float origin;
            Vector3f[] vertex;
            Vector3f[] normal;
            Vector2f[] tex;

            BigFlatPlane(float scale, int size) {
                this.size = size;
                this.scale = scale;
                this.vertex = new Vector3f[(size + 1) * (size + 1)];
                this.tex = new Vector2f[(size + 1) * (size + 1)];
                this.origin = (1024.0f - (float)size * scale) / 2.0f;
                int count = 0;
                int y = 0;
                while (y < size + 1) {
                    int x = 0;
                    while (x < size + 1) {
                        this.vertex[count] = new Vector3f(this.origin + (float)x * scale, this.origin + (float)y * scale, 0.0f);
                        this.tex[count++] = new Vector2f((float)x / (256.0f / scale), (float)y / (256.0f / scale));
                        ++x;
                    }
                    ++y;
                }
            }

            void write(BackgroundGeometry geometry) {
                int i = 0;
                while (i < this.vertex.length) {
                    int n = BackgroundFeature.access$1();
                    BackgroundFeature.access$2(n + 1);
                    geometry.write(n, this);
                    ++i;
                }
            }

            public void writeVertexData(int i, FloatBuffer buf) {
                this.vertex[i].store(buf);
            }

            public void writeTexCoordData(int i, FloatBuffer buf) {
                this.tex[i].store(buf);
            }

            ObjectList genTris() {
                ObjectList ret = new ObjectList(this.size * this.size * 2);
                int sizeP1 = this.size + 1;
                int y = 0;
                while (y < this.size) {
                    int x = 0;
                    while (x < this.size) {
                        int adx = x % 7;
                        int ady = y * 7;
                        int ado = this.size * 7 * (x / 7);
                        int adj = ado + adx + ady << 1;
                        ret.add((Object)((Object)new Tri(x + y * sizeP1, x + 1 + y * sizeP1, x + sizeP1 + 1 + y * sizeP1, adj)));
                        ret.add((Object)((Object)new Tri(x + y * sizeP1, x + sizeP1 + 1 + y * sizeP1, x + sizeP1 + y * sizeP1, adj + 1)));
                        ++x;
                    }
                    ++y;
                }
                return ret;
            }
        }
        BigFlatPlane bigFlatPlane = new BigFlatPlane(64.0f, 128);
        bigFlatPlane.write(geometry);
        ObjectList tris = bigFlatPlane.genTris();
        quadTree = new QuadTree(tris, 2, 64.0f, bigFlatPlane.origin, bigFlatPlane.origin, 8192.0f);
    }

    public static void cleanup() {
        renderer = null;
        quadTree = null;
        ncm = null;
        geometry = null;
        vertexBuffer = null;
        fence = null;
        memory = null;
    }

    protected void doDestroy() {
        this.diffuseTexture.destroy();
        this.diffuseTexture = null;
        this.bumpMapTexture.destroy();
        this.bumpMapTexture = null;
        this.litShader = null;
        this.diffuseColorResource = null;
    }

    public void render() {
        visibleTriangles.clear();
        quadTree.visible((Classifier)Game.getFrustum(), visibleTriangles, 2);
        int n = visibleTriangles.size();
        visibleTrianglesShaders.clear();
        int i = 0;
        while (i < n) {
            visibleTrianglesShaders.add((Object)this.litShader);
            ++i;
        }
        BackgroundFeature.light.x = FPMath.floatValue((int)Game.getPlayer().getBeamInTarget().getX());
        BackgroundFeature.light.y = FPMath.floatValue((int)Game.getPlayer().getBeamInTarget().getY());
        BackgroundFeature.light.z = 50.0f;
        BackgroundFeature.light.radius = 256.0f;
        this.litShader.setLight(light);
        this.litShader.reset();
        renderer.add(visibleTriangles, visibleTrianglesShaders);
        renderer.render();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.diffuseTextureType = XMLUtil.getString((Element)element, (String)"diffusetexturetype");
        this.bumpTextureType = XMLUtil.getString((Element)element, (String)"bumptexturetype");
        this.diffuseColor = XMLUtil.getString((Element)element, (String)"diffusecolor");
    }

    public static BackgroundFeature createRandom() throws Exception {
        Color c1;
        BackgroundFeature ret = new BackgroundFeature();
        ret.diffuseTextureType = CellularTexture.randomCode();
        ret.bumpTextureType = CellularTexture.randomCode();
        Color c0 = BackgroundFeature.createRandomColor();
        while ((c1 = BackgroundFeature.createRandomColor()).equals((Object)c0)) {
        }
        ret.diffuseColorResource = new ColorSequenceResource(new ColorSequenceResource.SequenceEntry[]{new ColorSequenceResource.SequenceEntry(c0, 255, 255), new ColorSequenceResource.SequenceEntry(c1, 0, 0)}, 0);
        ret.diffuseColorResource.create();
        ret.create();
        return ret;
    }

    private static Color createRandomColor() {
        return new Color(Util.random((int)0, (int)2) * 127, Util.random((int)0, (int)2) * 127, Util.random((int)0, (int)2) * 127);
    }

    static /* synthetic */ int access$1() {
        return vertexCount;
    }

    static /* synthetic */ void access$2(int n) {
        vertexCount = n;
    }

    private static class Tri
    extends Triangle
    implements GeometryStorage.Geometry {
        public Tri(int a, int b, int c, int adjacency) {
            super(a, b, c, adjacency);
        }

        public void getCoords(ArrayList in) {
            Vector3f av = new Vector3f();
            Vector3f bv = new Vector3f();
            Vector3f cv = new Vector3f();
            geometry.getVertex(this.a, av);
            geometry.getVertex(this.b, bv);
            geometry.getVertex(this.c, cv);
            in.add(av);
            in.add(bv);
            in.add(cv);
        }
    }
}

