/*
 * Decompiled with CFR 0.152.
 */
package xap.eolgs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Game;
import xap.Gidrah;
import xap.HomingMovement;
import xap.Nuke;
import xap.Player;
import xap.SmartBomb;
import xap.features.EntityFeature;
import xap.features.GidrahFeature;
import xap.gidrahs.BasicGidrahFeature;
import xap.resources.HomingMovementResource;

public class EnormousJellyFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private static final Vector3i scratchVector = new Vector3i();
    private String liveSpawn;
    private String deadSpawn;
    private int minSpawn;
    private int maxSpawn;
    private int numDeadSpawn;
    private int finalScale;
    private int defaultRadius;
    private HomingMovementResource movementResource;
    private int minAttackInterval;
    private int maxAttackInterval;
    private String spawnSound;
    private String wobbleAnimation;
    private String wobbleShadowAnimation;
    private transient GidrahFeature liveSpawnFeature;
    private transient GidrahFeature deadSpawnFeature;
    private transient ALBuffer spawnSoundResource;
    private transient Animation wobbleAnimationResource;
    private transient Animation wobbleShadowAnimationResource;

    public EnormousJellyFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new EnormousJellyInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.liveSpawnFeature = (GidrahFeature)Resources.get((String)this.liveSpawn);
        this.deadSpawnFeature = (GidrahFeature)Resources.get((String)this.deadSpawn);
        if (Game.hasSound()) {
            this.spawnSoundResource = (ALBuffer)Resources.get((String)this.spawnSound);
        }
        this.wobbleAnimationResource = (Animation)Resources.get((String)this.wobbleAnimation);
        this.wobbleShadowAnimationResource = (Animation)Resources.get((String)this.wobbleShadowAnimation);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.liveSpawnFeature = null;
        this.deadSpawnFeature = null;
        this.spawnSoundResource = null;
        this.wobbleAnimationResource = null;
        this.wobbleShadowAnimationResource = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.liveSpawn = XMLUtil.getString((Element)element, (String)"livespawn");
        this.deadSpawn = XMLUtil.getString((Element)element, (String)"deadspawn");
        this.minSpawn = XMLUtil.getInt((Element)element, (String)"minspawn");
        this.maxSpawn = XMLUtil.getInt((Element)element, (String)"maxspawn");
        this.numDeadSpawn = XMLUtil.getInt((Element)element, (String)"numdeadspawn");
        this.minAttackInterval = XMLUtil.getInt((Element)element, (String)"minattackinterval");
        this.maxAttackInterval = XMLUtil.getInt((Element)element, (String)"maxattackinterval");
        this.finalScale = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"finalscale"));
        this.spawnSound = XMLUtil.getString((Element)element, (String)"spawnsound");
        this.movementResource = new HomingMovementResource();
        this.movementResource.load(element, loader);
        this.wobbleAnimation = XMLUtil.getString((Element)element, (String)"wobbleanimation");
        this.wobbleShadowAnimation = XMLUtil.getString((Element)element, (String)"wobbleshadowanimation");
        this.defaultRadius = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"radius"));
    }

    private class EnormousJellyInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private int tick;
        private final HomingMovement movementInstance;
        private int currentRadius;
        private int currentRadiusSquared;
        private int nextAttackTime;

        public EnormousJellyInstance() {
            super(EnormousJellyFeature.this);
            this.movementInstance = EnormousJellyFeature.this.movementResource.spawn(this);
            this.setNextAttackTime();
        }

        protected void initSprite() {
            this.sprite.setAnimation(EnormousJellyFeature.this.wobbleAnimationResource);
            this.shadowSprite.setAnimation(EnormousJellyFeature.this.wobbleShadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
            this.calculateRadius();
        }

        protected void setWounds(int newWounds) {
            super.setWounds(newWounds);
            this.calculateRadius();
        }

        public void damage(int points, int x, int y) {
            super.damage(points, x, y);
            this.calculateRadius();
        }

        private void calculateRadius() {
            int currentScale = CosineInterpolator.instance.interpolate(FPMath.TWO, EnormousJellyFeature.this.finalScale, FPMath.fpValue((float)((float)this.getWounds() / (float)this.getHitPoints())));
            if (this.sprite != null) {
                this.sprite.setScale(currentScale);
                this.shadowSprite.setScale(currentScale);
            }
            this.currentRadius = FPMath.mul((int)currentScale, (int)EnormousJellyFeature.this.defaultRadius);
            this.currentRadiusSquared = FPMath.mul((int)this.currentRadius, (int)this.currentRadius);
        }

        private void setNextAttackTime() {
            this.nextAttackTime = Util.random((int)EnormousJellyFeature.this.minAttackInterval, (int)EnormousJellyFeature.this.maxAttackInterval);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            if (Math.random() < 0.0025) {
                this.selectNewTarget();
            }
            this.movementInstance.tick();
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            ++this.tick;
            if (this.tick > this.nextAttackTime) {
                this.tick = 0;
                int n = (int)LinearInterpolator.instance.interpolate((float)EnormousJellyFeature.this.maxSpawn, (float)EnormousJellyFeature.this.minSpawn, (float)this.getWounds() / (float)this.getHitPoints());
                int i = 0;
                while (i < n) {
                    Gidrah gidrah = (Gidrah)EnormousJellyFeature.this.liveSpawnFeature.spawn();
                    int angle = Util.random((int)0, (int)FPMath.ONE);
                    gidrah.setPosition(this.position.getX() + FPMath.mul((int)this.currentRadius, (int)FPMath.cos((int)angle)), this.position.getY() + FPMath.mul((int)this.currentRadius, (int)FPMath.sin((int)angle)), 0);
                    gidrah.hatch();
                    ++i;
                }
                Game.allocateSound(EnormousJellyFeature.this.spawnSoundResource, this.position, null, this);
                this.setNextAttackTime();
            }
        }

        protected void doResIn() {
            this.randomLocation(this.position);
            this.selectNewTarget();
        }

        private void selectNewTarget() {
            this.randomLocation(scratchVector);
            this.movementInstance.setDestination(scratchVector.getX(), scratchVector.getY());
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            super.getRadarBlip(color, pos);
            return 5.0f;
        }

        public void inCollisionWithNuke(Nuke nuke) {
        }

        public void inCollisionWithSmartBomb(SmartBomb smartBomb) {
        }

        public void inCollisionWithPlayer(Player player) {
        }

        protected void onDeath() {
            super.onDeath();
            int i = 0;
            while (i < EnormousJellyFeature.this.numDeadSpawn) {
                Gidrah gidrah = (Gidrah)EnormousJellyFeature.this.deadSpawnFeature.spawn();
                this.getPosition(gidrah.getPosition());
                int angle = Util.random((int)0, (int)FPMath.ONE);
                int speed = Util.random((int)FPMath.fpValue((int)4), (int)FPMath.fpValue((int)8));
                gidrah.setVelocity(FPMath.mul((int)speed, (int)FPMath.cos((int)angle)), FPMath.mul((int)speed, (int)FPMath.sin((int)angle)), 0);
                gidrah.hatch();
                ++i;
            }
        }

        public int getRadius() {
            return this.currentRadius;
        }

        public int getRadiusSquared() {
            return this.currentRadiusSquared;
        }
    }
}

