/*
 * Decompiled with CFR 0.152.
 */
package xap.emitters;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.interpolators.SineInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.w3c.dom.Element;
import xap.Game;
import xap.Particle;
import xap.features.EmitterFeature;
import xap.features.ParticleFeature;

public class FlechetteEmitterFeature
extends EmitterFeature {
    public static final long serialVersionUID = 1L;
    private int numParticles;
    private String particle;
    private String soundEffect;
    private int rotation;
    private int initialRadius;
    private int finalRadius;
    private String interpolator;
    private transient ParticleFeature particleResource;
    private transient ALBuffer soundEffectResource;
    private transient Interpolator interpolatorInstance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.emitters.FlechetteEmitterFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public FlechetteEmitterFeature() {
    }

    public FlechetteEmitterFeature(String name) {
        super(name);
    }

    protected EmitterFeature.EmitterInstance doSpawn() {
        return new FlechetteEmitterInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.numParticles = XMLUtil.getInt((Element)element, (String)"numparticles");
        this.particle = XMLUtil.getString((Element)element, (String)"particle");
        this.initialRadius = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"initialradius"));
        this.finalRadius = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"finalradius"));
        this.interpolator = XMLUtil.getString((Element)element, (String)"interpolator");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect", null);
        this.rotation = XMLUtil.getInt((Element)element, (String)"rotation", (int)0);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.particleResource = (ParticleFeature)Resources.get((String)this.particle);
        if (Game.hasSound() && this.soundEffect != null) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
        if (this.interpolator.equals("linear")) {
            this.interpolatorInstance = LinearInterpolator.instance;
        } else if (this.interpolator.equals("cosine")) {
            this.interpolatorInstance = CosineInterpolator.instance;
        } else if (this.interpolator.equals("sine")) {
            this.interpolatorInstance = SineInterpolator.instance;
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unknown interpolator '" + this.interpolator + "'"));
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.soundEffectResource = null;
        this.particleResource = null;
    }

    protected class FlechetteEmitterInstance
    extends EmitterFeature.EmitterInstance {
        protected final Particle[] flechette;

        protected FlechetteEmitterInstance() {
            super(FlechetteEmitterFeature.this);
            this.flechette = new Particle[FlechetteEmitterFeature.this.numParticles];
        }

        protected void doTick() {
            int time = this.getTick() - this.getDelay();
            int currentRadius = FlechetteEmitterFeature.this.interpolatorInstance.interpolate(FlechetteEmitterFeature.this.initialRadius, FlechetteEmitterFeature.this.finalRadius, FPMath.div((int)time, (int)(this.getDuration() - this.getDelay())));
            int rotateAngle = time * FlechetteEmitterFeature.this.rotation;
            int i = 0;
            while (i < FlechetteEmitterFeature.this.numParticles) {
                Particle p = this.flechette[i];
                if (p != null) {
                    Vector3i pos = p.getPosition();
                    int angle = (i << 16) / FlechetteEmitterFeature.this.numParticles + rotateAngle;
                    pos.set((ReadableVector3i)this.position);
                    pos.translate(FPMath.mul((int)currentRadius, (int)FPMath.cos((int)angle)), FPMath.mul((int)currentRadius, (int)FPMath.sin((int)angle)), 0);
                }
                ++i;
            }
        }

        protected void doSpawn() {
            int i = 0;
            while (i < FlechetteEmitterFeature.this.numParticles) {
                this.flechette[i] = FlechetteEmitterFeature.this.particleResource.allocate(this.position.getX(), this.position.getY(), this.position.getZ(), 0, 0, 0);
                ++i;
            }
            if (FlechetteEmitterFeature.this.soundEffectResource != null) {
                Game.allocateSound(FlechetteEmitterFeature.this.soundEffectResource, this.position, this.velocity, this);
            }
        }
    }
}

