/*
 * Decompiled with CFR 0.152.
 */
package xap.effects;

import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.opengl.nvidia.AGPMemory;
import com.shavenpuppy.jglib.opengl.nvidia.GLFence;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.vector.Vector2f;
import org.w3c.dom.Element;
import xap.Compass;
import xap.FluxMouse;
import xap.Game;
import xap.features.SpecialEffectFeature;

public class WobblyPlaneEffect
extends SpecialEffectFeature {
    public static final long serialVersionUID = 1L;
    private static final int VERTEX_SIZE = 32;
    private static final int VERTEX_SHIFT = 5;
    private static final int VERTEX_SHIFT2 = 3;
    private static final int TEXCOORDS_OFFSET = 12;
    private static final int TEXCOORDS_OFFSET2 = 3;
    private static final Vector2f mouseMove = new Vector2f();
    private static final float[] distance = new float[8];
    private String texture;
    private String shadowTexture;
    private float acceleration;
    private float deceleration;
    private float maxAcceleration;
    private float maxSpeed;
    private float range;
    private int tilesAcross;
    private int tilesDown;
    private int width;
    private int height;
    private int fadeInSpeed;
    private int shadowXOffset;
    private int shadowYOffset;
    private transient GLTexture textureResource;
    private transient GLTexture shadowTextureResource;

    public WobblyPlaneEffect() {
    }

    public WobblyPlaneEffect(String name) {
        super(name);
    }

    protected SpecialEffectFeature.SpecialEffectInstance doSpawn() {
        try {
            return new WobblyPlaneEffectInstance();
        }
        catch (Exception e) {
            Game.handleException(e);
            return null;
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.texture = XMLUtil.getString((Element)element, (String)"texture");
        this.shadowTexture = XMLUtil.getString((Element)element, (String)"shadowtexture", null);
        this.shadowXOffset = XMLUtil.getInt((Element)element, (String)"shadowxoffset", (int)-16);
        this.shadowYOffset = XMLUtil.getInt((Element)element, (String)"shadowyoffset", (int)16);
        this.acceleration = XMLUtil.getFloat((Element)element, (String)"acceleration");
        this.maxAcceleration = XMLUtil.getFloat((Element)element, (String)"maxacceleration");
        this.maxSpeed = XMLUtil.getFloat((Element)element, (String)"maxspeed");
        this.tilesAcross = XMLUtil.getInt((Element)element, (String)"tilesacross");
        this.tilesDown = XMLUtil.getInt((Element)element, (String)"tilesdown");
        this.width = XMLUtil.getInt((Element)element, (String)"width");
        this.height = XMLUtil.getInt((Element)element, (String)"height");
        this.deceleration = XMLUtil.getFloat((Element)element, (String)"deceleration");
        this.range = XMLUtil.getFloat((Element)element, (String)"range");
        this.fadeInSpeed = XMLUtil.getInt((Element)element, (String)"fadeinspeed", (int)1);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.textureResource = (GLTexture)Resources.get((String)this.texture);
        if (this.shadowTexture != null) {
            this.shadowTextureResource = (GLTexture)Resources.get((String)this.shadowTexture);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.textureResource = null;
        this.shadowTextureResource = null;
    }

    private class WobblyPlaneEffectInstance
    extends SpecialEffectFeature.SpecialEffectInstance {
        private final FloatBuffer vertexBuf;
        private final FloatBuffer texCoordBuf;
        private final IntBuffer indexBuf;
        private final Memory vertexMemory;
        private final Memory indexMemory;
        private GLFence fence;
        private final float[] hx;
        private final float[] hy;
        private final float[] x;
        private final float[] y;
        private final float[] dx;
        private final float[] dy;

        protected WobblyPlaneEffectInstance() throws Exception {
            int xx;
            super(WobblyPlaneEffect.this);
            int ncoords = (WobblyPlaneEffect.this.tilesAcross + 1) * (WobblyPlaneEffect.this.tilesDown + 1);
            this.vertexMemory = AGPMemory.allocate((int)(32 * ncoords));
            this.indexMemory = AGPMemory.allocate((int)(WobblyPlaneEffect.this.tilesAcross * WobblyPlaneEffect.this.tilesDown * 24));
            this.vertexBuf = this.vertexMemory.getBuffer().asFloatBuffer();
            this.texCoordBuf = Memory.chop((ByteBuffer)this.vertexMemory.getBuffer(), (int)12).asFloatBuffer();
            this.indexBuf = this.indexMemory.getBuffer().asIntBuffer();
            this.x = new float[ncoords];
            this.y = new float[ncoords];
            this.hx = new float[ncoords];
            this.hy = new float[ncoords];
            this.dx = new float[ncoords];
            this.dy = new float[ncoords];
            int index = 0;
            int yy = 0;
            while (yy <= WobblyPlaneEffect.this.tilesDown) {
                xx = 0;
                while (xx <= WobblyPlaneEffect.this.tilesAcross) {
                    this.hx[index] = (float)(xx * WobblyPlaneEffect.this.width) / (float)WobblyPlaneEffect.this.tilesAcross;
                    this.hy[index] = (float)(yy * WobblyPlaneEffect.this.height) / (float)WobblyPlaneEffect.this.tilesDown;
                    this.x[index] = this.hx[index];
                    this.y[index] = this.hy[index];
                    this.dx[index] = (float)(Math.random() * (double)WobblyPlaneEffect.this.acceleration * 2.0) - WobblyPlaneEffect.this.acceleration;
                    this.dy[index] = (float)(Math.random() * (double)WobblyPlaneEffect.this.acceleration * 2.0) - WobblyPlaneEffect.this.acceleration;
                    this.vertexBuf.position((index << 3) + 3);
                    this.vertexBuf.put((float)xx / (float)WobblyPlaneEffect.this.tilesAcross);
                    this.vertexBuf.put((float)(WobblyPlaneEffect.this.tilesDown - yy) / (float)WobblyPlaneEffect.this.tilesDown);
                    ++index;
                    ++xx;
                }
                ++yy;
            }
            yy = 0;
            while (yy < WobblyPlaneEffect.this.tilesDown) {
                xx = 0;
                while (xx < WobblyPlaneEffect.this.tilesAcross) {
                    this.indexBuf.put(this.index(xx, yy));
                    this.indexBuf.put(this.index(xx + 1, yy));
                    this.indexBuf.put(this.index(xx + 1, yy + 1));
                    this.indexBuf.put(this.index(xx, yy));
                    this.indexBuf.put(this.index(xx + 1, yy + 1));
                    this.indexBuf.put(this.index(xx, yy + 1));
                    ++xx;
                }
                ++yy;
            }
            this.vertexBuf.flip();
            this.indexBuf.flip();
            if (GLContext.getCapabilities().GL_NV_vertex_array_range || GLContext.getCapabilities().GL_NV_vertex_array_range2) {
                this.fence = new GLFence();
                this.fence.create();
            }
        }

        protected void doRemove() {
            this.vertexMemory.destroy();
            this.indexMemory.destroy();
            if (this.fence != null) {
                this.fence.destroy();
                this.fence = null;
            }
        }

        private void accelerate(int x, int y, int ax, int ay) {
            int i;
            if (x < 0 || x >= WobblyPlaneEffect.this.tilesAcross || y < 0 || y >= WobblyPlaneEffect.this.tilesDown) {
                return;
            }
            int n = i = this.index(x, y);
            this.dx[n] = this.dx[n] + (float)ax;
            int n2 = i;
            this.dy[n2] = this.dy[n2] + (float)ay;
            float len = (float)Math.sqrt(this.dx[i] * this.dx[i] + this.dy[i] * this.dy[i]);
            if (len > WobblyPlaneEffect.this.maxSpeed) {
                this.dx[i] = WobblyPlaneEffect.this.maxSpeed * (this.dx[i] / len);
                this.dy[i] = WobblyPlaneEffect.this.maxSpeed * (this.dy[i] / len);
            }
        }

        protected void doTick() {
            int dx = FluxMouse.getDY();
            int dy = FluxMouse.getDX();
            if (dx != 0 || dy != 0) {
                float mousex = FluxMouse.getX();
                float mousey = FluxMouse.getY();
                float left = FPMath.floatValue((int)this.position.getX()) - (float)WobblyPlaneEffect.this.width / 2.0f;
                float bottom = FPMath.floatValue((int)this.position.getY()) - (float)WobblyPlaneEffect.this.height / 2.0f;
                float right = FPMath.floatValue((int)this.position.getX()) + (float)WobblyPlaneEffect.this.width / 2.0f;
                float top = FPMath.floatValue((int)this.position.getY()) + (float)WobblyPlaneEffect.this.height / 2.0f;
                if (mousex >= left && mousex <= right && mousey >= bottom && mousey <= top) {
                    mousex -= left;
                    mousey -= bottom;
                    mousex = mousex / (float)WobblyPlaneEffect.this.width * (float)WobblyPlaneEffect.this.tilesAcross;
                    mousey = mousey / (float)WobblyPlaneEffect.this.height * (float)WobblyPlaneEffect.this.tilesDown;
                    mousex = Math.min((float)WobblyPlaneEffect.this.tilesAcross, Math.max(0.0f, mousex));
                    mousey = Math.min((float)WobblyPlaneEffect.this.tilesDown, Math.max(0.0f, mousey));
                    this.accelerate((int)mousex, (int)mousey, dx, dy);
                    this.accelerate((int)mousex - 1, (int)mousey, dx >> 1, dy >> 1);
                    this.accelerate((int)mousex + 1, (int)mousey, dx >> 1, dy >> 1);
                    this.accelerate((int)mousex, (int)mousey - 1, dx >> 1, dy >> 1);
                    this.accelerate((int)mousex, (int)mousey + 1, dx >> 1, dy >> 1);
                    this.accelerate((int)mousex - 1, (int)mousey - 1, dx >> 2, dy >> 2);
                    this.accelerate((int)mousex + 1, (int)mousey - 1, dx >> 2, dy >> 2);
                    this.accelerate((int)mousex - 1, (int)mousey + 1, dx >> 2, dy >> 2);
                    this.accelerate((int)mousex + 1, (int)mousey + 1, dx >> 2, dy >> 2);
                }
            }
            this.wobble();
            this.wibble();
            if (this.fence != null) {
                this.fence.finish();
            }
            int yy = 0;
            while (yy <= WobblyPlaneEffect.this.tilesDown) {
                int xx = 0;
                while (xx <= WobblyPlaneEffect.this.tilesAcross) {
                    int index = this.index(xx, yy);
                    this.vertexBuf.position(index << 3);
                    this.vertexBuf.put(this.x[index]);
                    this.vertexBuf.put(this.y[index]);
                    ++xx;
                }
                ++yy;
            }
            this.vertexBuf.rewind();
        }

        public boolean isVisible() {
            return true;
        }

        public void render() {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2884);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            GL11.glPushMatrix();
            try {
                GL11.glTranslatef((float)(FPMath.floatValue((int)this.position.getX()) - (float)WobblyPlaneEffect.this.width / 2.0f), (float)(FPMath.floatValue((int)this.position.getY()) - (float)WobblyPlaneEffect.this.height / 2.0f), (float)0.0f);
                GL11.glEnableClientState((int)32884);
                GL11.glEnableClientState((int)32888);
                GL11.glVertexPointer((int)2, (int)32, (FloatBuffer)this.vertexBuf);
                GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)this.texCoordBuf);
                if (GLContext.getCapabilities().GL_NV_vertex_array_range2) {
                    GL11.glEnableClientState((int)34099);
                } else if (GLContext.getCapabilities().GL_NV_vertex_array_range) {
                    GL11.glEnableClientState((int)34077);
                }
                this.indexBuf.rewind();
                if (WobblyPlaneEffect.this.shadowTextureResource != null) {
                    WobblyPlaneEffect.this.shadowTextureResource.render();
                    GL11.glPushMatrix();
                    try {
                        GL11.glTranslatef((float)WobblyPlaneEffect.this.shadowXOffset, (float)WobblyPlaneEffect.this.shadowYOffset, (float)0.0f);
                        GL11.glColor4ub((byte)0, (byte)0, (byte)0, (byte)((byte)(Math.min(255, this.getTick() * WobblyPlaneEffect.this.fadeInSpeed) >> 1)));
                        GL11.glDrawElements((int)4, (IntBuffer)this.indexBuf);
                    }
                    finally {
                        GL11.glPopMatrix();
                    }
                }
                WobblyPlaneEffect.this.textureResource.render();
                GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)((byte)Math.min(255, this.getTick() * WobblyPlaneEffect.this.fadeInSpeed)));
                GL11.glDrawElements((int)4, (IntBuffer)this.indexBuf);
                if (this.fence != null) {
                    this.fence.set(34034);
                }
                if (GLContext.getCapabilities().GL_NV_vertex_array_range2) {
                    GL11.glDisableClientState((int)34099);
                } else if (GLContext.getCapabilities().GL_NV_vertex_array_range) {
                    GL11.glDisableClientState((int)34077);
                }
                GL11.glDisableClientState((int)32884);
                GL11.glDisableClientState((int)32888);
            }
            finally {
                GL11.glPopMatrix();
                GL11.glDisable((int)3553);
                GL11.glDisable((int)2884);
            }
        }

        private void wibble() {
            int yy = 1;
            while (yy < WobblyPlaneEffect.this.tilesDown) {
                int xx = 1;
                while (xx < WobblyPlaneEffect.this.tilesAcross) {
                    int thisIndex = this.index(xx, yy);
                    int i = 0;
                    while (i < 8) {
                        int idx = this.index(xx + Compass.dx[i], yy + Compass.dy[i]);
                        float xxx = this.x[idx] - this.x[thisIndex];
                        float yyy = this.y[idx] - this.y[thisIndex];
                        float distance = (float)Math.sqrt(xxx * xxx + yyy * yyy) * 5.0f;
                        int n = thisIndex;
                        this.dx[n] = this.dx[n] + (xxx /= distance);
                        int n2 = thisIndex;
                        this.dy[n2] = this.dy[n2] + (yyy /= distance);
                        ++i;
                    }
                    ++xx;
                }
                ++yy;
            }
        }

        private void wobble() {
            int yy = 0;
            while (yy <= WobblyPlaneEffect.this.tilesDown) {
                int xx = 0;
                while (xx <= WobblyPlaneEffect.this.tilesAcross) {
                    int index = this.index(xx, yy);
                    this.dx[index] = this.x[index] > this.hx[index] ? Math.max(-WobblyPlaneEffect.this.maxSpeed, this.dx[index] - WobblyPlaneEffect.this.acceleration) : Math.min(WobblyPlaneEffect.this.maxSpeed, this.dx[index] + WobblyPlaneEffect.this.acceleration);
                    this.dy[index] = this.y[index] > this.hy[index] ? Math.max(-WobblyPlaneEffect.this.maxSpeed, this.dy[index] - WobblyPlaneEffect.this.acceleration) : Math.min(WobblyPlaneEffect.this.maxSpeed, this.dy[index] + WobblyPlaneEffect.this.acceleration);
                    float len = (float)Math.sqrt(this.dx[index] * this.dx[index] + this.dy[index] * this.dy[index]);
                    this.dx[index] = (len - WobblyPlaneEffect.this.deceleration) * (this.dx[index] / len);
                    this.dy[index] = (len - WobblyPlaneEffect.this.deceleration) * (this.dy[index] / len);
                    int n = index;
                    this.x[n] = this.x[n] + this.dx[index];
                    int n2 = index;
                    this.y[n2] = this.y[n2] + this.dy[index];
                    this.x[index] = Math.max(this.hx[index] - WobblyPlaneEffect.this.range, Math.min(this.hx[index] + WobblyPlaneEffect.this.range, this.x[index]));
                    this.y[index] = Math.max(this.hy[index] - WobblyPlaneEffect.this.range, Math.min(this.hy[index] + WobblyPlaneEffect.this.range, this.y[index]));
                    ++xx;
                }
                ++yy;
            }
        }

        private int index(int xx, int yy) {
            return xx + yy * (WobblyPlaneEffect.this.tilesAcross + 1);
        }
    }
}

