/*
 * Decompiled with CFR 0.152.
 */
package xap.effects;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.lwjgl.opengl.GL11;
import xap.Blob;
import xap.Game;
import xap.SpecialEffect;
import xap.features.SpecialEffectFeature;

public final class RocketTargetingEffect
extends SpecialEffectFeature {
    public static final long serialVersionUID = 1L;
    private static final RocketTargetingEffect rocketTargetingEffect = new RocketTargetingEffect();
    private static final int DELAY_DURATION = 60;
    private static final int DURATION = 60;
    private static final float DURATIONF = 60.0f;
    private static final int ACQUIRED_DURATION = 60;
    private static final float SIZE = 512.0f;
    private static final int DELAY = 0;
    private static final int TARGETING = 1;
    private static final int ACQUIRED = 2;
    private static final int FINISHED = 3;

    private RocketTargetingEffect() {
    }

    protected SpecialEffectFeature.SpecialEffectInstance doSpawn() {
        return new RocketTargetingEffectInstance();
    }

    public static final SpecialEffect spawn(Blob blob) {
        RocketTargetingEffectInstance ret = (RocketTargetingEffectInstance)rocketTargetingEffect.spawn(blob.getPosition().getX(), blob.getPosition().getY(), 0, 0, 0, 0, false);
        ret.setBlob(blob);
        return ret;
    }

    private class RocketTargetingEffectInstance
    extends SpecialEffectFeature.SpecialEffectInstance {
        private final Vector3i currentPosition;
        private int phase;
        private Blob blob;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.effects.RocketTargetingEffect$RocketTargetingEffectInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        RocketTargetingEffectInstance() {
            super(RocketTargetingEffect.this);
            this.currentPosition = Game.getPlayer().getPosition(null);
        }

        private void setBlob(Blob blob) {
            this.blob = blob;
        }

        public boolean isVisible() {
            return this.blob.isCaptured() && this.phase != 3;
        }

        protected void doTick() {
            switch (this.phase) {
                case 0: {
                    if (this.getTick() <= 60) break;
                    this.phase = 1;
                    this.reset();
                }
                case 1: {
                    if (this.getTick() > 60) {
                        this.phase = 2;
                        this.reset();
                    } else {
                        int ratio = FPMath.fpValue((float)((float)this.getTick() / 60.0f));
                        Vector3i playerPos = Game.getPlayer().getPosition();
                        this.currentPosition.set(LinearInterpolator.instance.interpolate(playerPos.getX(), this.position.getX(), ratio), LinearInterpolator.instance.interpolate(playerPos.getY(), this.position.getY(), ratio), 0);
                        break;
                    }
                }
                case 2: {
                    if (this.getTick() > 60) {
                        this.phase = 2;
                        this.reset();
                        break;
                    }
                    this.phase = 3;
                }
                case 3: {
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        public void render() {
            switch (this.phase) {
                case 0: 
                case 3: {
                    return;
                }
                case 1: {
                    this.renderTargeting();
                    break;
                }
                case 2: {
                    this.renderAcquired();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private void renderAcquired() {
        }

        private void renderTargeting() {
            GL11.glColor4ub((byte)-1, (byte)50, (byte)50, (byte)-128);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            float size = 512.0f - (float)this.getTick() * 512.0f / 60.0f;
            float sizeTimes4 = 1024.0f;
            float x = FPMath.floatValue((int)this.currentPosition.getX());
            float y = FPMath.floatValue((int)this.currentPosition.getY());
            GL11.glLineWidth((float)3.0f);
            GL11.glLineStipple((int)4, (short)-3856);
            GL11.glEnable((int)2852);
            GL11.glBegin((int)1);
            float xx = FPMath.floatValue((int)this.position.getX());
            float yy = FPMath.floatValue((int)this.position.getY());
            GL11.glVertex2f((float)(xx - sizeTimes4), (float)yy);
            GL11.glVertex2f((float)(xx + sizeTimes4), (float)yy);
            GL11.glVertex2f((float)xx, (float)(yy - sizeTimes4));
            GL11.glVertex2f((float)xx, (float)(yy + sizeTimes4));
            GL11.glEnd();
            GL11.glDisable((int)2852);
            GL11.glBegin((int)2);
            GL11.glVertex2f((float)(x - size), (float)(y - size));
            GL11.glVertex2f((float)(x + size), (float)(y - size));
            GL11.glVertex2f((float)(x + size), (float)(y + size));
            GL11.glVertex2f((float)(x - size), (float)(y + size));
            GL11.glEnd();
            GL11.glLineWidth((float)1.0f);
            GL11.glBegin((int)2);
            GL11.glVertex2f((float)(x - (size += 64.0f)), (float)(y - size));
            GL11.glVertex2f((float)(x + size), (float)(y - size));
            GL11.glVertex2f((float)(x + size), (float)(y + size));
            GL11.glVertex2f((float)(x - size), (float)(y + size));
            GL11.glEnd();
        }
    }
}

