/*
 * Decompiled with CFR 0.152.
 */
package xap.effects;

import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.util.FPMath;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Rectangle;
import xap.FloatingLabel;
import xap.features.SpecialEffectFeature;

public final class LabelEffect
extends SpecialEffectFeature {
    public static final long serialVersionUID = 1L;
    private static final Color tempColor = new Color();
    private static final LabelEffect labelFeature = new LabelEffect();

    private LabelEffect() {
    }

    protected final SpecialEffectFeature.SpecialEffectInstance doSpawn() {
        return new LabelInstance();
    }

    public static FloatingLabel spawn(int x, int y, int vx, int vy, GLFont font, ColorSequenceResource colorSeq, String text, boolean foreground) {
        FloatingLabel ret = (FloatingLabel)labelFeature.spawn(x, y, 0, vx, vy, 0, foreground);
        ret.init(font, colorSeq, text);
        return ret;
    }

    private class LabelInstance
    extends SpecialEffectFeature.SpecialEffectInstance
    implements FloatingLabel,
    GLRenderable {
        private ColorSequenceResource colorSequence;
        private GLString string;
        private final Rectangle size;

        public LabelInstance() {
            super(LabelEffect.this);
            this.size = new Rectangle();
        }

        public void init(GLFont font, ColorSequenceResource colorSequence, String text) {
            this.colorSequence = colorSequence;
            this.string = new GLString(text.length());
            this.string.setFont(font);
            this.string.setText(text);
            this.string.layout();
            this.string.getBounds(this.size);
            this.position.set(this.position.getX() - FPMath.fpValue((int)(this.size.getWidth() >> 1)), this.position.getY() - FPMath.fpValue((int)(this.size.getHeight() >> 1)), 0);
        }

        public boolean isVisible() {
            return this.colorSequence.isLooped() || this.getTick() <= this.colorSequence.getDuration();
        }

        public void render() {
            this.colorSequence.getColor(this.getTick(), tempColor);
            this.string.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()));
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4ub((byte)tempColor.getRedByte(), (byte)tempColor.getGreenByte(), (byte)tempColor.getBlueByte(), (byte)((byte)(200 * tempColor.getAlpha() >> 8)));
            this.string.render();
            GL11.glDisable((int)3553);
        }

        protected void doTick() {
        }

        public String toString() {
            return "Label effect[" + this.string + "]";
        }
    }
}

