/*
 * Decompiled with CFR 0.152.
 */
package xap.background;

import com.shavenpuppy.jglib.Memory;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.vector.Vector3f;
import xap.background.BackgroundGeometry;

public class PlainGeometry
extends BackgroundGeometry {
    private static final int TEXCOORDS0_OFFSET = 12;
    private static final int TEXCOORDS0_OFFSET2 = 3;
    private static final int COLOR_OFFSET = 20;
    public static final int VERTEX_SIZE = 32;
    private static final int VERTEX_SHIFT = 5;
    private static final int VERTEX_SHIFT2 = 3;
    private final FloatBuffer vertexBuf;
    private final FloatBuffer texCoordsBuf;
    private final ByteBuffer colorBuf;

    public PlainGeometry(ByteBuffer buf) {
        this.vertexBuf = buf.asFloatBuffer();
        this.texCoordsBuf = Memory.chop((ByteBuffer)buf, (int)12).asFloatBuffer();
        this.colorBuf = Memory.chop((ByteBuffer)buf, (int)20);
    }

    public void setupVertexPointer() {
        this.vertexBuf.rewind();
        GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)this.vertexBuf);
    }

    public void setupTexCoordPointer() {
        this.texCoordsBuf.rewind();
        GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)this.texCoordsBuf);
    }

    public void setupColorPointer() {
        this.colorBuf.rewind();
        GL11.glColorPointer((int)3, (boolean)true, (int)32, (ByteBuffer)this.colorBuf);
    }

    public void getVertex(int v, Vector3f dest) {
        this.vertexBuf.position(v << 3);
        dest.load(this.vertexBuf);
    }

    public void setColor(int v, Color src) {
        this.colorBuf.position(v << 5);
        src.writeRGB(this.colorBuf);
    }

    public void write(int vertexIndex, BackgroundGeometry.Geometry geometry) {
        this.vertexBuf.position(vertexIndex << 3);
        geometry.writeVertexData(vertexIndex, this.vertexBuf);
        this.texCoordsBuf.position(vertexIndex << 3);
        geometry.writeTexCoordData(vertexIndex, this.texCoordsBuf);
    }
}

