/*
 * Decompiled with CFR 0.152.
 */
package xap.background;

import com.shavenpuppy.jglib.Memory;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;
import xap.background.BackgroundGeometry;

public class BumpMappedGeometry
extends BackgroundGeometry {
    private static final int TEXCOORDS0_OFFSET = 12;
    private static final int TEXCOORDS0_OFFSET2 = 3;
    private static final int NORMAL_OFFSET = 20;
    private static final int NORMAL_OFFSET2 = 5;
    public static final int VERTEX_SIZE = 32;
    private static final int VERTEX_SHIFT = 5;
    private static final int VERTEX_SHIFT2 = 3;
    private final FloatBuffer vertexBuf;
    private final FloatBuffer normalBuf;
    private final FloatBuffer texCoordsBuf;

    public BumpMappedGeometry(ByteBuffer buf) {
        this.vertexBuf = buf.asFloatBuffer();
        this.normalBuf = Memory.chop((ByteBuffer)buf, (int)20).asFloatBuffer();
        this.texCoordsBuf = Memory.chop((ByteBuffer)buf, (int)12).asFloatBuffer();
    }

    public void setupVertexPointer() {
        this.vertexBuf.rewind();
        GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)this.vertexBuf);
    }

    public void setupLightVectorPointer() {
        this.normalBuf.rewind();
        GL11.glTexCoordPointer((int)3, (int)32, (FloatBuffer)this.normalBuf);
    }

    public void setupTexCoordPointer() {
        this.texCoordsBuf.rewind();
        GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)this.texCoordsBuf);
    }

    public void getVertex(int v, Vector3f dest) {
        this.vertexBuf.position(v << 3);
        dest.load(this.vertexBuf);
    }

    public void setLightVector(int v, Vector3f src) {
        this.normalBuf.position(v << 3);
        this.normalBuf.put(src.x);
        this.normalBuf.put(src.y);
        this.normalBuf.put(src.z);
    }

    public void write(int vertexIndex, BackgroundGeometry.Geometry geometry) {
        this.vertexBuf.position(vertexIndex << 3);
        geometry.writeVertexData(vertexIndex, this.vertexBuf);
        this.texCoordsBuf.position(vertexIndex << 3);
        geometry.writeTexCoordData(vertexIndex, this.texCoordsBuf);
    }
}

