/*
 * Decompiled with CFR 0.152.
 */
package xap;

import com.shavenpuppy.jglib.MultiBuffer;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.GLFrustum;
import com.shavenpuppy.jglib.opengl.nvidia.NvidiaInitializer;
import com.shavenpuppy.jglib.sound.OggVorbis;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.BrowserControl;
import com.shavenpuppy.jglib.util.CheckOnline;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.rmi.Naming;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.prefs.Preferences;
import net.puppygames.gamecommerce.shared.GameInfo;
import net.puppygames.gamecommerce.shared.GameInfoServerRemote;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import org.lwjgl.util.Display;
import org.lwjgl.util.Timer;
import xap.Bindings;
import xap.Configuration;
import xap.GameMode;
import xap.Gidrah;
import xap.MainDialog;
import xap.Options;
import xap.Player;
import xap.SplashScreen;
import xap.Support;
import xap.features.BackgroundFeature;
import xap.features.GamePanelFeature;
import xap.features.GidrahFeature;
import xap.features.MainDialogFeature;
import xap.features.PlayerFeature;
import xap.features.PowerupFeature;
import xap.features.SpecialEffectFeature;
import xap.gui.ConsoleListener;
import xap.gui.Interface;
import xap.gui.MessageBox;
import xap.gui.MessageBoxListener;
import xap.menu.LoadingDialog;
import xap.menu.NagWindow;
import xap.particles.PointParticleFeature;

public final class Game {
    public static final String EMAIL_ADDRESS = "support@puppygames.net";
    public static final String WEBSITE = "www.puppygames.net";
    public static final String GAME_TITLE = "Alien Flux";
    public static final String GAME_VERSION = "1.6";
    public static final String GAME_PRICE = "$19.95";
    private static final String DEFAULT_AFFILIATE;
    public static final boolean DEBUG = false;
    private static boolean windowed;
    private static final boolean REGISTERED = false;
    private static boolean running;
    private static boolean registered;
    private static final Preferences PREFS;
    private static long installation;
    private static boolean dirPrefixExists;
    private static String dirPrefix;
    public static boolean CHEAPASS;
    private static final String RESOURCES_FILE = "/resources.dat";
    private static final String OPTIONS_FILE;
    private static final String BINDINGS_FILE;
    private static final String GAMEINFO_FILE;
    private static String affiliate;
    public static final int WIDTH = 800;
    public static final int HEIGHT = 600;
    private static final int MAX_LOGFILE_LENGTH = 65536;
    private static final String LOGFILE;
    private static final String ERRLOGFILE;
    private static Options options;
    private static GameInfo gameInfo;
    private static boolean splashShown;
    private static int width;
    private static int height;
    public static NumberFormat fmt;
    private static MainDialog mainDialog;
    private static boolean finished;
    private static RegistrationDetails registrationDetails;
    public static float fps;
    public static float frameTime;
    private static SoundPlayer soundPlayer;
    private static GLFrustum frustum;
    private static int phase;
    private static GameMode gameMode;
    private static Configuration configuration;
    private static float musicVolume;
    private static final Timer allTime;
    private static final int TITLE_SCREEN = 0;
    private static final int PLAY_GAME = 1;
    public static boolean developer;
    public static boolean showFPS;
    private static boolean cheese;
    private static boolean paused;
    private static boolean reInitialise;
    private static SoundEffect music;
    private static long timeThen;
    private static long timeNow;
    private static long timeLate;
    static boolean inException;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        File settingsDir;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        try {
            Locale.setDefault(Locale.ENGLISH);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_AFFILIATE = System.getProperty("affiliate", "puppygames");
        windowed = Boolean.getBoolean("xap.windowed");
        running = false;
        registered = false;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("xap.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((installation = (PREFS = Preferences.userNodeForPackage(clazz2)).getLong("installation", 0L)) == 0L) {
            installation = (long)(Math.random() * 9.223372036854776E18);
            PREFS.putLong("installation", installation);
        }
        dirPrefixExists = !(settingsDir = new File(System.getProperty("workdir", String.valueOf(Game.getSettingsDir()) + File.separator + GAME_TITLE + ' ' + GAME_VERSION))).exists() ? settingsDir.mkdir() : true;
        dirPrefix = dirPrefixExists ? String.valueOf(System.getProperty("workdir", String.valueOf(Game.getSettingsDir()) + File.separator + GAME_TITLE + ' ' + GAME_VERSION)) + File.separator : Game.getSettingsDir();
        CHEAPASS = false;
        OPTIONS_FILE = String.valueOf(dirPrefix) + "options.dat";
        BINDINGS_FILE = String.valueOf(dirPrefix) + "bindings.dat";
        GAMEINFO_FILE = String.valueOf(dirPrefix) + "log2.dat";
        LOGFILE = String.valueOf(dirPrefix) + GAME_TITLE + ".log";
        ERRLOGFILE = String.valueOf(dirPrefix) + GAME_TITLE + "_err.log";
        options = null;
        try {
            fmt = new DecimalFormat();
            fmt.setMaximumFractionDigits(1);
            fmt.setMinimumFractionDigits(1);
            fmt.setGroupingUsed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        allTime = new Timer();
        inException = false;
    }

    private Game() {
    }

    private static String getSettingsDir() {
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            return String.valueOf(System.getProperty("user.home", "")) + "/Library";
        }
        return System.getProperty("user.home", "");
    }

    public static void sync3(int fps) {
        long gapTo = Sys.getTimerResolution() / (long)fps + timeThen;
        timeNow = Sys.getTime();
        while (gapTo > timeNow + timeLate) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeNow = Sys.getTime();
        }
        timeLate = gapTo < timeNow ? timeNow - gapTo : 0L;
        timeThen = timeNow;
    }

    public static void main(String[] arguments) {
        running = true;
        try {
            try {
                affiliate = PREFS.get("affiliate", "");
                if (affiliate.equals("")) {
                    try {
                        try {
                            FileReader fr = new FileReader("affiliate.id");
                            BufferedReader br = new BufferedReader(fr);
                            affiliate = br.readLine();
                            fr.close();
                        }
                        catch (Exception fr) {}
                    }
                    finally {
                        if (affiliate == null || "".equals(affiliate.trim())) {
                            affiliate = DEFAULT_AFFILIATE;
                        }
                    }
                    PREFS.put("affiliate", affiliate);
                }
                Calendar compileDate = Calendar.getInstance();
                compileDate.set(5, 11);
                compileDate.set(2, 2);
                compileDate.set(1, 2005);
                Calendar todaysDate = Calendar.getInstance();
                todaysDate.add(2, -6);
                int lastCheck = PREFS.getInt("lastdatecheck", 0);
                if (lastCheck <= 0 && todaysDate.after(compileDate)) {
                    PREFS.putInt("lastdatecheck", 10);
                    Sys.alert((String)"Old Version Warning", (String)"The version of Alien Flux you are about to play is over six months old! Please check www.puppygames.net for an updated version with new features and bug fixes.");
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                BrowserControl.openURL((String)"http://www.puppygames.net");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    PREFS.putInt("lastdatecheck", lastCheck - 1);
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        Game.close(false);
                    }
                });
                boolean wasBadExit = PREFS.getBoolean("badexit", false);
                byte[] cfg = PREFS.getByteArray("configuration", null);
                if (cfg == null) {
                    configuration = new Configuration();
                    configuration.init();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(configuration);
                    oos.flush();
                    cfg = baos.toByteArray();
                    PREFS.putByteArray("configuration", cfg);
                    oos.close();
                } else {
                    ByteArrayInputStream bais = new ByteArrayInputStream(cfg);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    configuration = (Configuration)ois.readObject();
                    ois.close();
                }
                gameInfo = new GameInfo(GAME_TITLE, GAME_VERSION, affiliate, installation, wasBadExit, org.lwjgl.opengl.Display.getAdapter(), org.lwjgl.opengl.Display.getVersion(), configuration.encode());
                System.setOut(Game.redirectOutput(System.out, LOGFILE));
                System.setErr(Game.redirectOutput(System.err, ERRLOGFILE));
                System.out.println("Starting Alien Flux 1.6");
                if (wasBadExit) {
                    Sys.alert((String)GAME_TITLE, (String)"Alien Flux did not shut down correctly last time you tried to play.\nIf you are experiencing problems or bugs please contact support@puppygames.net\nand tell us!");
                    Support.doSupport("crash");
                }
                PREFS.putBoolean("badexit", true);
                Game.loadOptions();
                OggVorbis.setCacheDirectory((String)dirPrefix);
                Game.init();
                int frames = 0;
                Timer timer = new Timer();
                Timer checkTime = new Timer();
                Timer escTime = new Timer();
                boolean f6WasDown = false;
                boolean pWasDown = false;
                boolean escWasDown = false;
                boolean flagPerformanceProblem = false;
                Game.playMusic((ALBuffer)Resources.get((String)"titlescreenloop.buffer"), 30);
                Game.checkRegistrationDetails();
                String glvendor = GL11.glGetString((int)7936);
                String glrenderer = GL11.glGetString((int)7937);
                String glversion = GL11.glGetString((int)7938);
                String gldriver = null;
                int i = glversion.indexOf(32);
                if (i != -1) {
                    gldriver = glversion.substring(i + 1);
                    glversion = glversion.substring(0, i);
                }
                gameInfo.update(glvendor, glrenderer, glversion, gldriver, registrationDetails);
                mainDialog.openMainMenu();
                while (!finished) {
                    Timer.tick();
                    org.lwjgl.opengl.Display.update();
                    Game.sync3(options.getFrequency());
                    if (reInitialise) {
                        Game.init();
                        if (AL.isCreated()) {
                            Game.playMusic((ALBuffer)Resources.get((String)"titlescreenloop.buffer"), 30);
                        }
                    }
                    if (!org.lwjgl.opengl.Display.isActive()) {
                        Thread.sleep(200L);
                        continue;
                    }
                    if (org.lwjgl.opengl.Display.isCloseRequested()) {
                        finished = true;
                    }
                    if (!cheese) {
                        try {
                            Interface.tick();
                            GL11.glClear((int)16384);
                            Interface.render();
                            Resources.manage();
                        }
                        catch (Throwable e) {
                            Game.handleException(e);
                        }
                    } else if (org.lwjgl.opengl.Display.isDirty()) {
                        Interface.render();
                    }
                    if (Keyboard.isCreated() && Keyboard.isKeyDown((int)64)) {
                        if (!f6WasDown) {
                            f6WasDown = true;
                            Game.screenshot();
                        }
                    } else {
                        f6WasDown = false;
                    }
                    if (Bindings.isPauseDown() && mainDialog.isActive()) {
                        if (!pWasDown) {
                            pWasDown = true;
                            cheese = !cheese;
                        }
                    } else {
                        pWasDown = false;
                    }
                    if (Bindings.isQuitDown() && !Game.isPaused()) {
                        if (!escWasDown) {
                            escWasDown = true;
                            if (!Game.isGameOver()) {
                                Game.setPaused(true);
                                new MessageBox("End Game", "Are you sure you want to end the current game?", 0, 2, new MessageBoxListener(){

                                    public void messageBoxChoiceMade(MessageBox mbox, int choice) {
                                        Game.setPaused(false);
                                        switch (choice) {
                                            case 0: {
                                                Game.gameOver();
                                                break;
                                            }
                                            case 1: {
                                                break;
                                            }
                                            default: {
                                                if (!$assertionsDisabled) {
                                                    throw new AssertionError();
                                                }
                                                break;
                                            }
                                        }
                                    }
                                }).open();
                            }
                        }
                    } else {
                        escWasDown = false;
                    }
                    if (Bindings.isQuitDown()) {
                        if (escTime.getTime() > 0.5f) {
                            finished = true;
                        }
                    } else {
                        escTime.reset();
                    }
                    if (flagPerformanceProblem && phase == 0) {
                        flagPerformanceProblem = false;
                        options.recommendFasterConfiguration();
                    }
                    frameTime = 0.0f;
                    if (org.lwjgl.opengl.Display.isDirty() || !cheese) {
                        GL11.glFlush();
                    }
                    if (Game.hasSound()) {
                        soundPlayer.play();
                    }
                    if (cheese) continue;
                    ++frames;
                    float time = timer.getTime();
                    if (time >= 1.0f) {
                        fps = (int)((float)frames / time);
                        timer.reset();
                        frames = 0;
                    }
                    if (!Keyboard.isCreated() || !Keyboard.isKeyDown((int)54) || LWJGLUtil.DEBUG) {
                        // empty if block
                    }
                    if (fps < (float)options.getFrequency() * 0.75f && checkTime.getTime() > 12.0f && allTime.getTime() > 200.0f && phase == 1) {
                        flagPerformanceProblem = true;
                        checkTime.reset();
                        continue;
                    }
                    if (!(fps >= (float)options.getFrequency() * 0.75f)) continue;
                    checkTime.reset();
                }
            }
            catch (Throwable t) {
                System.err.println(t.getMessage());
                gameInfo.setException(t);
                t.printStackTrace(System.err);
            }
        }
        finally {
            Game.close(true);
        }
    }

    private static void init() throws Exception {
        block27: {
            DisplayMode[] dm;
            Game.cleanup();
            reInitialise = false;
            if (!AL.isCreated()) {
                try {
                    AL.create();
                    soundPlayer = new SoundPlayer(16);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    gameInfo.setException((Throwable)e);
                    Sys.alert((String)GAME_TITLE, (String)"You need an OpenAL compatible sound card to to hear the sound effects and music in Alien Flux.\nYou may have a suitable card but not have appropriate drivers. Please contact support@puppygames.net\nfor assistance or visit our website if you need help finding drivers for your sound card.");
                }
            }
            if (!windowed) {
                try {
                    dm = Display.getAvailableDisplayModes((int)640, (int)480, (int)-1, (int)-1, (int)-1, (int)-1, (int)60, (int)85);
                    Display.setDisplayMode((DisplayMode[])dm, (String[])new String[]{"width=" + options.getPreferredWidth(), "height=" + options.getPreferredHeight(), "freq=60", "bpp=" + (options.isTrueColour() ? "32" : "16")});
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    windowed = true;
                }
            }
            org.lwjgl.opengl.Display.setTitle((String)GAME_TITLE);
            if (windowed) {
                org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(800, 600));
                org.lwjgl.opengl.Display.create();
            } else {
                try {
                    if (System.getProperty("os.name").startsWith("Mac OS")) {
                        if (System.getProperty("os.version").startsWith("10.2")) {
                            windowed = true;
                            org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(800, 600));
                        } else {
                            try {
                                dm = Display.getAvailableDisplayModes((int)640, (int)480, (int)-1, (int)-1, (int)-1, (int)-1, (int)60, (int)85);
                                Display.setDisplayMode((DisplayMode[])dm, (String[])new String[]{"width=800", "height=600", "freq=60", "bpp=" + org.lwjgl.opengl.Display.getDisplayMode().getBitsPerPixel()});
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                                windowed = true;
                                org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(800, 600));
                            }
                        }
                        org.lwjgl.opengl.Display.setFullscreen((!windowed ? 1 : 0) != 0);
                        org.lwjgl.opengl.Display.create();
                        break block27;
                    }
                    org.lwjgl.opengl.Display.setFullscreen((boolean)true);
                    org.lwjgl.opengl.Display.create();
                    try {
                        dm = Display.getAvailableDisplayModes((int)640, (int)480, (int)-1, (int)-1, (int)-1, (int)-1, (int)60, (int)85);
                        Display.setDisplayMode((DisplayMode[])dm, (String[])new String[]{"width=800", "height=600", "freq=60", "bpp=" + org.lwjgl.opengl.Display.getDisplayMode().getBitsPerPixel()});
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        windowed = true;
                        org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)new DisplayMode(800, 600));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Game.cleanup();
                    gameInfo.setException((Throwable)e);
                    Sys.alert((String)GAME_TITLE, (String)"You need to download new graphics card drivers to run Alien Flux\nPlease contact support@puppygames.net for assistance or visit our website\nif you need help finding new drivers.");
                    Support.doSupport("opengl");
                    Game.close(true);
                }
            }
        }
        NvidiaInitializer.initialize((int)0x800000, (int)0);
        GL11.glViewport((int)0, (int)0, (int)org.lwjgl.opengl.Display.getDisplayMode().getWidth(), (int)org.lwjgl.opengl.Display.getDisplayMode().getHeight());
        Mouse.setGrabbed((boolean)true);
        options.apply();
        if (org.lwjgl.opengl.Display.getDisplayMode().getFrequency() == 60 && !LWJGLUtil.DEBUG && !GL11.glGetString((int)7936).equals("Matrox Graphics Inc.")) {
            org.lwjgl.opengl.Display.setVSyncEnabled((boolean)true);
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)800.0f, (float)0.0f, (float)600.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        width = org.lwjgl.opengl.Display.getDisplayMode().getWidth();
        height = org.lwjgl.opengl.Display.getDisplayMode().getHeight();
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        if (!splashShown) {
            try {
                new SplashScreen();
                splashShown = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.load((InputStream)new BufferedInputStream(clazz.getResourceAsStream(RESOURCES_FILE)));
        }
        catch (Exception e) {
            Sys.alert((String)GAME_TITLE, (String)"Can't load the resources file! Your installation is corrupted.");
            e.printStackTrace();
            gameInfo.setException((Throwable)e);
            Game.cleanup();
            Game.close(true);
        }
        Game.loadBindings();
        Interface.init();
        if (AL.isCreated()) {
            soundPlayer.create();
        }
        frustum = new GLFrustum();
        mainDialog = MainDialogFeature.spawn();
        Interface.addConsoleListener(new XAPConsoleListener());
        PointParticleFeature.init();
        BackgroundFeature.init();
        options.apply();
        allTime.reset();
        allTime.resume();
    }

    public static void finish() {
        finished = true;
    }

    private static void cleanup() {
        PointParticleFeature.cleanup();
        BackgroundFeature.cleanup();
        SpecialEffectFeature.removeAllEffects();
        mainDialog = null;
        Interface.cleanup();
        if (soundPlayer != null) {
            soundPlayer.destroy();
        }
        Resources.clear();
        NvidiaInitializer.cleanup();
        if (AL.isCreated()) {
            AL.destroy();
        }
        if (org.lwjgl.opengl.Display.isCreated()) {
            try {
                Resources.manage();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            org.lwjgl.opengl.Display.destroy();
        }
        System.gc();
    }

    public static void buy() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    String page = "http://www.puppygames.net/purchase/buy.php?game=" + URLEncoder.encode(Game.GAME_TITLE, "utf-8") + "&configuration=" + URLEncoder.encode(configuration.encode(), "utf-8") + "&installation=" + URLEncoder.encode(String.valueOf(installation), "utf-8");
                    BrowserControl.openURL((String)page);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    Sys.alert((String)"How To Buy Alien Flux", (String)"Please open your web browser on the page http://www.puppygames.net/purchase");
                }
            }
        });
        Game.close(true);
    }

    public static void beginNewGame(GameMode gameMode) {
        if (!$assertionsDisabled && phase != 0) {
            throw new AssertionError();
        }
        try {
            if (!Game.isRegistered()) {
                int played = PREFS.getInt("played1.6", 0);
                played ^= 0xAF6AD755;
                played = played >> 16 & 0xFFFF | played << 16;
                if ((played ^= 0xCCCCCABE) == 463037908) {
                    played = 0;
                }
                int tix = PREFS.getInt("tix", 0);
                if (played < 0 || (played > configuration.getMaxGames() && configuration.getMaxGames() > 0 || configuration.getMaxGames() == 0) && (tix > configuration.getMaxTime() && configuration.getMaxTime() > 0 || configuration.getMaxTime() == 0)) {
                    try {
                        new NagWindow("Your demo has expired!", "Maybe later...", null).open();
                    }
                    catch (Exception e) {
                        Game.handleException(e);
                    }
                    return;
                }
                ++played;
                played ^= 0xCCCCCABE;
                played = played >> 16 & 0xFFFF | played << 16;
                PREFS.putInt("played1.6", played ^= 0xAF6AD755);
            }
            Game.gameMode = gameMode;
            gameInfo.onNewGame();
            new LoadingDialog().open();
            phase = 1;
        }
        catch (Exception e) {
            Game.handleException(e);
        }
    }

    public static boolean isNewGameAllowed() {
        if (Game.isRegistered()) {
            return true;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(clazz);
        int played = prefs.getInt("played1.6", 0);
        played ^= 0xAF6AD755;
        played = played >> 16 & 0xFFFF | played << 16;
        if ((played ^= 0xCCCCCABE) == 463037908) {
            played = 0;
        }
        int tix = prefs.getInt("tix", 0);
        return played >= 0 && (played <= configuration.getMaxGames() || configuration.getMaxGames() <= 0) || tix <= configuration.getMaxTime() || configuration.getMaxTime() <= 0;
    }

    public static void endLevel() {
        if (!$assertionsDisabled && phase != 1) {
            throw new AssertionError();
        }
        try {
            gameMode.doEndLevel();
        }
        catch (Exception e) {
            Game.handleException(e);
        }
    }

    public static void handleException(final Throwable throwable) {
        Interface.setIgnoreInput(false);
        try {
            if (inException) {
                throw new Exception("An exception occurred whilst handling another exception.", throwable);
            }
            inException = true;
            final boolean wasPaused = Game.isPaused();
            Game.setPaused(true);
            throwable.printStackTrace(System.err);
            new MessageBox("Trouble", "An internal error has occurred. Please contact technical support on support@puppygames.net", 0, 0, new MessageBoxListener(){

                public void messageBoxChoiceMade(MessageBox mbox, int choice) {
                    Game.setPaused(wasPaused);
                    if (throwable instanceof Error && phase == 1) {
                        Game.gameOver();
                    }
                    inException = false;
                }
            }).open();
        }
        catch (Throwable t) {
            Sys.alert((String)GAME_TITLE, (String)"Whilst trying to display an error dialog for an internal error, another error occurred. Please contact technical support on support@puppygames.net");
            t.printStackTrace(System.err);
            System.err.println("The original error was:");
            throwable.printStackTrace(System.err);
            Game.close(true);
        }
    }

    public static void screenshot() throws Exception {
        MultiBuffer data = new MultiBuffer(Game.getWidth() * Game.getHeight() * 3);
        GL11.glReadBuffer((int)1028);
        GL11.glReadPixels((int)0, (int)0, (int)Game.getWidth(), (int)Game.getHeight(), (int)6407, (int)5121, (ByteBuffer)data.bytes);
        int i = 0;
        while (i < 99) {
            File f = new File(String.valueOf(i < 10 ? "screenshot0" : "screenshot") + i + ".raw");
            if (!f.exists()) {
                FileOutputStream fos = new FileOutputStream(f);
                byte[] buf = new byte[Game.getWidth() * Game.getHeight() * 3];
                data.bytes.get(buf);
                fos.write(buf);
                fos.flush();
                fos.close();
                System.out.println("Wrote screenshot:" + f.getName());
                break;
            }
            ++i;
        }
    }

    public static void gameOver() {
        if (!$assertionsDisabled && phase != 1) {
            throw new AssertionError();
        }
        Game.writeTix();
        try {
            gameMode.doGameOver();
        }
        catch (Exception e) {
            Game.handleException(e);
        }
    }

    public static void endDemo() {
        try {
            new NagWindow("Find out what happens next in Alien Flux!", "Maybe later...", null).open();
        }
        catch (Exception e) {
            Game.handleException(e);
        }
    }

    public static void endGame() {
        if (!$assertionsDisabled && phase != 1) {
            throw new AssertionError();
        }
        try {
            gameMode.doEndGame();
        }
        catch (Exception e) {
            Game.handleException(e);
        }
        phase = 0;
        if (AL.isCreated()) {
            try {
                Game.playMusic((ALBuffer)Resources.get((String)"titlescreenloop.buffer"), 180);
            }
            catch (Exception e) {
                Game.handleException(e);
            }
        }
    }

    public static Sprite allocateSprite(Object owner) {
        return mainDialog.allocateSprite(owner);
    }

    public static SoundEffect allocateSound(ALBuffer buf, Vector3i position, Vector3i velocity, Object owner) {
        if (!AL.isCreated()) {
            return null;
        }
        SoundEffect fx = soundPlayer.allocate(buf, owner);
        if (fx != null) {
            if (position != null) {
                fx.setPosition(FPMath.floatValue((int)position.getX()), FPMath.floatValue((int)position.getY()), FPMath.floatValue((int)position.getZ()), owner);
            }
            if (velocity != null) {
                fx.setVelocity(FPMath.floatValue((int)velocity.getX()), FPMath.floatValue((int)velocity.getY()), FPMath.floatValue((int)velocity.getZ()), owner);
            }
        }
        return fx;
    }

    public static SoundEffect allocateBackgroundSound(ALBuffer buf, Object owner) {
        if (!AL.isCreated()) {
            return null;
        }
        SoundEffect fx = soundPlayer.allocate(buf, owner);
        if (fx != null) {
            fx.setAttenuated(false, owner);
        }
        return fx;
    }

    public static void shake(int duration, int magnitude) {
        mainDialog.shake(duration, magnitude);
    }

    public static Options getOptions() {
        return options;
    }

    private static void loadOptions() {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            try {
                fis = new FileInputStream(OPTIONS_FILE);
                ois = new ObjectInputStream(fis);
                options = (Options)ois.readObject();
            }
            catch (Exception e) {
                options = new Options();
                options.defaultValues();
            }
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveOptions() {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            try {
                fos = new FileOutputStream(OPTIONS_FILE);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(options);
                oos.flush();
                fos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void setOptions(Options.Editor editor) {
        options.fromEditor(editor);
        Game.saveOptions();
        if (options.renderingParametersChanged()) {
            reInitialise = true;
        } else {
            options.apply();
        }
    }

    public static GLFrustum getFrustum() {
        return frustum;
    }

    public static int getWidth() {
        return width;
    }

    public static int getHeight() {
        return height;
    }

    public static void setPaused(boolean newPaused) {
        paused = newPaused;
    }

    public static boolean isPaused() {
        return paused;
    }

    public static boolean isGameOver() {
        return phase == 0 || phase == 1 && gameMode.isGameOver();
    }

    public static void loadBindings() {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            try {
                fis = new FileInputStream(BINDINGS_FILE);
                bis = new BufferedInputStream(fis);
                Bindings.load(bis);
            }
            catch (Exception e) {
                System.out.println("No bindings found, so creating default bindings.");
                Bindings.defaultBindings();
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void saveBindings() {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            try {
                fos = new FileOutputStream(BINDINGS_FILE);
                bos = new BufferedOutputStream(fos);
                Bindings.save(bos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void checkRegistrationDetails() throws Exception {
        Game.setRegistrationDetails(RegistrationDetails.checkRegistration((String)GAME_TITLE));
    }

    private static PrintStream redirectOutput(final PrintStream output, String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.equals("")) {
            return output;
        }
        boolean append = true;
        File outFile = new File(fileName);
        if (outFile.exists() && outFile.length() > 65536L) {
            outFile.renameTo(new File(String.valueOf(fileName) + ".old"));
            append = false;
        }
        return new PrintStream((OutputStream)new FileOutputStream(fileName, append)){

            public void println(String s) {
                this.print(new Date());
                this.print('\t');
                super.println(s);
                output.println(s);
            }
        };
    }

    public static RegistrationDetails getRegistrationDetails() {
        return registrationDetails;
    }

    public static boolean isRegistered() {
        return registered;
    }

    public static void setRegistrationDetails(RegistrationDetails registrationDetails) throws Exception {
        Game.registrationDetails = registrationDetails;
        if (registrationDetails != null) {
            registered = true;
            registrationDetails.toPreferences();
            mainDialog.updateRegistrationDetails(registrationDetails);
        }
    }

    public static void setMusicVolume(float volume) {
        musicVolume = volume;
        if (music != null && music.getBuffer() != null) {
            float f = music.getBuffer().getGain() * musicVolume;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            music.setGain(f, (Object)clazz);
        }
    }

    public static void setVolume(float volume) {
        if (AL.isCreated()) {
            AL10.alListenerf((int)4106, (float)volume);
        }
    }

    public static float getMusicVolume() {
        return musicVolume;
    }

    public static void playMusic(ALBuffer buf, int fade) {
        Class<?> clazz;
        boolean xfade;
        boolean bl = xfade = music != null;
        if (xfade) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("xap.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            music.setFade(fade, 0.0f, true, (Object)clazz2);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("xap.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((music = Game.allocateBackgroundSound(buf, clazz)) != null) {
            if (xfade) {
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("xap.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setGain(0.0f, (Object)clazz3);
                float f = buf.getGain() * musicVolume;
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$0 = Class.forName("xap.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setFade(fade, f, false, (Object)clazz4);
            } else {
                float f = buf.getGain() * musicVolume;
                Class<?> clazz5 = class$0;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$0 = Class.forName("xap.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                music.setGain(f, (Object)clazz5);
            }
        }
    }

    public static GameMode getGameMode() {
        return gameMode;
    }

    public static boolean hasSound() {
        return AL.isCreated();
    }

    public static boolean isRunning() {
        return running;
    }

    public static Player getPlayer() {
        if (!$assertionsDisabled && phase != 1) {
            throw new AssertionError();
        }
        return PlayerFeature.getPlayer();
    }

    public static int getCurrentLevel() {
        if (!$assertionsDisabled && phase != 1) {
            throw new AssertionError();
        }
        return gameMode.getCurrentLevel();
    }

    private static void writeTix() {
        int tix = PREFS.getInt("tix", 0);
        int newTix = GamePanelFeature.getTix() / 60;
        gameInfo.addTime(newTix);
        PREFS.putInt("tix", tix += newTix);
    }

    private static void writeLog() {
        if (gameInfo == null) {
            System.out.println("No game info log");
        }
        File log = new File(GAMEINFO_FILE);
        List<Object> logList = null;
        if (log.exists()) {
            ObjectInputStream ois = null;
            BufferedInputStream bis = null;
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(log);
                    bis = new BufferedInputStream(fis);
                    ois = new ObjectInputStream(bis);
                    logList = (List)ois.readObject();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    logList = new ArrayList(1);
                }
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
                ois = null;
                bis = null;
                fis = null;
            }
        } else {
            logList = new ArrayList<GameInfo>(1);
        }
        if (gameInfo != null) {
            Game.writeTix();
            logList.add(gameInfo);
        }
        boolean submitted = false;
        if (CheckOnline.isOnline()) {
            try {
                GameInfoServerRemote server = (GameInfoServerRemote)Naming.lookup("//puppygames.net/puppygames_gameinfo_server");
                server.submit(logList);
                submitted = true;
                log.delete();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        if (!submitted) {
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                try {
                    fos = new FileOutputStream(log);
                    bos = new BufferedOutputStream(fos);
                    oos = new ObjectOutputStream(bos);
                    oos.writeObject(logList);
                    oos.flush();
                    ((BufferedOutputStream)bos).flush();
                    fos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static void close(boolean doLog) {
        Class<?> clazz;
        if (AL.isCreated()) {
            AL.destroy();
        }
        if (Keyboard.isCreated()) {
            Keyboard.destroy();
        }
        if (Mouse.isCreated()) {
            Mouse.destroy();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("xap.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(clazz);
        prefs.putBoolean("badexit", false);
        if (org.lwjgl.opengl.Display.isCreated()) {
            org.lwjgl.opengl.Display.destroy();
        }
        if (doLog) {
            Game.writeLog();
            System.exit(0);
        }
    }

    public static String getAffiliate() {
        return affiliate;
    }

    public static long getInstallation() {
        return installation;
    }

    public static GameInfo getGameInfo() {
        return gameInfo;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    static /* synthetic */ GameMode access$1() {
        return gameMode;
    }

    private static class XAPConsoleListener
    implements ConsoleListener {
        XAPConsoleListener() {
        }

        /*
         * Unable to fully structure code
         */
        public void commandEntered(String[] args) {
            block47: {
                if (args.length != 0) ** GOTO lbl4
                return;
lbl-1000:
                // 1 sources

                {
                    args[0] = args[0].substring(1, args[0].length());
lbl4:
                    // 2 sources

                    ** while (args[0].startsWith((String)"`"))
                }
lbl5:
                // 1 sources

                if (args[0].equals("xyzzy")) {
                    if (Game.access$0() == 1) {
                        Game.access$1().invalidateScore();
                    }
                    Game.developer = Game.developer == false;
                    System.out.println("Developer mode: " + Game.developer);
                } else if (args[0].equals("fps")) {
                    Game.showFPS = Game.showFPS == false;
                } else if (args[0].equals("level")) {
                    if (Game.access$0() == 1) {
                        Game.access$1().invalidateScore();
                        try {
                            Game.access$1().setCurrentLevel(Integer.parseInt(args[1]) - 1);
                        }
                        catch (Exception e) {
                            Game.handleException(e);
                        }
                    }
                } else if (args[0].equals("give")) {
                    if (Game.access$0() == 1) {
                        Game.access$1().invalidateScore();
                    }
                    if (args.length < 2) {
                        System.out.println("Incorrect syntax: give <type> <number>");
                        return;
                    }
                    try {
                        if (args[1].equals("lives")) {
                            PlayerFeature.getPlayer().addLives(Integer.parseInt(args[2]));
                            break block47;
                        }
                        if (args[1].equals("smartbombs")) {
                            PlayerFeature.getPlayer().addSmartBombs(Integer.parseInt(args[2]));
                            break block47;
                        }
                        if (args[1].equals("score")) {
                            Game.access$1().addScore(Integer.parseInt(args[2]));
                            break block47;
                        }
                        if (args[1].equals("rockets")) {
                            PlayerFeature.getPlayer().addHomingRockets(Integer.parseInt(args[2]));
                            break block47;
                        }
                        System.out.println("Unknown thing: try lives, smartbombs, score, or blobs");
                    }
                    catch (Exception e) {
                        System.out.println("Incorrect syntax: give <type> <number>");
                        System.out.println("<type> may be one of lives, smartbombs, score, blobs, rockets");
                    }
                } else if (args[0].equals("test")) {
                    if (Game.access$0() == 1) {
                        Game.access$1().invalidateScore();
                    }
                    if (args.length < 2) {
                        System.out.println("Incorrect syntax: test <feature>");
                        return;
                    }
                    if (args[1].equals("powerups")) {
                        try {
                            PowerupFeature.test();
                        }
                        catch (Exception e) {
                            Game.handleException(e);
                        }
                    } else if (args[1].equals("gidrah")) {
                        if (args.length < 3) {
                            System.out.println("Incorrect syntax: test gidrah <gidrah>");
                            return;
                        }
                        try {
                            gf = (GidrahFeature)Resources.get((String)args[2]);
                            gidrah = (Gidrah)gf.spawn();
                            gidrah.resIn();
                        }
                        catch (Exception e) {
                            System.out.println("Can't spawn " + args[2]);
                            e.printStackTrace();
                        }
                    }
                } else if (args[0].equals("powerup")) {
                    if (Game.access$0() == 1) {
                        Game.access$1().invalidateScore();
                    }
                    if (args.length < 2) {
                        System.out.println("Incorrect syntax: powerup shield|laser|autofire");
                        return;
                    }
                    if (args[1].equals("shield")) {
                        PlayerFeature.getPlayer().powerupShield();
                    } else if (args[1].equals("laser")) {
                        PlayerFeature.getPlayer().powerupLaser();
                    } else if (args[1].equals("autofire")) {
                        PlayerFeature.getPlayer().powerupAutofire();
                    } else {
                        System.out.println("Unknown thing: try shield, laser, or autofire.");
                    }
                } else if (args[0].equals("gameover")) {
                    Game.gameOver();
                } else if (args[0].equals("cheapass")) {
                    Game.CHEAPASS = true;
                } else {
                    System.out.println("Unknown command '" + args[0] + "'");
                }
            }
        }
    }
}

