/*
 * Decompiled with CFR 0.152.
 */
package xap;

import org.lwjgl.input.Mouse;

public class FluxMouse {
    public static final int MAX_SENSITIVITY = 8;
    public static final int MIN_SENSITIVITY = 1;
    private static int sensitivity = 8;
    private static int width;
    private static int height;
    private static int x;
    private static int y;
    private static int scrollX;
    private static int scrollY;
    private static int dx;
    private static int dy;
    private static boolean trackingEnabled;

    static {
        trackingEnabled = true;
    }

    private FluxMouse() {
    }

    public static void poll() {
        int poll_dx = Mouse.getDX();
        int poll_dy = Mouse.getDY();
        dx += poll_dx;
        dy += poll_dy;
        if (trackingEnabled) {
            y += (poll_dy * sensitivity << 16) / 8;
            if ((x += (poll_dx * sensitivity << 16) / 8) < 0) {
                scrollX = x;
                x = 0;
            } else if (x >= width) {
                scrollX = x - width;
                x = width - 1;
            }
            if (y < 0) {
                scrollY = y;
                y = 0;
            } else if (y >= height) {
                scrollY = y - height;
                y = height - 1;
            }
        }
    }

    public static int getX() {
        return x >> 16;
    }

    public static int getY() {
        return y >> 16;
    }

    public static int getDX() {
        int result = dx;
        dx = 0;
        return result;
    }

    public static int getDY() {
        int result = dy;
        dy = 0;
        return result;
    }

    public static int getScrollX() {
        return scrollX >> 16;
    }

    public static int getScrollY() {
        return scrollY >> 16;
    }

    public static void setSensitivity(int newSensitivity) {
        sensitivity = Math.min(8, Math.max(1, newSensitivity));
    }

    public static int getSensitivity() {
        return sensitivity;
    }

    public static void setPosition(int newx, int newy) {
        x = Math.min(Math.max(0, newx << 16), width - 1);
        y = Math.min(Math.max(0, newy << 16), height - 1);
    }

    public static void setDimensions(int width, int height) {
        FluxMouse.width = width << 16;
        FluxMouse.height = height << 16;
        if (x >= FluxMouse.width) {
            x = FluxMouse.width - 1;
        }
        if (y >= FluxMouse.height) {
            y = FluxMouse.height - 1;
        }
    }

    public static void setTrackingEnabled(boolean enabled) {
        trackingEnabled = enabled;
    }

    public static boolean isTrackingEnabled() {
        return trackingEnabled;
    }
}

