/*
 * Decompiled with CFR 0.152.
 */
package xap;

import com.shavenpuppy.jglib.util.FPMath;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class Bindings {
    public static final long serialVersionUID = 1L;
    private static boolean enabled = true;
    private static int acceleration;
    private static int deceleration;
    private static boolean autoShield;
    private static boolean autoSmartBomb;
    private static boolean fixedEye;
    public static final int UNBOUND = 0;
    public static final int MOUSE = 1;
    public static final int KEYBOARD = 2;
    private static final HashMap bindingMap;
    private static final Binding THRUST_UP;
    private static final Binding THRUST_DOWN;
    private static final Binding THRUST_LEFT;
    private static final Binding THRUST_RIGHT;
    private static final Binding THRUST;
    private static final Binding SHOOT;
    private static final Binding SHIELDS;
    private static final Binding SMARTBOMB;
    private static final Binding PAUSE;
    private static final Binding QUIT;
    private static final Binding CONSOLE;
    private static final Binding[] BINDINGS;
    private static int NUM_BINDINGS;

    static {
        bindingMap = new HashMap();
        THRUST_UP = new Binding("Thrust Up");
        THRUST_DOWN = new Binding("Thrust Down");
        THRUST_LEFT = new Binding("Thrust Left");
        THRUST_RIGHT = new Binding("Thrust Right");
        THRUST = new Binding("Thrust to Target");
        SHOOT = new Binding("Shoot");
        SHIELDS = new Binding("Shields");
        SMARTBOMB = new Binding("Smartbomb");
        PAUSE = new Binding("Pause Game");
        QUIT = new Binding("Quit Game");
        CONSOLE = new Binding("Console");
        BINDINGS = new Binding[]{THRUST_UP, THRUST_DOWN, THRUST_LEFT, THRUST_RIGHT, THRUST, SHOOT, SHIELDS, SMARTBOMB, PAUSE, QUIT, CONSOLE};
        int i = 0;
        while (i < BINDINGS.length) {
            bindingMap.put(BINDINGS[i].name, BINDINGS[i]);
            ++i;
        }
        NUM_BINDINGS = LWJGLUtil.DEBUG ? BINDINGS.length : BINDINGS.length - 1;
    }

    public static void defaultBindings() {
        Bindings.THRUST_UP.init(2, 200);
        Bindings.THRUST_DOWN.init(2, 208);
        Bindings.THRUST_LEFT.init(2, 203);
        Bindings.THRUST_RIGHT.init(2, 205);
        Bindings.SHOOT.init(1, 0);
        Bindings.THRUST.init(1, 1);
        Bindings.SHIELDS.init(2, 46);
        Bindings.SMARTBOMB.init(2, 57);
        Bindings.PAUSE.init(2, 25);
        Bindings.QUIT.init(2, 1);
        Bindings.CONSOLE.init(2, 41);
        acceleration = FPMath.fpValue((float)0.55f);
        deceleration = FPMath.fpValue((float)0.05f);
        autoShield = false;
        autoSmartBomb = false;
        fixedEye = false;
        enabled = true;
        Bindings.validate();
    }

    public static boolean validate() {
        boolean ok = true;
        int i = 0;
        while (i < NUM_BINDINGS) {
            ok &= Bindings.BINDINGS[i].validate();
            ++i;
        }
        return ok;
    }

    public static void load(InputStream is) throws IOException {
        enabled = true;
        DataInputStream ois = new DataInputStream(is);
        int numBindings = ois.readInt();
        int i = 0;
        while (i < numBindings) {
            String name = ois.readUTF();
            int type = ois.readInt();
            int index = ois.readInt();
            Binding binding = (Binding)bindingMap.get(name);
            if (binding != null) {
                binding.init(type, index);
            }
            ++i;
        }
        acceleration = ois.readInt();
        deceleration = ois.readInt();
        autoShield = ois.readBoolean();
        autoSmartBomb = ois.readBoolean();
        fixedEye = ois.readBoolean();
        Bindings.validate();
    }

    public static void save(OutputStream os) throws IOException {
        enabled = true;
        DataOutputStream oos = new DataOutputStream(os);
        oos.writeInt(BINDINGS.length);
        int i = 0;
        while (i < BINDINGS.length) {
            oos.writeUTF(BINDINGS[i].name);
            oos.writeInt(BINDINGS[i].type);
            oos.writeInt(BINDINGS[i].index);
            ++i;
        }
        oos.writeInt(acceleration);
        oos.writeInt(deceleration);
        oos.writeBoolean(autoShield);
        oos.writeBoolean(autoSmartBomb);
        oos.writeBoolean(fixedEye);
    }

    public static void toEditor(Editor editor) throws Exception {
        int i = NUM_BINDINGS;
        while (--i >= 0) {
            editor.setBinding(BINDINGS[i]);
        }
        editor.setAcceleration(acceleration);
        editor.setDeceleration(deceleration);
        editor.setAutoShield(autoShield);
        editor.setAutoSmartBomb(autoSmartBomb);
        editor.setFixedEye(fixedEye);
    }

    public static void fromEditor(Editor editor) throws Exception {
        acceleration = editor.getAcceleration();
        deceleration = editor.getDeceleration();
        autoShield = editor.getAutoShield();
        autoSmartBomb = editor.getAutoSmartBomb();
        fixedEye = editor.getFixedEye();
    }

    public static boolean isThrustUpDown() {
        return enabled && THRUST_UP.isDown();
    }

    public static boolean isThrustDownDown() {
        return enabled && THRUST_DOWN.isDown();
    }

    public static boolean isThrustLeftDown() {
        return enabled && THRUST_LEFT.isDown();
    }

    public static boolean isThrustRightDown() {
        return enabled && THRUST_RIGHT.isDown();
    }

    public static boolean isThrustDown() {
        return enabled && THRUST.isDown();
    }

    public static boolean isShieldsDown() {
        return enabled && SHIELDS.isDown();
    }

    public static boolean isSmartbombDown() {
        return enabled && SMARTBOMB.isDown();
    }

    public static boolean isShootDown() {
        return enabled && SHOOT.isDown();
    }

    public static boolean isPauseDown() {
        return enabled && PAUSE.isDown();
    }

    public static boolean isQuitDown() {
        return enabled && QUIT.isDown();
    }

    public static boolean isConsoleDown() {
        return enabled && CONSOLE.isDown();
    }

    public static void setEnabled(boolean enabled) {
        Bindings.enabled = enabled;
    }

    public static int getAcceleration() {
        return acceleration;
    }

    public static int getDeceleration() {
        return deceleration;
    }

    public static boolean getAutoShield() {
        return autoShield;
    }

    public static boolean getAutoSmartBomb() {
        return autoSmartBomb;
    }

    public static boolean getFixedEye() {
        return fixedEye;
    }

    public static interface Editor {
        public void setBinding(Binding var1) throws Exception;

        public int getDeceleration();

        public int getAcceleration();

        public void setDeceleration(int var1);

        public void setAcceleration(int var1);

        public boolean getAutoShield();

        public boolean getAutoSmartBomb();

        public boolean getFixedEye();

        public void setAutoShield(boolean var1);

        public void setAutoSmartBomb(boolean var1);

        public void setFixedEye(boolean var1);
    }

    public static class Binding {
        public static final long serialVersionUID = 1L;
        private int type;
        private int index;
        private String name;
        private boolean valid;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.Bindings$Binding");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        private Binding(String name) {
            this.name = name;
        }

        public boolean isDown() {
            if (!this.valid) {
                return false;
            }
            switch (this.type) {
                case 0: {
                    return false;
                }
                case 1: {
                    return Mouse.isCreated() && Mouse.isButtonDown((int)this.index);
                }
                case 2: {
                    return Keyboard.isCreated() && Keyboard.isKeyDown((int)this.index);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }

        private void init(int type, int index) {
            this.type = type;
            this.index = index;
            this.valid = true;
            int i = 0;
            while (i < BINDINGS.length) {
                if (this != BINDINGS[i] && this.equals(BINDINGS[i])) {
                    BINDINGS[i].type = 0;
                }
                BINDINGS[i].validate();
                ++i;
            }
        }

        private boolean validate() {
            switch (this.type) {
                case 0: {
                    this.valid = false;
                    break;
                }
                case 1: {
                    this.valid = Mouse.isCreated() && this.index < Mouse.getButtonCount();
                    break;
                }
                case 2: {
                    this.valid = Keyboard.isCreated();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            return this.valid;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Binding && ((Binding)obj).index == this.index && ((Binding)obj).type == this.type;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            if (!this.valid) {
                return "???";
            }
            switch (this.type) {
                case 1: {
                    switch (this.index) {
                        case 0: {
                            return "Left Mouse Button";
                        }
                        case 1: {
                            return "Right Mouse Button";
                        }
                        case 2: {
                            return "Middle Mouse Button";
                        }
                    }
                    return "Mouse button " + (this.index + 1);
                }
                case 2: {
                    String kn = Keyboard.getKeyName((int)this.index);
                    if (kn == null) {
                        return "Unknown Key";
                    }
                    return "Key " + kn;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return "***";
        }

        public boolean determine() {
            int i;
            if (Mouse.isCreated()) {
                i = 0;
                while (i < Mouse.getButtonCount()) {
                    if (Mouse.isButtonDown((int)i)) {
                        this.init(1, i);
                        return true;
                    }
                    ++i;
                }
            }
            if (Keyboard.isCreated()) {
                i = 0;
                while (i < 256) {
                    if (Keyboard.isKeyDown((int)i)) {
                        this.init(2, i);
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

