/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.shared;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import net.puppygames.gamecommerce.shared.Luhn;

public final class CreditCard
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final String name;
    private final transient int[][] length;
    private final transient String[] prefix;
    private final transient boolean debit;
    public static final CreditCard MASTERCARD = new CreditCard("Mastercard", new String[]{"51", "52", "53", "54", "55"}, new int[][]{{16}, {16}, {16}, {16}, {16}}, false);
    public static final CreditCard VISA = new CreditCard("Visa", new String[]{"4"}, new int[][]{{13, 16}}, false);
    public static final CreditCard AMEX = new CreditCard("AMEX", new String[]{"34", "37"}, new int[][]{{15}, {15}}, false);
    public static final CreditCard DINERS = new CreditCard("Diners Club", new String[]{"300", "301", "302", "303", "304", "305", "36", "38"}, new int[][]{{14}, {14}, {14}, {14}, {14}, {14}, {14}, {14}}, false);
    public static final CreditCard JCB = new CreditCard("JCB", new String[]{"3", "2131", "1800"}, new int[][]{{16}, {15}, {15}}, false);
    public static final CreditCard CREDIT = new CreditCard("Credit card", new String[]{""}, new int[][]{{13, 14, 15, 16, 17, 18, 18, 20}}, false);
    public static final CreditCard DEBIT = new CreditCard("Debit card", new String[]{""}, new int[][]{{16, 17, 18, 18, 20}}, true);
    public static final CreditCard[] CARDS = new CreditCard[]{CREDIT, DEBIT};

    private CreditCard(String name, String[] prefix, int[][] length, boolean debit) {
        this.name = name;
        this.prefix = prefix;
        this.length = length;
        this.debit = debit;
    }

    private String getType() {
        return this.debit ? "debit" : "credit";
    }

    public final String validate(String number) {
        int i = 0;
        while (i < number.length()) {
            if (!Character.isDigit(number.charAt(i))) {
                return "The " + this.getType() + " card number should consist only of digits, with no spaces.";
            }
            ++i;
        }
        boolean prefixOK = false;
        int i2 = 0;
        while (i2 < this.prefix.length) {
            if (number.startsWith(this.prefix[i2])) {
                boolean lengthOK = false;
                int j = 0;
                while (j < this.length[i2].length) {
                    if (number.length() == this.length[i2][j]) {
                        lengthOK = true;
                    }
                    ++j;
                }
                if (!lengthOK) {
                    return "The " + this.getType() + " number is invalid. Please check the number carefully for mistakes.";
                }
                prefixOK = true;
                break;
            }
            ++i2;
        }
        if (!prefixOK) {
            return "The " + this.getType() + " number does not appear to be a " + this.name + " number.";
        }
        if (!Luhn.check(number)) {
            return "The " + this.getType() + " number is invalid. Please check the number carefully for mistakes.";
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        int i = 0;
        while (i < CARDS.length) {
            if (CreditCard.CARDS[i].name.equals(this.name)) {
                return CARDS[i];
            }
            ++i;
        }
        throw new InvalidObjectException("Unknown credit card type " + this.name);
    }

    public boolean isDebitCard() {
        return this.debit;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "[Card:" + this.getName() + "]";
    }
}

