/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.texgen;

import com.shavenpuppy.jglib.Image;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.InterpolatorBase;
import com.shavenpuppy.jglib.resources.ImageWrapper;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;

public class SpotlightImageResource
extends Resource
implements ImageWrapper {
    public static final long serialVersionUID = 1L;
    private int type;
    private int size;
    private String interpolator;
    private Image image;
    private Interpolator interpolatorInstance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.texgen.SpotlightImageResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SpotlightImageResource(String name) {
        super(name);
    }

    public SpotlightImageResource(String name, int size, int type, Interpolator interpolatorInstance) {
        super(name);
        this.size = size;
        this.type = type;
        this.interpolatorInstance = interpolatorInstance;
    }

    protected void doCreate() throws Exception {
        this.image = new Image(this.size, this.size, this.type);
        this.interpolatorInstance = InterpolatorBase.decode(this.interpolator);
        float sizeBy2 = (float)(this.size - 1) * 0.5f;
        int radius = this.size >> 1;
        int y = -radius;
        while (y < radius) {
            double yd = y * y;
            int x = -radius;
            while (x < radius) {
                float dist = (float)Math.sqrt((double)(x * x) + yd) / sizeBy2;
                int c = (int)this.interpolatorInstance.interpolate(255.0f, 0.0f, dist);
                this.image.getData().put((byte)(c <= 255 ? (int)c : -1));
                if (this.type == 3) {
                    this.image.getData().put((byte)(c <= 255 ? (int)c : -1));
                }
                ++x;
            }
            ++y;
        }
        this.image.getData().flip();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.size = XMLUtil.getInt(element, "size");
        this.interpolator = XMLUtil.getString(element, "interpolator");
        String stype = element.getAttribute("type");
        if (stype.equalsIgnoreCase("luminance")) {
            this.type = 2;
        } else if (stype.equalsIgnoreCase("alpha")) {
            this.type = 2;
        } else if (stype.equalsIgnoreCase("luminance_alpha")) {
            this.type = 3;
        }
    }

    public final Image getImage() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        return this.image;
    }
}

