/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.texgen;

import com.shavenpuppy.jglib.Image;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.InterpolatorBase;
import com.shavenpuppy.jglib.resources.ImageWrapper;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;

public class RingImageResource
extends Resource
implements ImageWrapper {
    public static final long serialVersionUID = 1L;
    private int type;
    private int size;
    private float thickness;
    private String interpolator;
    private Image image;
    private Interpolator interpolatorInstance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.texgen.RingImageResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public RingImageResource(String name) {
        super(name);
    }

    public RingImageResource(String name, int size, int type, Interpolator interpolatorInstance) {
        super(name);
        this.size = size;
        this.type = type;
        this.interpolatorInstance = interpolatorInstance;
    }

    protected void doCreate() throws Exception {
        this.image = new Image(this.size, this.size, this.type);
        this.interpolatorInstance = InterpolatorBase.decode(this.interpolator);
        float midX = ((float)this.size - 1.0f) / 2.0f;
        float ringRadius = midX - this.thickness;
        int y = 0;
        while (y < this.size) {
            float dy = (float)y - midX;
            float dy2 = dy * dy;
            int x = 0;
            while (x < this.size) {
                float dx = (float)x - midX;
                float pointRadius = (float)Math.sqrt(dx * dx + dy2);
                byte alpha = (byte)this.interpolatorInstance.interpolate(255.0f, 0.0f, Math.abs(pointRadius - ringRadius) / this.thickness);
                this.image.getData().put(alpha);
                if (this.type == 3) {
                    this.image.getData().put(alpha);
                }
                ++x;
            }
            ++y;
        }
        this.image.getData().flip();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.size = XMLUtil.getInt(element, "size");
        this.interpolator = XMLUtil.getString(element, "interpolator");
        String stype = element.getAttribute("type");
        if (stype.equalsIgnoreCase("luminance")) {
            this.type = 2;
        } else if (stype.equalsIgnoreCase("alpha")) {
            this.type = 2;
        } else if (stype.equalsIgnoreCase("luminance_alpha")) {
            this.type = 3;
        }
        this.thickness = XMLUtil.getFloat(element, "thickness");
    }

    public final Image getImage() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        return this.image;
    }
}

