/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.io.Serializable;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public class SerializedSprite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String appearance;
    private int tick;
    private int sequence;
    private int layer;
    private Vector3i location = new Vector3i();
    private Vector3i offset = new Vector3i();
    private boolean flash;
    private final Color[] color = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255)};
    private int scale;
    private int alpha;
    private int angle;
    private boolean visible;
    private boolean active;
    private int event;
    private boolean paused;
    private boolean mirrored;
    private boolean flipped;

    public void fromSprite(Sprite source) {
        if (source.getAnimation() != null) {
            this.appearance = source.getAnimation().getName();
        } else if (source.getImage() != null) {
            this.appearance = source.getImage().getName();
        }
        this.tick = source.getTick();
        this.sequence = source.getSequence();
        this.layer = source.getLayer();
        source.getLocation(this.location);
        source.getOffset(this.offset);
        this.flash = source.isFlashing();
        source.getColor(0, (WritableColor)this.color[0]);
        source.getColor(1, (WritableColor)this.color[1]);
        source.getColor(2, (WritableColor)this.color[2]);
        source.getColor(3, (WritableColor)this.color[3]);
        this.scale = source.getScale();
        this.alpha = source.getAlpha();
        this.angle = source.getAngle();
        this.visible = source.isVisible();
        this.active = source.isActive();
        this.event = source.getEvent();
        this.paused = source.isPaused();
        this.mirrored = source.isMirrored();
        this.flipped = source.isFlipped();
    }

    public void toSprite(Sprite dest) throws Exception {
        if (!dest.isAllocated()) {
            throw new Exception("Sprite is not allocated!");
        }
        if (this.appearance != null) {
            dest.setAppearance((AnimatedAppearance)((Object)Resources.get(this.appearance)));
        }
        dest.setTick(this.tick);
        dest.setSequence(this.sequence);
        dest.setLayer(this.layer);
        dest.setLocation(this.location.getX(), this.location.getY(), this.location.getZ());
        dest.setOffset(this.offset);
        dest.setFlash(this.flash);
        dest.setColor(0, (ReadableColor)this.color[0]);
        dest.setColor(1, (ReadableColor)this.color[1]);
        dest.setColor(2, (ReadableColor)this.color[2]);
        dest.setColor(3, (ReadableColor)this.color[3]);
        dest.setScale(this.scale);
        dest.setAlpha(this.alpha);
        dest.setVisible(this.visible);
        dest.setActive(this.active);
        dest.setEvent(this.event);
        dest.setPaused(this.paused);
        dest.setMirrored(this.mirrored);
        dest.setFlipped(this.flipped);
    }
}

