/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.algorithms.RadixSort;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.Style;
import com.shavenpuppy.jglib.sprites.TextureRun;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.WritableColor;

public class IndexedSpriteEngine
implements SpriteEngine {
    private Sprite[] sprites;
    private Sprite[] tempSprites;
    private int numAllocated;
    private int numFragmented;
    private TextureRun[] textureRuns;
    private int numTextureRuns;
    private int tickRate;
    private boolean needSorting;
    private boolean positionsNeedUpdating;
    private boolean coloursNeedUpdating;
    private boolean texCoordsNeedUpdating;
    private boolean indicesNeedUpdating;
    private FloatBuffer vertices;
    private FloatBuffer texCoords;
    private ByteBuffer colours;
    private ShortBuffer indices;
    private RadixSort sorter;
    private int[] sortableTextureIds;
    private int[] sortableStyleIds;
    private static final Vector3i offset;
    private static final Color color;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sprites.IndexedSpriteEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        offset = new Vector3i();
        color = new Color();
    }

    public IndexedSpriteEngine(int maxSprites, int tickRate) {
        if (!$assertionsDisabled && maxSprites <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tickRate <= 0) {
            throw new AssertionError();
        }
        this.needSorting = true;
        this.tickRate = tickRate;
        this.sprites = new Sprite[maxSprites];
        this.tempSprites = new Sprite[maxSprites];
        int i = 0;
        while (i < this.sprites.length) {
            this.sprites[i] = new Sprite(this);
            this.sprites[i].index = i;
            ++i;
        }
        this.numAllocated = 0;
        this.numFragmented = 0;
        this.textureRuns = new TextureRun[maxSprites];
        i = 0;
        while (i < this.textureRuns.length) {
            this.textureRuns[i] = new TextureRun();
            ++i;
        }
        this.numTextureRuns = 0;
        this.sorter = new RadixSort(maxSprites);
        this.sortableTextureIds = new int[maxSprites];
        this.sortableStyleIds = new int[maxSprites];
        this.vertices = BufferUtils.createFloatBuffer((int)(maxSprites * 3 * 4));
        this.texCoords = BufferUtils.createFloatBuffer((int)(maxSprites * 2 * 4));
        this.colours = BufferUtils.createByteBuffer((int)(maxSprites * 4 * 4));
        this.indices = BufferUtils.createShortBuffer((int)(maxSprites * 4));
    }

    public void create() {
    }

    public void destroy() {
    }

    public boolean isCreated() {
        return true;
    }

    public void setTickRate(int newTickRate) {
        this.tickRate = newTickRate;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public Sprite allocate(Object owner) {
        if (!$assertionsDisabled && this.numAllocated >= this.sprites.length) {
            throw new AssertionError((Object)"No more sprites avalible to allocate");
        }
        if (this.numFragmented > 0) {
            if (!$assertionsDisabled && this.numAllocated + this.numFragmented > this.sprites.length) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.numAllocated + this.numFragmented) {
                Sprite spr = this.sprites[i];
                if (!spr.isAllocated()) {
                    spr.init(owner);
                    --this.numFragmented;
                    return spr;
                }
                ++i;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Fragmented sprite not found");
            }
            return null;
        }
        Sprite spr = this.sprites[this.numAllocated++];
        spr.init(owner);
        return spr;
    }

    public void deallocate(Sprite spr) {
        if (!$assertionsDisabled && this.sprites[spr.index] != spr) {
            throw new AssertionError((Object)".deallocate() could not locate sprite");
        }
        spr.forceDeallocate();
    }

    public void clear() {
        if (!$assertionsDisabled && this.numAllocated > this.sprites.length) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < this.numAllocated) {
            Sprite spr = this.sprites[i];
            if (spr.isAllocated()) {
                spr.forceDeallocate();
            }
            ++i;
        }
    }

    public void tick() {
        if (!$assertionsDisabled && this.numAllocated > this.sprites.length) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < this.numAllocated) {
            Sprite spr = this.sprites[i];
            if (spr.isAllocated()) {
                spr.tick();
            }
            ++i;
        }
    }

    public float getAlpha() {
        return 0.0f;
    }

    public void setAlpha(float alpha) {
    }

    public void render() {
        if (!$assertionsDisabled && this.numAllocated + this.numFragmented > this.sprites.length) {
            throw new AssertionError();
        }
        this.needSorting = true;
        this.sort();
        this.rebuildDataBuffers();
        this.rebuildIndices();
        this.renderFromBuffers();
    }

    private void compact() {
        if (this.numFragmented == 0) {
            return;
        }
        int i = 0;
        while (i < this.sprites.length) {
            Sprite spr = this.sprites[i];
            if (!spr.isAllocated()) {
                Sprite lastSpr;
                int lastIndex = this.numAllocated + this.numFragmented;
                this.sprites[i] = lastSpr = this.sprites[lastIndex];
                lastSpr.index = i;
                this.sprites[lastIndex] = spr;
                spr.index = lastIndex;
                --this.numFragmented;
                if (this.numFragmented == 0) break;
            }
            ++i;
        }
        if (!$assertionsDisabled && this.numFragmented != 0) {
            throw new AssertionError();
        }
    }

    private void sort() {
        if (!this.needSorting) {
            return;
        }
        this.compact();
        int n = this.numAllocated + this.numFragmented;
        int i = 0;
        while (i < n) {
            Sprite spr = this.sprites[i];
            SpriteImage si = spr.getImage();
            if (!$assertionsDisabled && si == null) {
                throw new AssertionError();
            }
            this.sortableTextureIds[i] = si.getTexture().getID();
            this.sortableStyleIds[i] = si.getStyle().getStyleID();
            ++i;
        }
        this.sorter.resetIndices();
        this.sorter.sort(this.sortableTextureIds, n);
        this.sorter.sort(this.sortableStyleIds, n);
        int[] indices = this.sorter.getIndices();
        int i2 = 0;
        while (i2 < n) {
            int newIndex = indices[i2];
            Sprite spr = this.sprites[newIndex];
            spr.index = i2;
            this.tempSprites[i2] = spr;
            ++i2;
        }
        i2 = n;
        while (i2 < this.sprites.length) {
            this.tempSprites[i2] = this.sprites[i2];
            ++i2;
        }
        Sprite[] swap = this.sprites;
        this.sprites = this.tempSprites;
        this.tempSprites = swap;
        this.indicesNeedUpdating = true;
        this.texCoordsNeedUpdating = true;
        this.coloursNeedUpdating = true;
        this.positionsNeedUpdating = true;
        this.needSorting = false;
    }

    private void rebuildDataBuffers() {
        int i;
        int total = this.numAllocated + this.numFragmented;
        if (this.positionsNeedUpdating) {
            this.vertices.clear();
            i = 0;
            while (i < total) {
                this.writePositionBuffers(this.sprites[i]);
                ++i;
            }
            this.vertices.flip();
        }
        if (this.texCoordsNeedUpdating) {
            this.texCoords.clear();
            i = 0;
            while (i < total) {
                this.writeTexCoordsToBuffers(this.sprites[i]);
                ++i;
            }
            this.texCoords.flip();
        }
        if (this.coloursNeedUpdating) {
            this.colours.clear();
            i = 0;
            while (i < total) {
                this.writeColoursToBuffers(this.sprites[i]);
                ++i;
            }
            this.colours.flip();
        }
    }

    private void writePositionBuffers(Sprite s) {
        int scaledy01;
        int scaledy11;
        int scaledy10;
        int scaledy00;
        int scaledx01;
        int scaledx11;
        int scaledx10;
        int scaledx00;
        SpriteImage image = s.getImage();
        if (!$assertionsDisabled && image == null) {
            throw new AssertionError();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int scale = s.getScale();
        s.getOffset(offset);
        int x = s.getX();
        int y = s.getY();
        int z = s.getZ();
        int angle = s.getAngle();
        int scaledx0 = offset.getX() - image.getHotspotX();
        int scaledy0 = offset.getY() - image.getHotspotY();
        int scaledx1 = scaledx0 + w;
        int scaledy1 = scaledy0 + h;
        if (scale != FPMath.ONE) {
            scaledx0 = FPMath.mul(scaledx0, scale);
            scaledx1 = FPMath.mul(scaledx1, scale);
            scaledy0 = FPMath.mul(scaledy0, scale);
            scaledy1 = FPMath.mul(scaledy1, scale);
        }
        if (angle != 0) {
            int cos = FPMath.cos(angle);
            int sin = FPMath.sin(angle);
            scaledx00 = FPMath.mul(cos, scaledx0) - FPMath.mul(sin, scaledy0);
            scaledx10 = FPMath.mul(cos, scaledx1) - FPMath.mul(sin, scaledy0);
            scaledx11 = FPMath.mul(cos, scaledx1) - FPMath.mul(sin, scaledy1);
            scaledx01 = FPMath.mul(cos, scaledx0) - FPMath.mul(sin, scaledy1);
            scaledy00 = FPMath.mul(sin, scaledx0) + FPMath.mul(cos, scaledy0);
            scaledy10 = FPMath.mul(sin, scaledx1) + FPMath.mul(cos, scaledy0);
            scaledy11 = FPMath.mul(sin, scaledx1) + FPMath.mul(cos, scaledy1);
            scaledy01 = FPMath.mul(sin, scaledx0) + FPMath.mul(cos, scaledy1);
        } else {
            scaledx00 = scaledx0;
            scaledx10 = scaledx1;
            scaledx11 = scaledx1;
            scaledx01 = scaledx0;
            scaledy00 = scaledy0;
            scaledy10 = scaledy0;
            scaledy11 = scaledy1;
            scaledy01 = scaledy1;
        }
        int x00 = scaledx00 + x;
        int x01 = scaledx01 + x;
        int x11 = scaledx11 + x;
        int x10 = scaledx10 + x;
        int y00 = scaledy00 + y;
        int y01 = scaledy01 + y;
        int y11 = scaledy11 + y;
        int y10 = scaledy10 + y;
        this.vertices.put(x00);
        this.vertices.put(y00);
        this.vertices.put(z);
        this.vertices.put(x10);
        this.vertices.put(y10);
        this.vertices.put(z);
        this.vertices.put(x11);
        this.vertices.put(y11);
        this.vertices.put(z);
        this.vertices.put(x01);
        this.vertices.put(y01);
        this.vertices.put(z);
    }

    private void writeTexCoordsToBuffers(Sprite s) {
        SpriteImage image = s.getImage();
        if (!$assertionsDisabled && image == null) {
            throw new AssertionError();
        }
        float tx0 = image.getTx0();
        float tx1 = image.getTx1();
        float ty0 = image.getTy0();
        float ty1 = image.getTy1();
        this.texCoords.put(tx0);
        this.texCoords.put(ty1);
        this.texCoords.put(tx1);
        this.texCoords.put(ty1);
        this.texCoords.put(tx1);
        this.texCoords.put(ty0);
        this.texCoords.put(tx0);
        this.texCoords.put(ty0);
    }

    private void writeColoursToBuffers(Sprite s) {
        int alpha = s.getAlpha();
        s.getColor(0, (WritableColor)color);
        this.colours.put(color.getRedByte());
        this.colours.put(color.getGreenByte());
        this.colours.put(color.getBlueByte());
        this.colours.put((byte)(color.getAlpha() * alpha >> 8));
        s.getColor(1, (WritableColor)color);
        this.colours.put(color.getRedByte());
        this.colours.put(color.getGreenByte());
        this.colours.put(color.getBlueByte());
        this.colours.put((byte)(color.getAlpha() * alpha >> 8));
        s.getColor(2, (WritableColor)color);
        this.colours.put(color.getRedByte());
        this.colours.put(color.getGreenByte());
        this.colours.put(color.getBlueByte());
        this.colours.put((byte)(color.getAlpha() * alpha >> 8));
        s.getColor(3, (WritableColor)color);
        this.colours.put(color.getRedByte());
        this.colours.put(color.getGreenByte());
        this.colours.put(color.getBlueByte());
        this.colours.put((byte)(color.getAlpha() * alpha >> 8));
    }

    private void rebuildIndices() {
        if (!this.indicesNeedUpdating) {
            return;
        }
        this.indices.clear();
        this.numTextureRuns = 0;
        GLTexture currentTexture = null;
        Style currentStyle = null;
        TextureRun currentTextureRun = null;
        int offset = 0;
        int n = this.numAllocated + this.numFragmented;
        int i = 0;
        while (i < n) {
            Sprite spr = this.sprites[i];
            if (spr.isVisible()) {
                SpriteImage image = spr.getImage();
                GLTexture newTexture = image.getTexture();
                Style newStyle = image.getStyle();
                if (newTexture != currentTexture || newStyle != currentStyle) {
                    currentTexture = newTexture;
                    currentStyle = newStyle;
                    currentTextureRun = this.textureRuns[this.numTextureRuns++];
                    if (!$assertionsDisabled && offset * 4 != this.indices.position()) {
                        throw new AssertionError();
                    }
                    currentTextureRun.init(newTexture, newStyle, offset);
                }
                ++offset;
                currentTextureRun.add();
                int base = spr.index * 4;
                this.indices.put((short)base);
                this.indices.put((short)(base + 1));
                this.indices.put((short)(base + 2));
                this.indices.put((short)(base + 3));
            }
            ++i;
        }
        this.indices.flip();
        this.indicesNeedUpdating = false;
    }

    private void renderFromBuffers() {
        if (this.numTextureRuns == 0) {
            return;
        }
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32886);
        GL11.glEnableClientState((int)32888);
        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)this.vertices);
        GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)this.texCoords);
        GL11.glColorPointer((int)4, (boolean)true, (int)0, (ByteBuffer)this.colours);
        int i = 0;
        while (i < this.numTextureRuns) {
            this.textureRuns[i].drawRangeElements(this.indices);
            ++i;
        }
        this.textureRuns[this.numTextureRuns - 1].done();
    }
}

