/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Command;
import org.w3c.dom.Element;

public class FrameCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private int duration;
    private String appearanceName;
    private transient AnimatedAppearance spriteAppearance;

    public boolean execute(Animated target, int tickRate) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(currentTick + tickRate);
        this.spriteAppearance.toAnimated(target);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.appearanceName = element.getAttribute("i");
        this.duration = Integer.parseInt(element.getAttribute("d"));
    }

    protected void doCreate() throws Exception {
        this.spriteAppearance = (AnimatedAppearance)((Object)Resources.get(this.appearanceName));
    }

    protected void doDestroy() {
        this.spriteAppearance = null;
    }
}

