/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sound;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.util.PriorityPool;
import org.lwjgl.openal.AL10;

public class SoundPlayer
extends Resource {
    public static final long serialVersionUID = 1L;
    private PriorityPool priorityPool;
    private final int sources;
    private final SoundEffect[] fx;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sound.SoundPlayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SoundPlayer(int sources) {
        this.sources = sources;
        this.fx = new SoundEffect[sources];
    }

    public void play() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        this.priorityPool.tick();
    }

    protected void doCreate() throws Exception {
        int i = 0;
        while (i < this.fx.length) {
            this.fx[i] = new SoundEffect(this);
            this.fx[i].source.create();
            ++i;
        }
        this.priorityPool = new PriorityPool(this.fx);
        AL10.alDopplerVelocity((float)10240.0f);
        AL10.alDopplerFactor((float)1.2f);
        AL10.alDistanceModel((int)53249);
    }

    protected void doDestroy() {
        this.priorityPool.reset();
        this.priorityPool = null;
        int i = 0;
        while (i < this.fx.length) {
            this.fx[i].source.destroy();
            this.fx[i] = null;
            ++i;
        }
    }

    public SoundEffect allocate(ALBuffer buf, Object owner) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        SoundEffect ret = (SoundEffect)this.priorityPool.allocate(buf.getPriority(), owner);
        if (ret != null) {
            ret.init(buf);
        }
        return ret;
    }
}

