/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl.glsl;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.Util;

public class ShaderUtil {
    public static final boolean DEBUG = true;
    static /* synthetic */ Class class$0;

    public static ByteBuffer getProgramCode(String filename) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.opengl.glsl.ShaderUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader fileLoader = clazz.getClassLoader();
        InputStream fileInputStream = fileLoader.getResourceAsStream(filename);
        byte[] shaderCode = null;
        try {
            if (fileInputStream == null) {
                fileInputStream = new FileInputStream(filename);
            }
            DataInputStream dataStream = new DataInputStream(fileInputStream);
            shaderCode = new byte[fileInputStream.available()];
            dataStream.readFully(shaderCode);
            fileInputStream.close();
            dataStream.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        ByteBuffer shaderPro = BufferUtils.createByteBuffer((int)shaderCode.length);
        shaderPro.put(shaderCode);
        shaderPro.flip();
        return shaderPro;
    }

    public static void printLogInfo(int obj) {
        Util.checkGLError();
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)obj, (int)35716, (IntBuffer)iVal);
        int length = iVal.get();
        if (length > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer((int)length);
            iVal.flip();
            ARBShaderObjects.glGetInfoLogARB((int)obj, (IntBuffer)iVal, (ByteBuffer)infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            String out = new String(infoBytes);
            System.out.println("Info log:\n" + out);
        }
        Util.checkGLError();
    }

    public static ByteBuffer toNullTerminatedByteString(String str) {
        return ShaderUtil.toByteString(str, true);
    }

    public static ByteBuffer toByteString(String str) {
        return ShaderUtil.toByteString(str, false);
    }

    private static ByteBuffer toByteString(String str, boolean isNullTerminated) {
        int length = str.length();
        if (isNullTerminated) {
            ++length;
        }
        ByteBuffer buff = BufferUtils.createByteBuffer((int)length);
        buff.put(str.getBytes());
        if (isNullTerminated) {
            buff.put((byte)0);
        }
        buff.flip();
        return buff;
    }

    public static void bindFixedFunction() {
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }
}

