/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl.glsl;

import com.shavenpuppy.jglib.opengl.glsl.FragmentShader;
import com.shavenpuppy.jglib.opengl.glsl.ShaderUtil;
import com.shavenpuppy.jglib.opengl.glsl.UniformFloatVariable;
import com.shavenpuppy.jglib.opengl.glsl.UniformSampler2D;
import com.shavenpuppy.jglib.opengl.glsl.UniformVec2Variable;
import com.shavenpuppy.jglib.opengl.glsl.UniformVec3Variable;
import com.shavenpuppy.jglib.opengl.glsl.VertexFloatAttribute;
import com.shavenpuppy.jglib.opengl.glsl.VertexShader;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;

public class ShaderProgram {
    protected int programId;
    protected VertexShader vertexShader;
    protected FragmentShader fragmentShader;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.opengl.glsl.ShaderProgram");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected ShaderProgram() {
    }

    public ShaderProgram(VertexShader vs, FragmentShader fs) {
        this.vertexShader = vs;
        this.fragmentShader = fs;
        this.link();
    }

    protected void link() {
        if (!$assertionsDisabled && this.vertexShader == null && this.fragmentShader == null) {
            throw new AssertionError();
        }
        this.programId = ARBShaderObjects.glCreateProgramObjectARB();
        if (this.vertexShader != null) {
            ARBShaderObjects.glAttachObjectARB((int)this.programId, (int)this.vertexShader.shaderObjectId);
        }
        if (this.fragmentShader != null) {
            ARBShaderObjects.glAttachObjectARB((int)this.programId, (int)this.fragmentShader.shaderObjectId);
        }
        this.printLogInfo();
        ARBShaderObjects.glLinkProgramARB((int)this.programId);
        this.printLogInfo();
    }

    public void validate() {
        ARBShaderObjects.glValidateProgramARB((int)this.programId);
        IntBuffer iBuff = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)this.programId, (int)35715, (IntBuffer)iBuff);
        if (iBuff.get() > 0) {
            System.out.println("Program validated ok.");
        }
        this.printLogInfo();
    }

    public void printLogInfo() {
        ShaderUtil.printLogInfo(this.programId);
    }

    public VertexFloatAttribute createVertexAttribute(String attributeName) {
        ByteBuffer name = ShaderUtil.toNullTerminatedByteString(attributeName);
        int location = ARBVertexShader.glGetAttribLocationARB((int)this.programId, (ByteBuffer)name);
        System.out.println("Vertex attribute " + attributeName + " is bound to location " + location);
        return new VertexFloatAttribute(attributeName, location);
    }

    public UniformFloatVariable createUniformFloatVariable(String uniformName) {
        ByteBuffer name = ShaderUtil.toNullTerminatedByteString(uniformName);
        int location = ARBShaderObjects.glGetUniformLocationARB((int)this.programId, (ByteBuffer)name);
        System.out.println("Uniform float variable " + uniformName + " is bound to location " + location);
        return new UniformFloatVariable(this, uniformName, location);
    }

    public UniformVec2Variable createUniformVec2Variable(String uniformName) {
        ByteBuffer name = ShaderUtil.toNullTerminatedByteString(uniformName);
        int location = ARBShaderObjects.glGetUniformLocationARB((int)this.programId, (ByteBuffer)name);
        System.out.println("Uniform vec2 variable " + uniformName + " is bound to location " + location);
        return new UniformVec2Variable(this, uniformName, location);
    }

    public UniformVec3Variable createUniformVec3Variable(String uniformName) {
        ByteBuffer name = ShaderUtil.toNullTerminatedByteString(uniformName);
        int location = ARBShaderObjects.glGetUniformLocationARB((int)this.programId, (ByteBuffer)name);
        System.out.println("Uniform vec3 variable " + uniformName + " is bound to location " + location);
        return new UniformVec3Variable(this, uniformName, location);
    }

    public UniformSampler2D createUniformSampler2D(String samplerName) {
        ByteBuffer name = ShaderUtil.toNullTerminatedByteString(samplerName);
        int location = ARBShaderObjects.glGetUniformLocationARB((int)this.programId, (ByteBuffer)name);
        System.out.println("Uniform sampler2D " + samplerName + " is bound to location " + location);
        return new UniformSampler2D(this, samplerName, location);
    }

    public void bind() {
        ARBShaderObjects.glUseProgramObjectARB((int)this.programId);
    }
}

