/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLGlyph;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.util.Decodeable;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritableDimension;
import org.lwjgl.util.WritablePoint;

public class GLTextArea
implements GLRenderable,
WritablePoint,
WritableDimension {
    protected GLFont font;
    private final StringBuffer text = new StringBuffer();
    private GLGlyph[] glyph;
    private int numGlyphs;
    private final Dimension size = new Dimension();
    private int textHeight;
    private final Point location = new Point();
    private TextLayout.Format format = TextLayout.WORD_WRAP;
    private TextLayout.HorizontalAlignment alignment = TextLayout.LEFT;
    private VerticalAlignment verticalAlignment = TOP;
    private boolean changed = true;
    public static final VerticalAlignment TOP = new VerticalAlignment("Top"){

        private Object readResolve() throws ObjectStreamException {
            return TOP;
        }
    };
    public static final VerticalAlignment BOTTOM = new VerticalAlignment("Bottom"){

        private Object readResolve() throws ObjectStreamException {
            return BOTTOM;
        }
    };
    public static final VerticalAlignment CENTERED = new VerticalAlignment("Centered"){

        private Object readResolve() throws ObjectStreamException {
            return CENTERED;
        }
    };
    public static final VerticalAlignment BASELINE = new VerticalAlignment("Baseline"){

        private Object readResolve() throws ObjectStreamException {
            return BASELINE;
        }
    };

    public GLFont getFont() {
        return this.font;
    }

    public Rectangle getGlyphBounds(int index, Rectangle dest) {
        this.layout();
        if (dest == null) {
            dest = new Rectangle();
        }
        if (index < 0) {
            dest.setBounds(this.location.getX(), this.location.getY(), 0, this.font.getAscent() + this.font.getDescent());
        } else {
            GLGlyph g = this.glyph[index];
            if (g != null) {
                dest.setBounds(g.xpos + this.location.getX(), g.ypos + this.location.getY(), g.getAdvance(), this.font.getAscent() + this.font.getDescent());
            }
        }
        return dest;
    }

    public GLGlyph getGlyph(int index) {
        return this.glyph[index];
    }

    private void layout() {
        if (!this.changed) {
            return;
        }
        this.changed = false;
        TextLayout textLayout = new TextLayout(this.font.getFont(), this.text.toString(), this.size.getWidth(), this.format, this.alignment);
        this.textHeight = textLayout.getHeight();
        final int ty = this.verticalAlignment == TOP ? this.size.getHeight() : (this.verticalAlignment == CENTERED ? this.textHeight + (this.size.getHeight() - this.textHeight) / 2 : (this.verticalAlignment == BASELINE ? this.font.getAscent() : this.textHeight));
        textLayout.apply(new TextLayout.Target(){

            public void setNumGlyphs(int n) {
                GLTextArea.this.numGlyphs = n;
                if (GLTextArea.this.glyph == null || GLTextArea.this.glyph.length < GLTextArea.this.numGlyphs || GLTextArea.this.glyph.length > GLTextArea.this.numGlyphs * 2) {
                    GLTextArea.this.glyph = null;
                    GLTextArea.this.glyph = new GLGlyph[GLTextArea.this.numGlyphs];
                }
            }

            public void setGlyph(int index, Glyph g, int x, int y) {
                if (GLTextArea.this.glyph[index] == null) {
                    ((GLTextArea)GLTextArea.this).glyph[index] = new GLGlyph(GLTextArea.this.font.getTexture(), g);
                } else {
                    GLTextArea.this.glyph[index].init(GLTextArea.this.font.getTexture(), g);
                }
                GLTextArea.this.glyph[index].setLocation(x, y + ty);
            }
        });
    }

    public void render() {
        this.layout();
        this.font.getTexture().render();
        if (this.location.getX() != 0 || this.location.getY() != 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.location.getX(), (float)this.location.getY(), (float)0.0f);
        }
        GL11.glBegin((int)7);
        int i = 0;
        while (i < this.numGlyphs) {
            if (this.glyph[i] != null) {
                this.glyph[i].render();
            }
            ++i;
        }
        GL11.glEnd();
        if (this.location.getX() != 0 || this.location.getY() != 0) {
            GL11.glPopMatrix();
        }
    }

    public void setFont(GLFont font) {
        if (this.font == font) {
            return;
        }
        this.font = font;
        this.changed = true;
    }

    public void setHorizontalAlignment(TextLayout.HorizontalAlignment alignment) {
        if (this.alignment == alignment) {
            return;
        }
        this.alignment = alignment;
        this.changed = true;
    }

    public void setVerticalAlignment(VerticalAlignment valignment) {
        if (this.verticalAlignment == valignment) {
            return;
        }
        this.verticalAlignment = valignment;
        this.changed = true;
    }

    public int getTextHeight() {
        this.layout();
        return this.textHeight;
    }

    public TextLayout.Format getFormat() {
        return this.format;
    }

    public void setFormat(TextLayout.Format format) {
        if (this.format == format) {
            return;
        }
        this.format = format;
        this.changed = true;
    }

    public GLTextArea append(boolean b) {
        this.changed = true;
        this.text.append(b);
        return this;
    }

    public GLTextArea append(char c) {
        this.changed = true;
        this.text.append(c);
        return this;
    }

    public GLTextArea append(char[] str) {
        this.changed = true;
        this.text.append(str);
        return this;
    }

    public GLTextArea append(char[] str, int offset, int len) {
        this.changed = true;
        this.text.append(str, offset, len);
        return this;
    }

    public GLTextArea append(double d) {
        this.changed = true;
        this.text.append(d);
        return this;
    }

    public GLTextArea append(float f) {
        this.changed = true;
        this.text.append(f);
        return this;
    }

    public GLTextArea append(int i) {
        this.changed = true;
        this.text.append(i);
        return this;
    }

    public GLTextArea append(Object obj) {
        this.changed = true;
        this.text.append(obj);
        return this;
    }

    public GLTextArea append(String str) {
        this.changed = true;
        this.text.append(str);
        return this;
    }

    public GLTextArea append(StringBuffer sb) {
        this.changed = true;
        this.text.append(sb);
        return this;
    }

    public GLTextArea append(long l) {
        this.changed = true;
        this.text.append(l);
        return this;
    }

    public int capacity() {
        return this.text.capacity();
    }

    public GLTextArea delete(int start, int end) {
        this.changed = true;
        this.text.delete(start, end);
        return this;
    }

    public GLTextArea deleteCharAt(int index) {
        this.changed = true;
        this.text.deleteCharAt(index);
        return this;
    }

    public GLTextArea insert(int offset, boolean b) {
        this.changed = true;
        this.text.insert(offset, b);
        return this;
    }

    public GLTextArea insert(int offset, char c) {
        this.changed = true;
        this.text.insert(offset, c);
        return this;
    }

    public GLTextArea insert(int offset, char[] str) {
        this.changed = true;
        this.text.insert(offset, str);
        return this;
    }

    public GLTextArea insert(int index, char[] str, int offset, int len) {
        this.changed = true;
        this.text.insert(index, str, offset, len);
        return this;
    }

    public GLTextArea insert(int offset, double d) {
        this.changed = true;
        this.text.insert(offset, d);
        return this;
    }

    public GLTextArea insert(int offset, float f) {
        this.changed = true;
        this.text.insert(offset, f);
        return this;
    }

    public GLTextArea insert(int offset, int i) {
        this.changed = true;
        this.text.insert(offset, i);
        return this;
    }

    public GLTextArea insert(int offset, Object obj) {
        this.changed = true;
        this.text.insert(offset, obj);
        return this;
    }

    public GLTextArea insert(int offset, String str) {
        this.changed = true;
        this.text.insert(offset, str);
        return this;
    }

    public GLTextArea insert(int offset, long l) {
        this.changed = true;
        this.text.insert(offset, l);
        return this;
    }

    public int length() {
        return this.text.length();
    }

    public GLTextArea replace(int start, int end, String str) {
        this.changed = true;
        this.text.replace(start, end, str);
        return this;
    }

    public void setCharAt(int index, char ch) {
        if (this.text.charAt(index) == ch) {
            return;
        }
        this.changed = true;
        this.text.setCharAt(index, ch);
    }

    public void setLength(int newLength) {
        if (newLength == this.text.length()) {
            return;
        }
        this.changed = true;
        this.text.setLength(newLength);
    }

    public void getLocation(WritablePoint dest) {
        this.location.getLocation(dest);
    }

    public int getX() {
        return this.location.getX();
    }

    public int getY() {
        return this.location.getY();
    }

    public void setLocation(int x, int y) {
        this.location.setLocation(x, y);
    }

    public void setLocation(ReadablePoint p) {
        this.location.setLocation(p);
    }

    public void setX(int x) {
        this.location.setX(x);
    }

    public void setY(int y) {
        this.location.setY(y);
    }

    public void translate(int dx, int dy) {
        this.location.translate(dx, dy);
    }

    public void translate(ReadablePoint p) {
        this.location.translate(p);
    }

    public void untranslate(ReadablePoint p) {
        this.location.untranslate(p);
    }

    public int getHeight() {
        this.layout();
        return this.size.getHeight();
    }

    public int getWidth() {
        this.layout();
        return this.size.getWidth();
    }

    public void setHeight(int height) {
        if (this.size.getHeight() == height) {
            return;
        }
        this.changed = true;
        this.size.setHeight(height);
    }

    public void setWidth(int width) {
        if (this.size.getWidth() == width) {
            return;
        }
        this.changed = true;
        this.size.setWidth(width);
    }

    public void getSize(WritableDimension dest) {
        this.layout();
        this.size.getSize(dest);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.setLocation(x, y);
        this.setSize(w, h);
    }

    public void setBounds(ReadablePoint p, ReadableDimension d) {
        this.setLocation(p);
        this.setSize(d);
    }

    public void setBounds(ReadableRectangle r) {
        this.setLocation((ReadablePoint)r);
        this.setSize((ReadableDimension)r);
    }

    public void setSize(int w, int h) {
        if (this.size.getWidth() == w && this.size.getHeight() == h) {
            return;
        }
        this.changed = true;
        this.size.setSize(w, h);
    }

    public void setSize(ReadableDimension d) {
        if (this.size.equals((Object)d)) {
            return;
        }
        this.changed = true;
        this.size.setSize(d);
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public TextLayout.HorizontalAlignment getHorizontalAlignment() {
        return this.alignment;
    }

    public void setText(String newText) {
        this.text.setLength(0);
        this.text.append(newText);
        this.changed = true;
    }

    public String getText() {
        return this.text.toString();
    }

    public static abstract class VerticalAlignment
    implements Serializable,
    Decodeable {
        public static final long serialVersionUID = 1L;
        private final String display;

        private VerticalAlignment(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }

        public static Object decode(String in) throws Exception {
            if (in.equalsIgnoreCase(GLTextArea.TOP.display)) {
                return TOP;
            }
            if (in.equalsIgnoreCase(GLTextArea.BOTTOM.display)) {
                return BOTTOM;
            }
            if (in.equalsIgnoreCase(GLTextArea.BASELINE.display)) {
                return BASELINE;
            }
            if (in.equalsIgnoreCase(GLTextArea.CENTERED.display)) {
                return CENTERED;
            }
            throw new Exception("Unknown vertical alignment '" + in + "'");
        }
    }
}

