/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.openal;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.Wave;
import com.shavenpuppy.jglib.openal.AL;
import com.shavenpuppy.jglib.openal.ALBufferID;
import com.shavenpuppy.jglib.openal.ALResource;
import com.shavenpuppy.jglib.openal.ALSource;
import com.shavenpuppy.jglib.resources.WaveWrapper;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.OpenALException;
import org.w3c.dom.Element;

public class ALBuffer
extends ALResource
implements ALBufferID {
    public static final long serialVersionUID = 1L;
    protected String url;
    protected float gain;
    protected float pitch;
    protected int priority;
    protected boolean looped;
    private transient int buffer;
    private transient WaveWrapper waveResource;
    private transient Wave wave;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.openal.ALBuffer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ALBuffer() {
    }

    public ALBuffer(String name) {
        super(name);
    }

    public ALBuffer(String name, Wave wave) {
        super(name);
        this.wave = wave;
    }

    protected void doALCreate() throws Exception {
        int format;
        if (!org.lwjgl.openal.AL.isCreated()) {
            return;
        }
        AL.scratch.ints.clear().limit(1);
        AL10.alGenBuffers((IntBuffer)AL.scratch.ints);
        this.buffer = AL.scratch.ints.get(0);
        if (!$assertionsDisabled && this.buffer <= 0) {
            throw new AssertionError();
        }
        if (this.url != null) {
            if (this.url.startsWith("classpath:")) {
                try {
                    this.wave = Wave.read(new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(this.url.substring(10))));
                }
                catch (IOException e) {
                    System.out.println("Failed to load system resource: " + this.url.substring(10));
                    throw e;
                }
            } else if (this.url.startsWith("resource:")) {
                this.waveResource = (WaveWrapper)((Object)Resources.get(this.url.substring(9)));
            } else {
                this.wave = Wave.read(new BufferedInputStream(new URL(this.url).openStream()));
            }
        }
        if (this.waveResource != null) {
            this.wave = this.waveResource.getWave();
        }
        if (this.wave == null) {
            throw new Exception("No wave specified for " + this);
        }
        switch (this.wave.getType()) {
            case 0: {
                format = 4352;
                break;
            }
            case 1: {
                format = 4353;
                break;
            }
            case 2: {
                format = 4354;
                break;
            }
            case 3: {
                format = 4355;
                break;
            }
            default: {
                throw new OpenALException("Unknown wave format.");
            }
        }
        AL10.alBufferData((int)this.buffer, (int)format, (ByteBuffer)this.wave.getData(), (int)this.wave.getFrequency());
        this.wave.dispose();
    }

    protected void doALDestroy() {
        if (this.buffer != 0) {
            ALSource.unattach(this);
            AL.scratch.ints.clear().limit(1);
            AL.scratch.ints.put(0, this.buffer);
            AL10.alDeleteBuffers((IntBuffer)AL.scratch.ints);
            this.buffer = 0;
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.url = element.getAttribute("url");
        String gainS = element.getAttribute("gain");
        this.gain = gainS != null && !"".equals(gainS) ? Float.parseFloat(gainS) : 1.0f;
        String pitchS = element.getAttribute("pitch");
        this.pitch = pitchS != null && !"".equals(pitchS) ? Float.parseFloat(pitchS) : 1.0f;
        try {
            this.priority = Integer.parseInt(element.getAttribute("priority"));
        }
        catch (NumberFormatException e) {
            throw new Exception(this + " has no priority specified.");
        }
        this.looped = XMLUtil.getBoolean(element, "looped", false);
    }

    public final int getBufferID() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet."));
        }
        return this.buffer;
    }

    public final Wave getWave() {
        return this.wave;
    }

    public String toString() {
        return "ALBuffer[" + this.url + "]";
    }

    public float getGain() {
        return this.gain;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isLooped() {
        return this.looped;
    }
}

