/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry.storage;

import com.shavenpuppy.jglib.geometry.Box;
import com.shavenpuppy.jglib.geometry.Classifier;
import com.shavenpuppy.jglib.geometry.Frustum;
import com.shavenpuppy.jglib.geometry.storage.GeometryStorage;
import com.shavenpuppy.jglib.opengl.GLFrustum;
import com.shavenpuppy.jglib.util.ObjectList;
import java.io.Serializable;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class OctTree
implements Serializable,
GeometryStorage {
    protected final OctTree[] node;
    protected final Box box;
    protected final GeometryStorage.Geometry[] contents;
    protected final int totalGeometry;
    private boolean visible;
    private static final transient ArrayList v = new ArrayList();

    public OctTree(ObjectList newContents, int minContents, float minSize) {
        int newContentsSize = newContents.size();
        v.clear();
        int i = 0;
        while (i < newContentsSize) {
            GeometryStorage.Geometry g = (GeometryStorage.Geometry)newContents.get(i);
            g.getCoords(v);
            ++i;
        }
        this.box = Box.computeAABB(v);
        System.out.println("Creating node with " + newContentsSize + " items, bounds " + this.box);
        if (this.box.ex - this.box.px <= minSize && this.box.ey - this.box.py <= minSize && this.box.ez - this.box.pz <= minSize || newContentsSize <= minContents) {
            this.totalGeometry = newContents.size();
            this.contents = new GeometryStorage.Geometry[this.totalGeometry];
            newContents.toArray(this.contents);
            System.out.println("...node is a leaf.");
            this.node = null;
            return;
        }
        float midX = (this.box.px + this.box.ex) * 0.5f;
        float midY = (this.box.py + this.box.ey) * 0.5f;
        float midZ = (this.box.pz + this.box.ez) * 0.5f;
        ObjectList[] child = new ObjectList[8];
        int i2 = 0;
        while (i2 < 8) {
            child[i2] = new ObjectList(Math.max(1, newContentsSize >> 2));
            ++i2;
        }
        ObjectList geom = new ObjectList(Math.max(1, newContentsSize >> 4));
        int i3 = 0;
        while (i3 < newContentsSize) {
            GeometryStorage.Geometry q = (GeometryStorage.Geometry)newContents.get(i3);
            int c = 0;
            v.clear();
            q.getCoords(v);
            int length = v.size();
            int j = 0;
            while (j < length) {
                Vector3f vec = (Vector3f)v.get(j);
                float qx = vec.x;
                float qy = vec.y;
                float qz = vec.z;
                if (qz < midZ) {
                    if (qx < midX) {
                        if (qy < midY) {
                            c |= 1;
                        } else if (qy > midY) {
                            c |= 2;
                        }
                    } else if (qx > midX) {
                        if (qy < midY) {
                            c |= 4;
                        } else if (qy > midY) {
                            c |= 8;
                        }
                    }
                } else if (qz > midZ) {
                    if (qx < midX) {
                        if (qy < midY) {
                            c |= 0x10;
                        } else if (qy > midY) {
                            c |= 0x20;
                        }
                    } else if (qx > midX) {
                        if (qy < midY) {
                            c |= 0x40;
                        } else if (qy > midY) {
                            c |= 0x80;
                        }
                    }
                }
                ++j;
            }
            if (c == 1) {
                child[0].add(q);
            } else if (c == 2) {
                child[1].add(q);
            } else if (c == 4) {
                child[2].add(q);
            } else if (c == 8) {
                child[3].add(q);
            } else if (c == 16) {
                child[4].add(q);
            } else if (c == 32) {
                child[5].add(q);
            } else if (c == 64) {
                child[6].add(q);
            } else if (c == 128) {
                child[7].add(q);
            } else {
                geom.add(q);
            }
            ++i3;
        }
        int totalGeometry = geom.size();
        if (totalGeometry > 0) {
            this.contents = new GeometryStorage.Geometry[totalGeometry];
            System.out.println("Added " + totalGeometry + " geometry directly to node");
            geom.toArray(this.contents);
        } else {
            int i4 = 0;
            while (i4 < 8) {
                if (child[i4].size() == newContentsSize) {
                    this.totalGeometry = newContentsSize;
                    this.contents = new GeometryStorage.Geometry[this.totalGeometry];
                    child[i4].toArray(this.contents);
                    this.node = null;
                    return;
                }
                ++i4;
            }
            this.contents = null;
        }
        int numNodes = 0;
        int i5 = 0;
        while (i5 < 8) {
            if (child[i5].size() > 0) {
                ++numNodes;
            } else {
                child[i5] = null;
            }
            ++i5;
        }
        if (numNodes > 0) {
            this.node = new OctTree[numNodes];
            System.out.println("Creating " + numNodes + " nodes");
            numNodes = 0;
            i5 = 0;
            while (i5 < 8) {
                if (child[i5] != null) {
                    System.out.println("Child node " + i5 + ": " + child[i5].size());
                    this.node[numNodes] = new OctTree(child[i5], minContents, minSize);
                    totalGeometry += this.node[numNodes++].totalGeometry;
                }
                ++i5;
            }
        } else {
            this.node = null;
        }
        this.totalGeometry = totalGeometry;
    }

    public void addAll(ObjectList insideContents) {
        this.visible = true;
        if (this.contents != null) {
            insideContents.addAll(this.contents);
        }
        if (this.node != null) {
            int i = 0;
            while (i < this.node.length) {
                if (this.node[i] != null) {
                    this.node[i].addAll(insideContents);
                }
                ++i;
            }
        }
    }

    public void revisible(Classifier frustum, ObjectList visibleContents, int threshold) {
        if (!this.visible) {
            return;
        }
        if (this.totalGeometry <= threshold) {
            this.addAll(visibleContents);
            return;
        }
        Classifier.Classification classification = frustum.classify(this.box);
        if (classification == Frustum.INSIDE) {
            this.addAll(visibleContents);
        } else {
            if (classification == Frustum.OUTSIDE) {
                return;
            }
            if (classification == Frustum.ENCLOSING || classification == Frustum.SPANNING) {
                if (this.contents != null) {
                    visibleContents.addAll(this.contents);
                }
                if (this.node != null) {
                    int i = 0;
                    while (i < this.node.length) {
                        if (this.node[i] != null) {
                            this.node[i].visible(frustum, visibleContents, threshold);
                        }
                        ++i;
                    }
                }
            } else {
                System.out.println("Unknown classification " + classification);
            }
        }
    }

    public void visible(Classifier frustum, ObjectList visibleContents, int threshold) {
        if (this.totalGeometry <= threshold) {
            this.addAll(visibleContents);
            return;
        }
        Classifier.Classification classification = frustum.classify(this.box);
        if (classification == Frustum.INSIDE) {
            this.addAll(visibleContents);
        } else {
            if (classification == Frustum.OUTSIDE) {
                this.visible = false;
                return;
            }
            if (classification == Frustum.ENCLOSING || classification == Frustum.SPANNING) {
                this.visible = true;
                if (this.contents != null) {
                    visibleContents.addAll(this.contents);
                }
                if (this.node != null) {
                    int i = 0;
                    while (i < this.node.length) {
                        if (this.node[i] != null) {
                            this.node[i].visible(frustum, visibleContents, threshold);
                        }
                        ++i;
                    }
                }
            } else {
                System.out.println("Unknown classification " + classification);
            }
        }
    }

    private void color(GLFrustum f, float x, float y, float z) {
        Classifier.Classification c = f.classify(x, y, z);
        if (c == Classifier.INSIDE) {
            GL11.glColor4ub((byte)0, (byte)-1, (byte)0, (byte)-128);
        } else if (c == Classifier.OUTSIDE) {
            GL11.glColor4ub((byte)-1, (byte)0, (byte)0, (byte)-128);
        } else {
            GL11.glColor4ub((byte)0, (byte)0, (byte)-1, (byte)-128);
        }
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    public void render() {
        GLFrustum frustum = new GLFrustum();
        frustum.extract();
        GL11.glEnable((int)3042);
        GL11.glShadeModel((int)7425);
        GL11.glBlendFunc((int)770, (int)771);
        this.render(frustum);
    }

    private void render(GLFrustum frustum) {
        GL11.glBegin((int)2);
        this.color(frustum, this.box.px, this.box.py, this.box.pz);
        this.color(frustum, this.box.ex, this.box.py, this.box.pz);
        this.color(frustum, this.box.ex, this.box.ey, this.box.pz);
        this.color(frustum, this.box.px, this.box.ey, this.box.pz);
        GL11.glEnd();
        GL11.glBegin((int)2);
        this.color(frustum, this.box.px, this.box.py, this.box.ez);
        this.color(frustum, this.box.ex, this.box.py, this.box.ez);
        this.color(frustum, this.box.ex, this.box.ey, this.box.ez);
        this.color(frustum, this.box.px, this.box.ey, this.box.ez);
        GL11.glEnd();
        GL11.glBegin((int)1);
        this.color(frustum, this.box.px, this.box.py, this.box.pz);
        this.color(frustum, this.box.px, this.box.py, this.box.ez);
        this.color(frustum, this.box.ex, this.box.py, this.box.pz);
        this.color(frustum, this.box.ex, this.box.py, this.box.ez);
        this.color(frustum, this.box.ex, this.box.ey, this.box.pz);
        this.color(frustum, this.box.ex, this.box.ey, this.box.ez);
        this.color(frustum, this.box.px, this.box.ey, this.box.pz);
        this.color(frustum, this.box.px, this.box.ey, this.box.ez);
        GL11.glEnd();
        if (this.node != null && this.visible) {
            int i = 0;
            while (i < this.node.length) {
                this.node[i].render(frustum);
                ++i;
            }
        }
    }
}

