/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry.geometry2d;

import com.shavenpuppy.jglib.geometry.Classifier;
import com.shavenpuppy.jglib.geometry.geometry2d.Capsule;
import com.shavenpuppy.jglib.geometry.geometry2d.LineSegment2D;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Rectangle {
    public static final int LEFT_CODE = 0xF00000;
    public static final int RIGHT_CODE = 983040;
    public static final int TOP_CODE = 61440;
    public static final int BOTTOM_CODE = 3840;
    public static final int LEFT_TOP = 0xF0F000;
    public static final int LEFT_CENTER = 0xF00000;
    public static final int LEFT_BOTTOM = 0xF00F00;
    public static final int CENTER_TOP = 61440;
    public static final int CENTER_CENTER = 0;
    public static final int CENTER_BOTTOM = 3840;
    public static final int RIGHT_TOP = 1044480;
    public static final int RIGHT_CENTER = 983040;
    public static final int RIGHT_BOTTOM = 986880;
    private Vector2f position;
    private float width;
    private float height;

    public Rectangle() {
        this.position = new Vector2f();
        this.width = 1.0f;
        this.height = 1.0f;
    }

    public Rectangle(Rectangle rect) {
        this.position = new Vector2f();
        if (rect != null) {
            rect.getPosition(this.position);
            this.width = rect.getWidth();
            this.height = rect.getHeight();
        }
    }

    public Rectangle(Vector2f point1, Vector2f point2) {
        this.position = new Vector2f();
        this.position.x = Math.min(point1.x, point2.x);
        this.position.y = Math.min(point1.y, point2.y);
        float endX = Math.max(point1.x, point2.x);
        float endY = Math.max(point1.y, point2.y);
        this.width = endX - this.position.x;
        this.height = endY - this.position.y;
    }

    public Rectangle(float x, float y, float width, float height) {
        this.position = new Vector2f(x, y);
        this.width = width;
        this.height = height;
    }

    public float getX() {
        return this.position.x;
    }

    public float getY() {
        return this.position.y;
    }

    public Vector2f getPosition() {
        return this.getPosition(null);
    }

    public void set(Rectangle src) {
        this.position.x = src.getX();
        this.position.y = src.getY();
        this.width = src.getWidth();
        this.height = src.getHeight();
    }

    public Vector2f getPosition(Vector2f dest) {
        if (dest == null) {
            dest = new Vector2f();
        }
        dest.set((ReadableVector2f)this.position);
        return dest;
    }

    public void setPosition(float x, float y) {
        this.position.set(x, y);
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setSize(float w, float h) {
        this.width = w;
        this.height = h;
    }

    public boolean isEmpty() {
        return this.width == 0.0f && this.height == 0.0f;
    }

    public void expand(float amount) {
        this.position.x -= amount;
        this.position.y -= amount;
        this.width += amount * 2.0f;
        this.height += amount * 2.0f;
    }

    public void expandToContain(Rectangle rect) {
        float rectYMax;
        float thisYMax;
        float rectXMax;
        float thisXMax;
        float diff;
        if (this.contains(rect)) {
            return;
        }
        if (rect.getX() < this.position.x) {
            diff = Math.abs(this.position.x - rect.getX());
            this.position.x = rect.getX();
            this.width += diff;
        }
        if (rect.getY() < this.position.y) {
            diff = Math.abs(this.position.y - rect.getY());
            this.position.y = rect.getY();
            this.height += diff;
        }
        if ((thisXMax = this.position.x + this.width) < (rectXMax = rect.getX() + rect.getWidth())) {
            this.width = Math.abs(rectXMax - this.position.x);
        }
        if ((thisYMax = this.position.y + this.height) < (rectYMax = rect.getY() + rect.getHeight())) {
            this.height = Math.abs(rectYMax - this.position.y);
        }
    }

    public boolean contains(Rectangle rect) {
        return this.position.x <= rect.getX() && this.position.x + this.width >= rect.getX() + rect.getWidth() && this.position.y <= rect.getY() && this.position.y + this.height >= rect.getY() + rect.getHeight();
    }

    public boolean contains(Vector2f point) {
        return point.x > this.position.x && point.y > this.position.y && point.x < this.position.x + this.width && point.y < this.position.y + this.height;
    }

    public boolean containsCircle(float x, float y, float radius) {
        float halfSize = radius / 2.0f;
        float boundsXMax = this.position.x + this.width;
        float boundsYMax = this.position.y + this.height;
        if (x - halfSize < this.position.x) {
            return false;
        }
        if (x + halfSize > boundsXMax) {
            return false;
        }
        if (y + halfSize > boundsYMax) {
            return false;
        }
        return !(y - halfSize < this.position.y);
    }

    public int findRegionForPoint(float x, float y) {
        int region = 0;
        if (x < this.position.x) {
            region |= 0xF00000;
        } else if (x > this.position.x + this.width) {
            region |= 0xF0000;
        }
        if (y < this.position.y) {
            region |= 0xF00;
        } else if (y > this.position.y + this.height) {
            region |= 0xF000;
        }
        return region;
    }

    public int findRegionForCircle(float x, float y, float radius) {
        int region = 0;
        if (x + radius < this.position.x) {
            region |= 0xF00000;
        } else if (x - radius > this.position.x + this.width) {
            region |= 0xF0000;
        }
        if (y + radius < this.position.y) {
            region |= 0xF00;
        } else if (y - radius > this.position.y + this.height) {
            region |= 0xF000;
        }
        return region;
    }

    public Classifier.Classification classifyCircle(float x, float y, float radius) {
        if (this.containsCircle(x, y, radius)) {
            return Classifier.INSIDE;
        }
        int region = this.findRegionForCircle(x, y, radius);
        if (region != 0) {
            return Classifier.OUTSIDE;
        }
        return Classifier.SPANNING;
    }

    public Classifier.Classification classifyLineSegment(LineSegment2D segment) {
        int region1 = this.findRegionForPoint(segment.getStartX(), segment.getStartY());
        int region2 = this.findRegionForPoint(segment.getEndX(), segment.getEndY());
        if (region1 == 0 && region2 == 0) {
            return Classifier.INSIDE;
        }
        int composed = region1 & region2;
        if (composed != 0) {
            return Classifier.OUTSIDE;
        }
        return Classifier.SPANNING;
    }

    public Classifier.Classification classifyCapsule(Capsule capsule) {
        int region1 = this.findRegionForCircle(capsule.getStartX(), capsule.getStartY(), capsule.getRadius());
        int region2 = this.findRegionForCircle(capsule.getEndX(), capsule.getEndY(), capsule.getRadius());
        if (region1 == 0 && region2 == 0) {
            return Classifier.INSIDE;
        }
        int composed = region1 & region2;
        if (composed != 0) {
            return Classifier.OUTSIDE;
        }
        return Classifier.SPANNING;
    }

    public boolean intersectsRect(Rectangle otherRect) {
        if (this.position.x + this.width >= otherRect.getX()) {
            return true;
        }
        if (this.position.x <= otherRect.getX() + otherRect.getWidth()) {
            return true;
        }
        if (this.position.y + this.height >= otherRect.getY()) {
            return true;
        }
        return this.position.y <= otherRect.getY() + otherRect.getHeight();
    }

    public void renderWireframe(float depth) {
        GL11.glBegin((int)2);
        GL11.glVertex3f((float)this.position.x, (float)this.position.y, (float)depth);
        GL11.glVertex3f((float)(this.position.x + this.width), (float)this.position.y, (float)depth);
        GL11.glVertex3f((float)(this.position.x + this.width), (float)(this.position.y + this.height), (float)depth);
        GL11.glVertex3f((float)this.position.x, (float)(this.position.y + this.height), (float)depth);
        GL11.glEnd();
    }
}

